/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmItsfHeader;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestChmItsfHeader {
    private ChmItsfHeader chmItsfHeader = null;

    @BeforeEach
    public void setUp() throws Exception {
        this.chmItsfHeader = new ChmItsfHeader();
        byte[] data = TestParameters.chmData;
        this.chmItsfHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)0, (int)95), this.chmItsfHeader);
    }

    @Test
    public void getDataOffset() {
        Assertions.assertEquals((long)4300L, (long)this.chmItsfHeader.getDataOffset());
    }

    @Test
    public void getDir_uuid() {
        Assertions.assertNotNull((Object)this.chmItsfHeader.getDir_uuid());
    }

    @Test
    public void getDirLen() {
        Assertions.assertEquals((long)4180L, (long)this.chmItsfHeader.getDirLen());
    }

    @Test
    public void getDirOffset() {
        Assertions.assertEquals((long)120L, (long)this.chmItsfHeader.getDirOffset());
    }

    @Test
    public void getHeaderLen() {
        Assertions.assertEquals((int)96, (int)this.chmItsfHeader.getHeaderLen());
    }

    @Test
    public void getLangId() {
        Assertions.assertEquals((long)1033L, (long)this.chmItsfHeader.getLangId());
    }

    @Test
    public void getLastModified() {
        Assertions.assertEquals((long)1042357880L, (long)this.chmItsfHeader.getLastModified());
    }

    @Test
    public void getUnknown_000c() {
        Assertions.assertEquals((int)1, (int)this.chmItsfHeader.getUnknown_000c());
    }

    @Test
    public void getUnknownLen() {
        Assertions.assertEquals((long)24L, (long)this.chmItsfHeader.getUnknownLen());
    }

    @Test
    public void getUnknownOffset() {
        Assertions.assertEquals((long)96L, (long)this.chmItsfHeader.getUnknownOffset());
    }

    @Test
    public void getVersion() {
        Assertions.assertEquals((int)3, (int)this.chmItsfHeader.getVersion());
    }

    @Test
    public void testToString() {
        Assertions.assertTrue((boolean)this.chmItsfHeader.toString().contains("ITSF"));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.chmItsfHeader = null;
    }
}

