/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.tika.MultiThreadedTikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.parser.microsoft.chm.ChmDirectoryListingSet;
import org.apache.tika.parser.microsoft.chm.ChmExtractor;
import org.apache.tika.parser.microsoft.chm.ChmParser;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TestChmExtraction
extends MultiThreadedTikaTest {
    private final Parser parser = new ChmParser();
    private final List<String> files = Arrays.asList("/test-documents/testChm.chm", "/test-documents/testChm2.chm", "/test-documents/testChm3.chm");

    @Test
    public void testGetText() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        new ChmParser().parse((InputStream)new ByteArrayInputStream(TestParameters.chmData), (ContentHandler)handler, new Metadata(), new ParseContext());
        Assertions.assertTrue((boolean)handler.toString().contains("The TCard method accepts only numeric arguments"));
    }

    @Test
    public void testChmParser() throws Exception {
        for (String fileName : this.files) {
            InputStream stream = this.getResourceAsStream(fileName);
            this.testingChm(stream);
        }
    }

    private void testingChm(InputStream stream) throws IOException, SAXException, TikaException {
        try {
            BodyContentHandler handler = new BodyContentHandler(-1);
            this.parser.parse(stream, (ContentHandler)handler, new Metadata(), new ParseContext());
            Assertions.assertTrue((!handler.toString().isEmpty() ? 1 : 0) != 0);
        }
        finally {
            stream.close();
        }
    }

    @Test
    public void testExtractChmEntries() throws TikaException, IOException {
        for (String fileName : this.files) {
            InputStream stream = this.getResourceAsStream(fileName);
            Throwable throwable = null;
            try {
                this.testExtractChmEntry(stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }

    protected boolean findZero(byte[] textData) {
        for (byte b : textData) {
            if (b != 0) continue;
            return true;
        }
        return false;
    }

    protected boolean niceAscFileName(String name) {
        for (char c : name.toCharArray()) {
            if (c < '\u007f' && c >= ' ') continue;
            return false;
        }
        return true;
    }

    protected void testExtractChmEntry(InputStream stream) throws TikaException, IOException {
        ChmExtractor chmExtractor = new ChmExtractor(stream);
        ChmDirectoryListingSet entries = chmExtractor.getChmDirList();
        Pattern htmlPairP = Pattern.compile("\\Q<html\\E.+\\Q</html>\\E", 42);
        HashSet<String> names = new HashSet<String>();
        for (DirectoryListingEntry directoryListingEntry : entries.getDirectoryListingEntryList()) {
            byte[] data = chmExtractor.extractChmEntry(directoryListingEntry);
            if (!this.niceAscFileName(directoryListingEntry.getName())) {
                throw new TikaException("Warning: File name contains a non ascii char : " + directoryListingEntry.getName());
            }
            String lowName = directoryListingEntry.getName().toLowerCase(Locale.ROOT);
            if (names.contains(lowName)) {
                throw new TikaException("Duplicate File name detected : " + directoryListingEntry.getName());
            }
            names.add(lowName);
            if (!lowName.endsWith(".html") && !lowName.endsWith(".htm") && !lowName.endsWith(".hhk") && !lowName.endsWith(".hhc")) continue;
            if (this.findZero(data)) {
                throw new TikaException("Xhtml/text file contains '\\0' : " + directoryListingEntry.getName());
            }
            String html = new String(data, StandardCharsets.ISO_8859_1);
            if (htmlPairP.matcher(html).find()) continue;
            System.err.println(lowName + " is invalid.");
            System.err.println(html);
            throw new TikaException("Invalid xhtml file : " + directoryListingEntry.getName());
        }
    }

    @Test
    public void testMultiThreadedChmExtraction() throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        for (int i = 0; i < 2; ++i) {
            executor.execute(() -> {
                for (String fileName : this.files) {
                    InputStream stream = null;
                    try {
                        stream = this.getResourceAsStream(fileName);
                        BodyContentHandler handler = new BodyContentHandler(-1);
                        this.parser.parse(stream, (ContentHandler)handler, new Metadata(), new ParseContext());
                        Assertions.assertFalse((boolean)handler.toString().isEmpty());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
            Thread.sleep(500L);
        }
    }

    @Test
    public void test_TIKA_1446() throws Exception {
        URL chmDir = this.getResourceAsUrl("/test-documents/chm/");
        File chmFolder = new File(chmDir.toURI());
        for (String fileName : chmFolder.list()) {
            File file = new File(chmFolder, fileName);
            FileInputStream stream = new FileInputStream(file);
            this.testingChm(stream);
        }
    }

    @Test
    public void testOOM() {
        Assertions.assertThrows(TikaException.class, () -> this.getXML("testChm_oom.chm"));
    }

    @Test
    public void testMultiThreaded() throws Exception {
        ParseContext[] parseContexts = new ParseContext[10];
        for (int i = 0; i < parseContexts.length; ++i) {
            parseContexts[i] = new ParseContext();
        }
        RecursiveParserWrapper wrapper = new RecursiveParserWrapper(AUTO_DETECT_PARSER);
        this.testMultiThreaded((Parser)wrapper, parseContexts, 10, 10, pathname -> {
            if (pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".chm")) {
                if (pathname.getName().equals("testChm2.chm")) {
                    return false;
                }
                return !pathname.getName().equals("testChm_oom.chm");
            }
            return false;
        });
    }
}

