/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.HashSet;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.detect.microsoft.POIFSContainerDetector;
import org.apache.tika.extractor.ContainerExtractor;
import org.apache.tika.extractor.ParserContainerExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.microsoft.AbstractPOIContainerExtractionTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class POIContainerExtractionTest
extends AbstractPOIContainerExtractionTest {
    @Test
    public void testWithoutEmbedded() throws Exception {
        String[] files;
        ParserContainerExtractor extractor = new ParserContainerExtractor();
        for (String file : files = new String[]{"testEXCEL.xls", "testWORD.doc", "testPPT.ppt", "testVISIO.vsd", "test-outlook.msg"}) {
            TikaTest.TrackingHandler handler = this.process(file, (ContainerExtractor)extractor, false);
            Assertions.assertEquals((int)0, (int)handler.filenames.size(), (String)file);
            Assertions.assertEquals((int)0, (int)handler.mediaTypes.size(), (String)file);
            handler = this.process(file, (ContainerExtractor)extractor, true);
            Assertions.assertEquals((int)0, (int)handler.filenames.size());
            Assertions.assertEquals((int)0, (int)handler.mediaTypes.size());
        }
    }

    @Test
    public void testEmbeddedImages() throws Exception {
        ParserContainerExtractor extractor = new ParserContainerExtractor();
        TikaTest.TrackingHandler handler = this.process("testEXCEL_1img.xls", (ContainerExtractor)extractor, false);
        Assertions.assertEquals((int)1, (int)handler.filenames.size());
        Assertions.assertEquals((int)1, (int)handler.mediaTypes.size());
        Assertions.assertEquals(null, handler.filenames.get(0));
        Assertions.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(0));
        handler = this.process("testWORD_1img.doc", (ContainerExtractor)extractor, false);
        Assertions.assertEquals((int)1, (int)handler.filenames.size());
        Assertions.assertEquals((int)1, (int)handler.mediaTypes.size());
        Assertions.assertEquals((Object)"image1.png", handler.filenames.get(0));
        Assertions.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(0));
        handler = this.process("testWORD_3imgs.doc", (ContainerExtractor)extractor, false);
        Assertions.assertEquals((int)3, (int)handler.filenames.size());
        Assertions.assertEquals((int)3, (int)handler.mediaTypes.size());
        Assertions.assertEquals((Object)"image1.png", handler.filenames.get(0));
        Assertions.assertEquals((Object)"image2.jpg", handler.filenames.get(1));
        Assertions.assertEquals((Object)"image3.png", handler.filenames.get(2));
        Assertions.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(0));
        Assertions.assertEquals((Object)TYPE_JPG, handler.mediaTypes.get(1));
        Assertions.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(2));
    }

    @Test
    public void testEmbeddedOfficeFilesXML() throws Exception {
        ParserContainerExtractor extractor = new ParserContainerExtractor();
        TikaTest.TrackingHandler handler = this.process("EmbeddedDocument.docx", (ContainerExtractor)extractor, false);
        Assertions.assertTrue((boolean)handler.filenames.contains("Microsoft_Office_Excel_97-2003_Worksheet1.bin"));
        Assertions.assertEquals((int)2, (int)handler.filenames.size());
    }

    @Test
    public void testPowerpointImages() throws Exception {
        ParserContainerExtractor extractor = new ParserContainerExtractor();
        TikaTest.TrackingHandler handler = this.process("pictures.ppt", (ContainerExtractor)extractor, false);
        Assertions.assertTrue((boolean)handler.mediaTypes.contains(new MediaType("image", "jpeg")));
        Assertions.assertTrue((boolean)handler.mediaTypes.contains(new MediaType("image", "png")));
    }

    @Test
    public void testEmbeddedStorageId() throws Exception {
        List list = this.getRecursiveMetadata("testWORD_embeded.doc");
        Assertions.assertEquals((Object)"{F4754C9B-64F5-4B40-8AF4-679732AC0607}", (Object)((Metadata)list.get(10)).get("embeddedStorageClassId"));
        Assertions.assertEquals((Object)"{64818D10-4F9B-11CF-86EA-00AA00B929E8}", (Object)((Metadata)list.get(14)).get("embeddedStorageClassId"));
        Assertions.assertEquals((Object)"{00020820-0000-0000-C000-000000000046}", (Object)((Metadata)list.get(16)).get("embeddedStorageClassId"));
    }

    @Test
    public void testEmbeddedGraphChart() throws Exception {
        for (String suffix : new String[]{"ppt", "xls"}) {
            List list = this.getRecursiveMetadata("testMSChart-govdocs-428996." + suffix);
            boolean found = false;
            for (Metadata m : list) {
                if (m.get("Content-Type").equals(POIFSContainerDetector.MS_GRAPH_CHART.toString())) {
                    found = true;
                }
                Assertions.assertNull((Object)m.get(TikaCoreProperties.EMBEDDED_EXCEPTION));
            }
            Assertions.assertTrue((boolean)found, (String)("didn't find chart in " + suffix));
        }
    }

    @Test
    public void testEmbeddedEquation() throws Exception {
        List metadataList = this.getRecursiveMetadata("testMSEquation-govdocs-863534.doc");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        Assertions.assertEquals((Object)"application/vnd.ms-equation", (Object)((Metadata)metadataList.get(2)).get("Content-Type"));
    }

    @Test
    public void testWPSVariantAttachments() throws Exception {
        HashSet<String> expected = new HashSet<String>();
        expected.add("application/msword");
        expected.add("application/vnd.ms-excel");
        expected.add("application/vnd.ms-powerpoint");
        expected.add("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        expected.add("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        expected.add("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        expected.add("application/pdf");
        expected.add("application/xml");
        expected.add("text/plain; charset=ISO-8859-1");
        for (String suffix : new String[]{"ppt", "doc", "xls", "docx", "pptx", "xlsx"}) {
            List metadataList = this.getRecursiveMetadata("testWPSAttachment." + suffix);
            HashSet<String> found = new HashSet<String>();
            int i = 0;
            for (Metadata m : metadataList) {
                if (i++ <= 0) continue;
                found.add(m.get("Content-Type"));
            }
            HashSet<String> notFound = new HashSet<String>();
            for (String ex : expected) {
                if (found.contains(ex)) continue;
                notFound.add(ex);
            }
            if (notFound.size() <= 0) continue;
            Assertions.fail((String)("Couldn't find: " + notFound));
        }
    }
}

