/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.apache.poi.util.LocaleUtil;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class ExcelParserTest
extends TikaTest {
    @Test
    public void testExcelParser() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testEXCEL.xls");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"Simple Excel document", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Keith Bennett", (Object)metadata.get(TikaCoreProperties.CREATOR));
            Assertions.assertEquals((Object)"2007-10-01T16:13:56Z", (Object)metadata.get(TikaCoreProperties.CREATED));
            Assertions.assertEquals((Object)"2007-10-01T16:31:43Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"Sample Excel Worksheet", (String)content);
            ExcelParserTest.assertContains((String)"Numbers and their Squares", (String)content);
            ExcelParserTest.assertContains((String)"\t\tNumber\tSquare", (String)content);
            ExcelParserTest.assertContains((String)"9", (String)content);
            ExcelParserTest.assertNotContained((String)"9.0", (String)content);
            ExcelParserTest.assertContains((String)"196", (String)content);
            ExcelParserTest.assertNotContained((String)"196.0", (String)content);
            ExcelParserTest.assertContains((String)"Numbers and their Squares\n\t\tNumber", (String)content);
            ExcelParserTest.assertContains((String)"\tSquare\n\t\t1", (String)content);
        }
        input = this.getResourceAsStream("/test-documents/testEXCEL.xls");
        var2_2 = null;
        try {
            OfficeParserConfig config = new OfficeParserConfig();
            config.setIncludeMissingRows(true);
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            context.set(OfficeParserConfig.class, (Object)config);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"Numbers and their Squares\n\t\n\t\n\t\tNumber", (String)content);
            ExcelParserTest.assertContains((String)"\tSquare\n\t\n\t\t1", (String)content);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (var2_2 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    input.close();
                }
            }
        }
    }

    @Test
    public void testExcelParserFormatting() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testEXCEL-formats.xls");){
            Metadata metadata = new Metadata();
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            BodyContentHandler handler = new BodyContentHandler();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)metadata.get("Content-Type"));
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"1,599.99", (String)content);
            ExcelParserTest.assertContains((String)"-1,599.99", (String)content);
            ExcelParserTest.assertContains((String)"$1,599.99", (String)content);
            ExcelParserTest.assertContains((String)"($1,599.99)", (String)content);
            Assertions.assertTrue((content.contains("1.98E08") || content.contains("1.98E+08") ? 1 : 0) != 0);
            Assertions.assertTrue((content.contains("-1.98E08") || content.contains("-1.98E+08") ? 1 : 0) != 0);
            ExcelParserTest.assertContains((String)"2.50%", (String)content);
            if (System.getProperty("java.version").startsWith("1.5")) {
                ExcelParserTest.assertContains((String)"2%", (String)content);
            } else {
                ExcelParserTest.assertContains((String)"3%", (String)content);
            }
            ExcelParserTest.assertContains((String)"6:15", (String)content);
            ExcelParserTest.assertContains((String)"18:15", (String)content);
            ExcelParserTest.assertContains((String)"17-May-07", (String)content);
            ExcelParserTest.assertContains((String)"10/3/09", (String)content);
            ExcelParserTest.assertContains((String)"1/19/08 4:35", (String)content);
            ExcelParserTest.assertContains((String)"2 1/2", (String)content);
        }
    }

    @Test
    public void testExcelParserPassword() throws Exception {
        ParseContext context;
        BodyContentHandler handler;
        Metadata metadata2;
        Throwable throwable;
        InputStream input2;
        try {
            input2 = this.getResourceAsStream("/test-documents/testEXCEL_protected_passtika.xls");
            throwable = null;
            try {
                metadata2 = new Metadata();
                handler = new BodyContentHandler();
                context = new ParseContext();
                context.set(Locale.class, (Object)Locale.US);
                new OfficeParser().parse(input2, (ContentHandler)handler, metadata2, context);
                Assertions.fail((String)"Document is encrypted, shouldn't parse");
            }
            catch (Throwable metadata2) {
                throwable = metadata2;
                throw metadata2;
            }
            finally {
                if (input2 != null) {
                    if (throwable != null) {
                        try {
                            input2.close();
                        }
                        catch (Throwable metadata2) {
                            throwable.addSuppressed(metadata2);
                        }
                    } else {
                        input2.close();
                    }
                }
            }
        }
        catch (EncryptedDocumentException input2) {
            // empty catch block
        }
        input2 = this.getResourceAsStream("/test-documents/testEXCEL_protected_passtika.xls");
        throwable = null;
        try {
            metadata2 = new Metadata();
            handler = new BodyContentHandler();
            context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            context.set(PasswordProvider.class, (Object)new PasswordProvider(){

                public String getPassword(Metadata metadata) {
                    return "tika";
                }
            });
            new OfficeParser().parse(input2, (ContentHandler)handler, metadata2, context);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)metadata2.get("Content-Type"));
            Assertions.assertNull((Object)metadata2.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Antoni", (Object)metadata2.get(TikaCoreProperties.CREATOR));
            Assertions.assertEquals((Object)"2011-11-25T09:52:48Z", (Object)metadata2.get(TikaCoreProperties.CREATED));
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"This is an Encrypted Excel spreadsheet", (String)content);
            ExcelParserTest.assertNotContained((String)"9.0", (String)content);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (input2 != null) {
                if (throwable != null) {
                    try {
                        input2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    input2.close();
                }
            }
        }
    }

    @Test
    public void testExcelParserCharts() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testEXCEL-charts.xls");){
            Metadata metadata = new Metadata();
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            BodyContentHandler handler = new BodyContentHandler();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)metadata.get("Content-Type"));
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"charttabyodawg", (String)content);
            ExcelParserTest.assertContains((String)"WhamPuff", (String)content);
            ExcelParserTest.assertContains((String)"Sheet1", (String)content);
            ExcelParserTest.assertContains((String)"Test Excel Spreasheet", (String)content);
            ExcelParserTest.assertContains((String)"foo", (String)content);
            ExcelParserTest.assertContains((String)"bar", (String)content);
            ExcelParserTest.assertContains((String)"fizzlepuff", (String)content);
            ExcelParserTest.assertContains((String)"whyaxis", (String)content);
            ExcelParserTest.assertContains((String)"eksaxis", (String)content);
            ExcelParserTest.assertContains((String)"Sheet2", (String)content);
            ExcelParserTest.assertContains((String)"dingdong", (String)content);
        }
    }

    @Test
    public void testJXL() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/jxl.xls");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler(-1);
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)metadata.get("Content-Type"));
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"Number Formats", (String)content);
        }
    }

    @Test
    public void testWorksSpreadsheet70() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testWORKSSpreadsheet7.0.xlr");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler(-1);
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"Microsoft Works", (String)content);
        }
    }

    @Test
    public void testExcel95() throws Exception {
        String content;
        ParseContext context;
        BodyContentHandler handler2;
        MediaType type;
        DefaultDetector detector = new DefaultDetector();
        Metadata m = new Metadata();
        m.add("resourceName", "excel_5.xls");
        try (InputStream input = this.getResourceAsStream("/test-documents/testEXCEL_5.xls");){
            type = detector.detect(input, m);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)type.toString());
        }
        m = new Metadata();
        m.add("resourceName", "excel_95.xls");
        input = this.getResourceAsStream("/test-documents/testEXCEL_95.xls");
        var5_4 = null;
        try {
            type = detector.detect(input, m);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)type.toString());
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (var5_4 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    input.close();
                }
            }
        }
        Assertions.assertEquals((Object)true, (Object)new OfficeParser().getSupportedTypes(new ParseContext()).contains(type));
        Assertions.assertEquals((Object)false, (Object)new OOXMLParser().getSupportedTypes(new ParseContext()).contains(type));
        m = new Metadata();
        input = this.getResourceAsStream("/test-documents/testEXCEL_5.xls");
        var5_4 = null;
        try {
            handler2 = new BodyContentHandler(-1);
            context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            AUTO_DETECT_PARSER.parse(input, (ContentHandler)handler2, m, context);
            content = handler2.toString();
            ExcelParserTest.assertContains((String)"Feuil1", (String)content);
            ExcelParserTest.assertContains((String)"Feuil3", (String)content);
            ExcelParserTest.assertContains((String)"Sample Excel", (String)content);
            ExcelParserTest.assertContains((String)"Number", (String)content);
            ExcelParserTest.assertContains((String)"15", (String)content);
            ExcelParserTest.assertContains((String)"225", (String)content);
            Assertions.assertEquals((Object)"Simple Excel document", (Object)m.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Keith Bennett", (Object)m.get(TikaCoreProperties.CREATOR));
        }
        catch (Throwable handler2) {
            var5_4 = handler2;
            throw handler2;
        }
        finally {
            if (input != null) {
                if (var5_4 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable handler2) {
                        var5_4.addSuppressed(handler2);
                    }
                } else {
                    input.close();
                }
            }
        }
        m = new Metadata();
        input = this.getResourceAsStream("/test-documents/testEXCEL_95.xls");
        var5_4 = null;
        try {
            handler2 = new BodyContentHandler(-1);
            context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            AUTO_DETECT_PARSER.parse(input, (ContentHandler)handler2, m, context);
            content = handler2.toString();
            ExcelParserTest.assertContains((String)"Foglio1", (String)content);
            Assertions.assertEquals(null, (Object)m.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Marco Quaranta", (Object)m.get(Office.LAST_AUTHOR));
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (var5_4 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    input.close();
                }
            }
        }
    }

    @Test
    public void testCustomProperties() throws Exception {
        Metadata metadata = new Metadata();
        try (InputStream input = this.getResourceAsStream("/test-documents/testEXCEL_custom_props.xls");){
            BodyContentHandler handler = new BodyContentHandler(-1);
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.US);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
        }
        Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)metadata.get("Content-Type"));
        Assertions.assertNull((Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertNull((Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"2011-08-22T13:45:54Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"2006-09-12T15:06:44Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"Microsoft Excel", (Object)metadata.get(OfficeOpenXMLExtended.APPLICATION));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("custom:myCustomBoolean"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("custom:myCustomNumber"));
        Assertions.assertEquals((Object)"MyStringValue", (Object)metadata.get("custom:MyCustomString"));
        Assertions.assertEquals((Object)"2010-12-30T22:00:00Z", (Object)metadata.get("custom:MyCustomDate"));
        Assertions.assertEquals((Object)"2010-12-29T22:00:00Z", (Object)metadata.get("custom:myCustomSecondDate"));
    }

    @Test
    public void testHeaderAndFooterExtraction() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testEXCEL_headers_footers.xls");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.UK);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"Internal spreadsheet", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Aeham Abushwashi", (Object)metadata.get(TikaCoreProperties.CREATOR));
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"John Smith1", (String)content);
            ExcelParserTest.assertContains((String)"John Smith50", (String)content);
            ExcelParserTest.assertContains((String)"1 Corporate HQ", (String)content);
            ExcelParserTest.assertContains((String)"Header - Corporate Spreadsheet", (String)content);
            ExcelParserTest.assertContains((String)"Header - For Internal Use Only", (String)content);
            ExcelParserTest.assertContains((String)"Header - Author: John Smith", (String)content);
            ExcelParserTest.assertContains((String)"Footer - Corporate Spreadsheet", (String)content);
            ExcelParserTest.assertContains((String)"Footer - For Internal Use Only", (String)content);
            ExcelParserTest.assertContains((String)"Footer - Author: John Smith", (String)content);
        }
    }

    @Test
    public void testHeaderAndFooterNotExtraction() throws Exception {
        try (InputStream input = this.getResourceAsStream("/test-documents/testEXCEL_headers_footers.xls");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            ParseContext context = new ParseContext();
            context.set(Locale.class, (Object)Locale.UK);
            OfficeParserConfig officeParserConfig = new OfficeParserConfig();
            officeParserConfig.setIncludeHeadersAndFooters(false);
            context.set(OfficeParserConfig.class, (Object)officeParserConfig);
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, context);
            Assertions.assertEquals((Object)"application/vnd.ms-excel", (Object)metadata.get("Content-Type"));
            String content = handler.toString();
            ExcelParserTest.assertContains((String)"John Smith1", (String)content);
            ExcelParserTest.assertContains((String)"John Smith50", (String)content);
            ExcelParserTest.assertContains((String)"1 Corporate HQ", (String)content);
            ExcelParserTest.assertNotContained((String)"Header - Corporate Spreadsheet", (String)content);
            ExcelParserTest.assertNotContained((String)"Header - For Internal Use Only", (String)content);
            ExcelParserTest.assertNotContained((String)"Header - Author: John Smith", (String)content);
            ExcelParserTest.assertNotContained((String)"Footer - Corporate Spreadsheet", (String)content);
            ExcelParserTest.assertNotContained((String)"Footer - For Internal Use Only", (String)content);
            ExcelParserTest.assertNotContained((String)"Footer - Author: John Smith", (String)content);
        }
    }

    @Test
    public void testHyperlinksInXLS() throws Exception {
        String xml = this.getXML((String)"testEXCEL_hyperlinks.xls").xml;
        ExcelParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\">", (String)xml);
        ExcelParserTest.assertContains((String)"<a href=\"mailto:user@tika.apache.org?subject=help\">", (String)xml);
        ExcelParserTest.assertContains((String)"<a href=\"linked_file.txt.htm\">", (String)xml);
    }

    @Test
    public void testBigIntegersWGeneralFormat() throws Exception {
        String xml = this.getXML((String)"testEXCEL_big_numbers.xls").xml;
        ExcelParserTest.assertContains((String)"123456789012345", (String)xml);
        ExcelParserTest.assertContains((String)"123456789012346", (String)xml);
        Locale locale = LocaleUtil.getUserLocale();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        ExcelParserTest.assertContains((String)("1" + symbols.getDecimalSeparator() + "23456789012345E+15</td>\t<td>1" + symbols.getDecimalSeparator() + "23456789012345E+15"), (String)xml);
    }

    @Test
    public void testMacros() throws Exception {
        for (Metadata metadata : this.getRecursiveMetadata("testEXCEL_macro.xls")) {
            if (!metadata.get("Content-Type").equals("text/x-vbasic")) continue;
            Assertions.fail((String)"Shouldn't have extracted macros as default");
        }
        ParseContext context = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        Metadata minExpected = new Metadata();
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "Sub Dirty()");
        minExpected.add(TikaCoreProperties.TIKA_CONTENT.getName(), "dirty dirt dirt");
        minExpected.add("Content-Type", "text/x-vbasic");
        minExpected.add(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        ExcelParserTest.assertContainsAtLeast((Metadata)minExpected, (List)this.getRecursiveMetadata("testEXCEL_macro.xls", context));
        try (InputStream is = this.getResourceAsStream("tika-config-macros.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser parser = new AutoDetectParser(tikaConfig);
            ExcelParserTest.assertContainsAtLeast((Metadata)minExpected, (List)this.getRecursiveMetadata("testEXCEL_macro.xls", (Parser)parser));
        }
    }

    @Test
    public void testTextBox() throws Exception {
        String xml = this.getXML((String)"testEXCEL_textbox.xls").xml;
        ExcelParserTest.assertContains((String)"autoshape", (String)xml);
    }

    @Test
    public void testTurningOffTextBoxExtractionExcel() throws Exception {
        ParseContext pc = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setIncludeShapeBasedContent(false);
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        String xml = this.getXML((String)"testEXCEL_textbox.xls", (ParseContext)pc).xml;
        ExcelParserTest.assertNotContained((String)"autoshape", (String)xml);
    }

    @Test
    public void testPhoneticStrings() throws Exception {
        ExcelParserTest.assertContains((String)"\u65e5\u672c\u30aa\u30e9\u30af\u30eb \u30cb\u30db\u30f3", (String)this.getXML((String)"testEXCEL_phonetic.xls").xml);
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setConcatenatePhoneticRuns(false);
        ParseContext pc = new ParseContext();
        pc.set(OfficeParserConfig.class, (Object)officeParserConfig);
        ExcelParserTest.assertNotContained((String)"\u65e5\u672c\u30aa\u30e9\u30af\u30eb \u30cb\u30db\u30f3", (String)this.getXML((String)"testEXCEL_phonetic.xls", (ParseContext)pc).xml);
        TikaConfig tikaConfig = new TikaConfig(this.getResourceAsStream("tika-config-exclude-phonetic.xml"));
        AutoDetectParser parser = new AutoDetectParser(tikaConfig);
        ExcelParserTest.assertNotContained((String)"\u65e5\u672c\u30aa\u30e9\u30af\u30eb \u30cb\u30db\u30f3", (String)this.getXML((String)"testEXCEL_phonetic.xls", (Parser)parser).xml);
    }

    @Test
    public void testLabelsAreExtracted() throws Exception {
        String xml = this.getXML((String)"testEXCEL_labels-govdocs-515858.xls").xml;
        ExcelParserTest.assertContains((String)"Morocco", (String)xml);
    }

    @Test
    public void testWorkBookInCapitals() throws Exception {
        String xml = this.getXML((String)"testEXCEL_WORKBOOK_in_capitals.xls").xml;
        ExcelParserTest.assertContains((String)"Inventarliste", (String)xml);
    }

    @Test
    public void testDateFormat() throws Exception {
        try (InputStream is = this.getResourceAsStream("tika-config-custom-date-override.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            String xml = this.getXML((String)"testEXCEL_dateFormats.xls", (Parser)p).xml;
            ExcelParserTest.assertContains((String)"2018-09-20", (String)xml);
            ExcelParserTest.assertContains((String)"1996-08-10", (String)xml);
        }
    }
}

