/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.xml;

import java.io.File;
import java.io.FileFilter;
import org.apache.tika.MultiThreadedTikaTest;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.utils.XMLReaderUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class XML2003ParserTest
extends MultiThreadedTikaTest {
    @AfterClass
    public static void tearDown() throws TikaException {
        XMLReaderUtils.setPoolSize((int)10);
    }

    @Test
    public void testBasicExcel() throws Exception {
        TikaTest.XMLResult r = this.getXML("testEXCEL2003.xml");
        Metadata m = r.metadata;
        Assert.assertEquals((Object)"Allison, Timothy B.", (Object)m.get(TikaCoreProperties.CREATOR));
        Assert.assertEquals((Object)"16.00", (Object)m.get(OfficeOpenXMLCore.VERSION));
        Assert.assertEquals((Object)"application/vnd.ms-spreadsheetml", (Object)m.get("Content-Type"));
        String xml = r.xml;
        xml = xml.replaceAll("\\s+", " ");
        XML2003ParserTest.assertContains((String)"<meta name=\"cp:version\" content=\"16.00\" />", (String)xml);
        XML2003ParserTest.assertContains((String)"<tr> <td>Col1</td> <td>Col2</td>", (String)xml);
        XML2003ParserTest.assertContains((String)"<td>2016-04-27T00:00:00.000</td>", (String)xml);
        XML2003ParserTest.assertContains((String)"<a href=\"https://tika.apache.org/\">tika_hyperlink</a>", (String)xml);
        XML2003ParserTest.assertContains((String)"<td>5.5</td>", (String)xml);
        String txt = this.getText(this.getResourceAsStream("/test-documents/testEXCEL2003.xml"), AUTO_DETECT_PARSER);
        txt = txt.replaceAll("\\s+", " ");
        XML2003ParserTest.assertContains((String)"Col1 Col2 Col3 Col4 string 1 1.10", (String)txt);
    }

    @Test(timeout=60000L)
    public void testMultiThreaded() throws Exception {
        XMLReaderUtils.setPoolSize((int)4);
        int numThreads = XMLReaderUtils.getPoolSize() * 2;
        ParseContext[] contexts = new ParseContext[numThreads];
        for (int i = 0; i < contexts.length; ++i) {
            contexts[i] = new ParseContext();
        }
        this.testMultiThreaded(AUTO_DETECT_PARSER, contexts, numThreads, 2, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().equals("testWORD2003.xml");
            }
        });
    }
}

