/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.pst;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.pst.OutlookPSTParser;
import org.apache.tika.sax.ToHTMLContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OutlookPSTParserTest
extends TikaTest {
    private Parser parser = new OutlookPSTParser();

    @Test
    public void testAccept() throws Exception {
        Assert.assertTrue((boolean)this.parser.getSupportedTypes(null).contains(MediaType.application((String)"vnd.ms-outlook-pst")));
    }

    @Test
    public void testParse() throws Exception {
        Metadata metadata = new Metadata();
        ToHTMLContentHandler handler = new ToHTMLContentHandler();
        ParseContext context = new ParseContext();
        EmbeddedTrackingExtrator trackingExtrator = new EmbeddedTrackingExtrator(context);
        context.set(EmbeddedDocumentExtractor.class, (Object)trackingExtrator);
        context.set(Parser.class, (Object)new AutoDetectParser());
        AUTO_DETECT_PARSER.parse(this.getResourceAsStream("/test-documents/testPST.pst"), (ContentHandler)handler, metadata, context);
        String output = handler.toString();
        Assert.assertFalse((boolean)output.isEmpty());
        Assert.assertTrue((boolean)output.contains("<meta name=\"Content-Length\" content=\"2302976\">"));
        Assert.assertTrue((boolean)output.contains("<meta name=\"Content-Type\" content=\"application/vnd.ms-outlook-pst\">"));
        Assert.assertTrue((boolean)output.contains("<body><div class=\"email-folder\"><h1>"));
        Assert.assertTrue((boolean)output.contains("<div class=\"embedded\" id=\"&lt;530D9CAC.5080901@gmail.com&gt;\"><h1>Re: Feature Generators</h1>"));
        Assert.assertTrue((boolean)output.contains("<div class=\"embedded\" id=\"&lt;1393363252.28814.YahooMailNeo@web140906.mail.bf1.yahoo.com&gt;\"><h1>Re: init tokenizer fails: \"Bad type in putfield/putstatic\"</h1>"));
        Assert.assertTrue((boolean)output.contains("Gary Murphy commented on TIKA-1250:"));
        Assert.assertTrue((boolean)output.contains("<div class=\"email-folder\"><h1>Racine (pour la recherche)</h1>"));
        Assert.assertTrue((boolean)output.contains("This is a docx attachment."));
        List<Metadata> metaList = trackingExtrator.trackingMetadata;
        Assert.assertEquals((long)9L, (long)metaList.size());
        Metadata firstMail = metaList.get(0);
        Assert.assertEquals((Object)"J\u00f6rn Kottmann", (Object)firstMail.get(TikaCoreProperties.CREATOR));
        Assert.assertEquals((Object)"Re: Feature Generators", (Object)firstMail.get(TikaCoreProperties.TITLE));
        Assert.assertEquals((Object)"kottmann@gmail.com", (Object)firstMail.get("senderEmailAddress"));
        Assert.assertEquals((Object)"users@opennlp.apache.org", (Object)firstMail.get("displayTo"));
        Assert.assertEquals((Object)"", (Object)firstMail.get("displayCC"));
        Assert.assertEquals((Object)"", (Object)firstMail.get("displayBCC"));
    }

    @Test
    public void testExtendedMetadata() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPST.pst");
        Metadata m1 = (Metadata)metadataList.get(1);
        Assert.assertEquals((Object)"J\u00f6rn Kottmann", (Object)m1.get(Message.MESSAGE_FROM_NAME));
        Assert.assertEquals((Object)"kottmann@gmail.com", (Object)m1.get(Message.MESSAGE_FROM_EMAIL));
        Assert.assertEquals((Object)"J\u00f6rn Kottmann", (Object)m1.get(Office.MAPI_FROM_REPRESENTING_NAME));
        Assert.assertEquals((Object)"kottmann@gmail.com", (Object)m1.get(Office.MAPI_FROM_REPRESENTING_EMAIL));
        Assert.assertEquals((Object)"NOTE", (Object)m1.get(Office.MAPI_MESSAGE_CLASS));
        Metadata m6 = (Metadata)metadataList.get(6);
        Assert.assertEquals((Object)"Couchbase", (Object)m6.get(Message.MESSAGE_FROM_NAME));
        Assert.assertEquals((Object)"couchbase@couchbase.com", (Object)m6.get(Message.MESSAGE_FROM_EMAIL));
        Assert.assertEquals((Object)"Couchbase", (Object)m6.get(Office.MAPI_FROM_REPRESENTING_NAME));
        Assert.assertEquals((Object)"couchbase@couchbase.com", (Object)m6.get(Office.MAPI_FROM_REPRESENTING_EMAIL));
        Assert.assertEquals((Object)"NOTE", (Object)m1.get(Office.MAPI_MESSAGE_CLASS));
        Assert.assertEquals((Object)"/o=ExchangeLabs/ou=Exchange Administrative Group (FYDIBOHF23SPDLT)/cn=Recipients/cn=polyspot1.onmicrosoft.com-50609-Hong-Thai.Ng", (Object)m6.get(Message.MESSAGE_TO_EMAIL));
        Assert.assertEquals((Object)"Hong-Thai Nguyen", (Object)m6.get(Message.MESSAGE_TO_DISPLAY_NAME));
        Assert.assertEquals((Object)"Couchbase", (Object)m6.get(Message.MESSAGE_FROM_NAME));
        Assert.assertEquals((Object)"couchbase@couchbase.com", (Object)m6.get(Message.MESSAGE_FROM_EMAIL));
        OutlookPSTParserTest.assertContains((String)"2014-02-26", (String)m1.get(Office.MAPI_MESSAGE_CLIENT_SUBMIT_TIME));
    }

    @Test
    public void testOverrideDetector() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPST_variousBodyTypes.pst");
        Assert.assertEquals((long)5L, (long)metadataList.size());
        for (Metadata metadata : metadataList) {
            for (String v : metadata.getValues(TikaCoreProperties.TIKA_PARSED_BY)) {
                if (!v.contains("RFC822Parser")) continue;
                Assert.fail((String)"RFCParser should never be called");
            }
        }
    }

    private class EmbeddedTrackingExtrator
    extends ParsingEmbeddedDocumentExtractor {
        List<Metadata> trackingMetadata;

        public EmbeddedTrackingExtrator(ParseContext context) {
            super(context);
            this.trackingMetadata = new ArrayList<Metadata>();
        }

        public boolean shouldParseEmbedded(Metadata metadata) {
            return true;
        }

        public void parseEmbedded(InputStream stream, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
            this.trackingMetadata.add(metadata);
            super.parseEmbedded(stream, handler, metadata, outputHtml);
        }
    }
}

