/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml.xps;

import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.junit.Assert;
import org.junit.Test;

public class XPSParserTest
extends TikaTest {
    @Test
    public void testBasic() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT.xps");
        Assert.assertEquals((long)2L, (long)metadataList.size());
        Assert.assertEquals((Object)"Rajiv", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CREATOR));
        Assert.assertEquals((Object)"2010-06-29T12:06:31Z", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CREATED));
        Assert.assertEquals((Object)"2010-06-29T12:06:31Z", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.MODIFIED));
        Assert.assertEquals((Object)"Attachment Test", (Object)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TITLE));
        String content = ((Metadata)metadataList.get(0)).get(RecursiveParserWrapper.TIKA_CONTENT);
        XPSParserTest.assertContains((String)"<p>Attachment Test</p>", (String)content);
        XPSParserTest.assertContains((String)"<div class=\"canvas\"><p>Different", (String)content);
        XPSParserTest.assertContains((String)"tikacontent", (String)content);
        Assert.assertEquals((Object)"image/jpeg", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
    }

    @Test
    public void testVarious() throws Exception {
        List metadataList = this.getRecursiveMetadata("testXPS_various.xps");
        Assert.assertEquals((long)4L, (long)metadataList.size());
        String quickBrownFox = "\u0644\u062b\u0639\u0644\u0628 \u0627\u0644\u0628\u0646\u064a \u0627\u0644\u0633\u0631\u064a\u0639";
        String content = ((Metadata)metadataList.get(0)).get(RecursiveParserWrapper.TIKA_CONTENT);
        XPSParserTest.assertContains((String)quickBrownFox, (String)content);
        XPSParserTest.assertContains((String)"The \u0627\u0644\u0628\u0646\u064a fox", (String)content);
        XPSParserTest.assertContains((String)"\u0644\u062b\u0639\u0644\u0628 brown \u0627\u0644\u0633\u0631\u064a\u0639", (String)content);
        XPSParserTest.assertContains((String)"<a href=\"http://tika.apache.org/\">http://tika.apache.org/</a>", (String)content);
        Metadata metadata = (Metadata)metadataList.get(0);
        Assert.assertEquals((Object)"Allison, Timothy B.", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assert.assertEquals((Object)"2017-12-12T11:15:38Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assert.assertEquals((Object)"2017-12-12T11:15:38Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assert.assertEquals((Object)"image/png", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Metadata inlineJpeg = (Metadata)metadataList.get(2);
        Assert.assertEquals((Object)"image/jpeg", (Object)inlineJpeg.get("Content-Type"));
        XPSParserTest.assertContains((String)"INetCache", (String)inlineJpeg.get(TikaCoreProperties.ORIGINAL_RESOURCE_NAME));
        Assert.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.INLINE.toString(), (Object)inlineJpeg.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assert.assertEquals((Object)"image/jpeg", (Object)((Metadata)metadataList.get(3)).get("Content-Type"));
    }
}

