/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class SXSLFExtractorTest
extends TikaTest {
    private ParseContext parseContext;
    OfficeParserConfig officeParserConfig = new OfficeParserConfig();

    @Before
    public void setUp() {
        this.parseContext = new ParseContext();
        this.officeParserConfig.setUseSAXPptxExtractor(true);
        this.parseContext.set(OfficeParserConfig.class, (Object)this.officeParserConfig);
    }

    @Test
    public void basicTest() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT_various2.pptx", this.parseContext);
        Assert.assertEquals((String)"right number of attachments", (long)14L, (long)metadataList.size());
        String mainContent = ((Metadata)metadataList.get(0)).get(RecursiveParserWrapper.TIKA_CONTENT);
        SXSLFExtractorTest.assertContains((String)"This slide is hidden", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"FirstBullet", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"<a href=\"http://tika.apache.org/\">tika_hyperlink</a>", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"<a href=\"http://lucene.apache.org/\">lucene_hyperlink</a>", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"Slide2TextBox", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"<td>R1c1</td>", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"This is some WordART", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"NotesForSlide2", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"Notes for slide3", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"NotesMasterHeader", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"NotesMasterFooter", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"NotesMasterPageNumber", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"NotesWordArt", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"NotesWordArtPage2", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"NotesTableSlide2", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"<p class=\"slide-comment\"><b>Timothy Allison (TA)</b>This is a reply to the initial comment</p>", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"HandoutHeader1", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"HandoutFooter", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"HandoutDate", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"TextBoxInHandOut", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"MASTERTEXTBOX", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"3/4", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"<p>12/16/2016</p>", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"<p>8</p>", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"<td>NotesTableSlide2", (String)mainContent);
        SXSLFExtractorTest.assertContains((String)"MASTERFOOTERMSG", (String)mainContent);
        SXSLFExtractorTest.assertNotContained((String)"Click to edit Master", (String)mainContent);
        SXSLFExtractorTest.assertNotContained((String)"Second level", (String)mainContent);
    }

    @Test
    public void poiBug54916Test() throws Exception {
        String xml = this.getXML((String)"testPPTX_overlappingRelations.pptx", (ParseContext)this.parseContext).xml;
        SXSLFExtractorTest.assertContains((String)"POI cannot read this", (String)xml);
        SXSLFExtractorTest.assertContains((String)"Has a relationship to another slide", (String)xml);
        SXSLFExtractorTest.assertContains((String)"can read this too", (String)xml);
    }

    @Test
    public void testPowerPoint() throws Exception {
        String[] extensions = new String[]{"pptx", "pptm", "ppsm", "ppsx", "potm"};
        String[] mimeTypes = new String[]{"application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.template.macroenabled.12"};
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            String filename = "testPPT." + extension;
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            try (InputStream input = this.getResourceAsStream("/test-documents/" + filename);){
                AUTO_DETECT_PARSER.parse(input, (ContentHandler)handler, metadata, this.parseContext);
                Assert.assertEquals((String)("Mime-type checking for " + filename), (Object)mimeTypes[i], (Object)metadata.get("Content-Type"));
                Assert.assertEquals((Object)"Attachment Test", (Object)metadata.get(TikaCoreProperties.TITLE));
                Assert.assertEquals((Object)"Rajiv", (Object)metadata.get(TikaCoreProperties.CREATOR));
                String content = handler.toString();
                if (extension.equals("thmx")) {
                    Assert.assertEquals((Object)"", (Object)content);
                    continue;
                }
                Assert.assertTrue((String)("Text missing for " + filename + "\n" + content), (boolean)content.contains("Attachment Test"));
                Assert.assertTrue((String)("Text missing for " + filename + "\n" + content), (boolean)content.contains("This is a test file data with the same content"));
                Assert.assertTrue((String)("Text missing for " + filename + "\n" + content), (boolean)content.contains("content parsing"));
                Assert.assertTrue((String)("Text missing for " + filename + "\n" + content), (boolean)content.contains("Different words to test against"));
                Assert.assertTrue((String)("Text missing for " + filename + "\n" + content), (boolean)content.contains("Mystery"));
                continue;
            }
        }
    }

    @Test
    public void testPowerPointMetadataEarly() throws Exception {
        String[] extensions = new String[]{"pptx", "pptm", "ppsm", "ppsx", "potm"};
        final String[] mimeTypes = new String[]{"application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.template.macroenabled.12"};
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            final String filename = "testPPT." + extension;
            final Metadata metadata = new Metadata();
            final int currentI = i++;
            BodyContentHandler handler = new BodyContentHandler(){

                public void startDocument() {
                    Assert.assertEquals((String)("Mime-type checking for " + filename), (Object)mimeTypes[currentI], (Object)metadata.get("Content-Type"));
                    Assert.assertEquals((Object)"Attachment Test", (Object)metadata.get(TikaCoreProperties.TITLE));
                    Assert.assertEquals((Object)"Rajiv", (Object)metadata.get(TikaCoreProperties.CREATOR));
                }
            };
            try (InputStream input = this.getResourceAsStream("/test-documents/" + filename);){
                AUTO_DETECT_PARSER.parse(input, (ContentHandler)handler, metadata, this.parseContext);
            }
        }
    }

    @Test
    public void testUnsupportedPowerPoint() throws Exception {
        String[] extensions = new String[]{"xps", "thmx"};
        String[] mimeTypes = new String[]{"application/vnd.ms-xpsdocument", "application/vnd.openxmlformats-officedocument"};
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            String filename = "testPPT." + extension;
            Metadata metadata = new Metadata();
            metadata.set("resourceName", filename);
            BodyContentHandler handler = new BodyContentHandler();
            try (InputStream input = this.getResourceAsStream("/test-documents/" + filename);){
                AUTO_DETECT_PARSER.parse(input, (ContentHandler)handler, metadata, this.parseContext);
                Assert.assertEquals((String)("Mime-type checking for " + filename), (Object)mimeTypes[i], (Object)metadata.get("Content-Type"));
                continue;
            }
        }
    }

    @Test
    public void testVariousPPTX() throws Exception {
        int row;
        Metadata metadata = new Metadata();
        String xml = this.getXML((String)"testPPT_various.pptx", (Metadata)metadata, (ParseContext)this.parseContext).xml;
        SXSLFExtractorTest.assertContains((String)"<p>Footnote appears here", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>[1] This is a footnote.", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>This is the header text.</p>", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>This is the footer text.</p>", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>Here is a text box</p>", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>Bold", (String)xml);
        SXSLFExtractorTest.assertContains((String)"italic underline superscript subscript", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>Here is a citation:", (String)xml);
        SXSLFExtractorTest.assertContains((String)"Figure 1 This is a caption for Figure 1", (String)xml);
        SXSLFExtractorTest.assertContains((String)"(Kramer)", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<table><tr>\t<td>Row 1 Col 1</td>", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<td>Row 2 Col 2</td>\t<td>Row 2 Col 3</td></tr>", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>Row 1 column 1</p>", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>Row 2 column 2</p>", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p><a href=\"http://tika.apache.org/\">This is a hyperlink</a>", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<p>Here is a list:", (String)xml);
        for (row = 1; row <= 3; ++row) {
            SXSLFExtractorTest.assertContains((String)("<p>Bullet " + row), (String)xml);
        }
        SXSLFExtractorTest.assertContains((String)"Here is a numbered list:", (String)xml);
        for (row = 1; row <= 3; ++row) {
            SXSLFExtractorTest.assertContains((String)("<p>Number bullet " + row), (String)xml);
        }
        for (row = 1; row <= 2; ++row) {
            for (int col = 1; col <= 3; ++col) {
                SXSLFExtractorTest.assertContains((String)("Row " + row + " Col " + col), (String)xml);
            }
        }
        SXSLFExtractorTest.assertContains((String)"Keyword1 Keyword2", (String)xml);
        Assert.assertEquals((Object)"Keyword1 Keyword2", (Object)metadata.get(Office.KEYWORDS));
        SXSLFExtractorTest.assertContains((String)"Subject is here", (String)xml);
        SXSLFExtractorTest.assertContains((String)"Suddenly some Japanese text:", (String)xml);
        SXSLFExtractorTest.assertContains((String)"\uff08\uff27\uff28\uff31\uff09", (String)xml);
        SXSLFExtractorTest.assertContains((String)"\u30be\u30eb\u30b2\u3068\u5c3e\u5d0e\u3001\u6de1\u3005\u3068\u6700\u671f", (String)xml);
        SXSLFExtractorTest.assertContains((String)"And then some Gothic text:", (String)xml);
        SXSLFExtractorTest.assertContains((String)"\ud800\udf32\ud800\udf3f\ud800\udf44\ud800\udf39\ud800\udf43\ud800\udf3a", (String)xml);
    }

    @Test
    public void testCommentPPTX() throws Exception {
        TikaTest.XMLResult r = this.getXML("testPPT_comment.pptx", this.parseContext);
        SXSLFExtractorTest.assertContains((String)"<p class=\"slide-comment\"><b>Allison, Timothy B. (ATB)", (String)r.xml);
    }

    @Test
    public void testMasterFooter() throws Exception {
        SXSLFExtractorTest.assertContains((String)"Master footer is here", (String)this.getXML((String)"testPPT_masterFooter.pptx", (ParseContext)this.parseContext).xml);
    }

    @Test
    @Ignore(value="can't tell why this isn't working")
    public void testTurningOffMasterContent() throws Exception {
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        config.setUseSAXPptxExtractor(true);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        String xml = this.getXML((String)"testPPT_masterFooter.pptx", (ParseContext)context).xml;
        SXSLFExtractorTest.assertNotContained((String)"Master footer", (String)xml);
    }

    @Test
    public void testMasterText() throws Exception {
        SXSLFExtractorTest.assertContains((String)"Text that I added to the master slide", (String)this.getXML((String)"testPPT_masterText.pptx", (ParseContext)this.parseContext).xml);
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        config.setUseSAXPptxExtractor(true);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        SXSLFExtractorTest.assertNotContained((String)"Text that I added", (String)this.getXML((String)"testPPT_masterText.pptx", (ParseContext)context).xml);
    }

    @Test
    public void testMasterText2() throws Exception {
        SXSLFExtractorTest.assertContains((String)"Text that I added to the master slide", (String)this.getXML((String)"testPPT_masterText2.pptx", (ParseContext)this.parseContext).xml);
        OfficeParserConfig config = new OfficeParserConfig();
        config.setIncludeSlideMasterContent(false);
        config.setUseSAXPptxExtractor(true);
        ParseContext context = new ParseContext();
        context.set(OfficeParserConfig.class, (Object)config);
        SXSLFExtractorTest.assertNotContained((String)"Text that I added", (String)this.getXML((String)"testPPT_masterText2.pptx", (ParseContext)context).xml);
    }

    @Test
    public void testWordArt() throws Exception {
        SXSLFExtractorTest.assertContains((String)"Here is some red word Art", (String)this.getXML((String)"testWordArt.pptx", (ParseContext)this.parseContext).xml);
    }

    @Test
    public void testPowerPointCustomProperties() throws Exception {
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        context.set(Locale.class, (Object)Locale.US);
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setUseSAXPptxExtractor(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        this.getXML("testPPT_custom_props.pptx", metadata, this.parseContext);
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (Object)metadata.get("Content-Type"));
        Assert.assertEquals((Object)"JOUVIN ETIENNE", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assert.assertEquals((Object)"EJ04325S", (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assert.assertEquals((Object)"2011-08-22T13:30:53Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assert.assertEquals((Object)"2011-08-22T13:32:49Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assert.assertEquals((Object)"1", (Object)metadata.get(Office.SLIDE_COUNT));
        Assert.assertEquals((Object)"3", (Object)metadata.get(Office.WORD_COUNT));
        Assert.assertEquals((Object)"Test extraction properties pptx", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assert.assertEquals((Object)"true", (Object)metadata.get("custom:myCustomBoolean"));
        Assert.assertEquals((Object)"3", (Object)metadata.get("custom:myCustomNumber"));
        Assert.assertEquals((Object)"MyStringValue", (Object)metadata.get("custom:MyCustomString"));
        Assert.assertEquals((Object)"2010-12-30T22:00:00Z", (Object)metadata.get("custom:MyCustomDate"));
        Assert.assertEquals((Object)"2010-12-29T22:00:00Z", (Object)metadata.get("custom:myCustomSecondDate"));
    }

    @Test
    @Ignore(value="TODO: add in embedded file markup")
    public void testEmbeddedZipInPPTX() throws Exception {
        String xml = this.getXML((String)"test_embedded_zip.pptx", (ParseContext)this.parseContext).xml;
        int h = xml.indexOf("<div class=\"embedded\" id=\"slide1_rId3\" />");
        int i = xml.indexOf("Send me a note");
        int j = xml.indexOf("<div class=\"embedded\" id=\"slide2_rId4\" />");
        int k = xml.indexOf("<p>No title</p>");
        Assert.assertTrue((h != -1 ? 1 : 0) != 0);
        Assert.assertTrue((i != -1 ? 1 : 0) != 0);
        Assert.assertTrue((j != -1 ? 1 : 0) != 0);
        Assert.assertTrue((k != -1 ? 1 : 0) != 0);
        Assert.assertTrue((h < i ? 1 : 0) != 0);
        Assert.assertTrue((i < j ? 1 : 0) != 0);
        Assert.assertTrue((j < k ? 1 : 0) != 0);
    }

    @Test
    @Ignore(value="TODO: add in embedded file markup")
    public void testEmbeddedPPTXTwoSlides() throws Exception {
        String xml = this.getXML((String)"testPPT_embedded_two_slides.pptx", (ParseContext)this.parseContext).xml;
        SXSLFExtractorTest.assertContains((String)"<div class=\"embedded\" id=\"slide1_rId7\" />", (String)xml);
        SXSLFExtractorTest.assertContains((String)"<div class=\"embedded\" id=\"slide2_rId7\" />", (String)xml);
    }

    @Test
    public void testPPTXAutodate() throws Exception {
        TikaTest.XMLResult result = this.getXML("testPPT_autodate.pptx", this.parseContext);
        SXSLFExtractorTest.assertContains((String)"<p>Now</p>\n<p>2011-12-19 10:20:04 AM</p>\n", (String)result.xml);
    }

    @Test
    public void testPPTXThumbnail() throws Exception {
        String xml = this.getXML((String)"testPPTX_Thumbnail.pptx", (ParseContext)this.parseContext).xml;
        int a = xml.indexOf("<body><div class=\"slide-content\"><p>This file contains an embedded thumbnail");
        int b = xml.indexOf("<div class=\"embedded\" id=\"/docProps/thumbnail.jpeg\" />");
        Assert.assertTrue((a != -1 ? 1 : 0) != 0);
        Assert.assertTrue((b != -1 ? 1 : 0) != 0);
        Assert.assertTrue((a < b ? 1 : 0) != 0);
    }

    @Test
    public void testEncrypted() throws Exception {
        HashMap<String, String> tests = new HashMap<String, String>();
        tests.put("testPPT_protected_passtika.pptx", "This is an encrypted PowerPoint 2007 slide.");
        Metadata m = new Metadata();
        PasswordProvider passwordProvider = new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "tika";
            }
        };
        ParseContext passwordContext = new ParseContext();
        passwordContext.set(PasswordProvider.class, (Object)passwordProvider);
        passwordContext.set(OfficeParserConfig.class, (Object)this.officeParserConfig);
        for (Map.Entry e : tests.entrySet()) {
            InputStream is = this.getResourceAsStream("/test-documents/" + (String)e.getKey());
            Throwable throwable = null;
            try {
                BodyContentHandler handler = new BodyContentHandler();
                AUTO_DETECT_PARSER.parse(is, (ContentHandler)handler, m, passwordContext);
                SXSLFExtractorTest.assertContains((String)((String)e.getValue()), (String)handler.toString());
            }
            catch (Throwable handler) {
                throwable = handler;
                throw handler;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable handler) {
                        throwable.addSuppressed(handler);
                    }
                    continue;
                }
                is.close();
            }
        }
        ParseContext context = new ParseContext();
        for (Map.Entry e : tests.entrySet()) {
            boolean exc = false;
            try (InputStream is = this.getResourceAsStream("/test-documents/" + (String)e.getKey());){
                BodyContentHandler handler = new BodyContentHandler();
                AUTO_DETECT_PARSER.parse(is, (ContentHandler)handler, m, context);
            }
            catch (EncryptedDocumentException ex) {
                exc = true;
            }
            Assert.assertTrue((boolean)exc);
        }
    }

    @Test
    public void testMacrosInPptm() throws Exception {
        Metadata parsedBy = new Metadata();
        parsedBy.add(TikaCoreProperties.TIKA_PARSED_BY, "org.apache.tika.parser.microsoft.ooxml.xslf.XSLFEventBasedPowerPointExtractor");
        List metadataList = this.getRecursiveMetadata("testPPT_macros.pptm", this.parseContext);
        for (Metadata metadata : metadataList) {
            if (!metadata.get("Content-Type").equals("text/x-vbasic")) continue;
            Assert.fail((String)"Shouldn't have extracted macros as default");
        }
        SXSLFExtractorTest.assertContainsAtLeast((Metadata)parsedBy, (List)metadataList);
        ParseContext context = new ParseContext();
        OfficeParserConfig officeParserConfig = new OfficeParserConfig();
        officeParserConfig.setExtractMacros(true);
        officeParserConfig.setUseSAXPptxExtractor(true);
        context.set(OfficeParserConfig.class, (Object)officeParserConfig);
        Metadata minExpected = new Metadata();
        minExpected.add(RecursiveParserWrapper.TIKA_CONTENT.getName(), "Sub Embolden()");
        minExpected.add(RecursiveParserWrapper.TIKA_CONTENT.getName(), "Sub Italicize()");
        minExpected.add("Content-Type", "text/x-vbasic");
        minExpected.add(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.MACRO.toString());
        metadataList = this.getRecursiveMetadata("testPPT_macros.pptm", context);
        SXSLFExtractorTest.assertContainsAtLeast((Metadata)minExpected, (List)metadataList);
        SXSLFExtractorTest.assertContainsAtLeast((Metadata)parsedBy, (List)metadataList);
        try (InputStream is = this.getResourceAsStream("tika-config-sax-macros.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser parser = new AutoDetectParser(tikaConfig);
            metadataList = this.getRecursiveMetadata("testPPT_macros.pptm", (Parser)parser);
            SXSLFExtractorTest.assertContainsAtLeast((Metadata)minExpected, (List)metadataList);
            SXSLFExtractorTest.assertContainsAtLeast((Metadata)parsedBy, (List)metadataList);
        }
    }

    @Test
    public void testDiagramData() throws Exception {
        SXSLFExtractorTest.assertContains((String)"President", (String)this.getXML((String)"testPPT_diagramData.pptx", (ParseContext)this.parseContext).xml);
    }

    @Test
    public void testPPTXChartData() throws Exception {
        String xml = this.getXML((String)"testPPT_charts.pptx", (ParseContext)this.parseContext).xml;
        SXSLFExtractorTest.assertContains((String)"peach", (String)xml);
        SXSLFExtractorTest.assertContains((String)"March\tApril", (String)xml);
        SXSLFExtractorTest.assertNotContained((String)"chartSpace", (String)xml);
    }

    @Test
    public void testEmbeddedMedia() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT_embeddedMP3.pptx", this.parseContext);
        Assert.assertEquals((long)4L, (long)metadataList.size());
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
        Assert.assertEquals((Object)"audio/mpeg", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Assert.assertEquals((Object)"image/png", (Object)((Metadata)metadataList.get(2)).get("Content-Type"));
        Assert.assertEquals((Object)"image/jpeg", (Object)((Metadata)metadataList.get(3)).get("Content-Type"));
    }

    @Test
    public void testPPTXGroups() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPPT_groups.pptx", this.parseContext);
        Assert.assertEquals((long)3L, (long)metadataList.size());
        String content = ((Metadata)metadataList.get(0)).get(RecursiveParserWrapper.TIKA_CONTENT);
        SXSLFExtractorTest.assertContains((String)"WordArt1", (String)content);
        SXSLFExtractorTest.assertContains((String)"WordArt2", (String)content);
        SXSLFExtractorTest.assertContainsCount((String)"Ungrouped text box", (String)content, (int)1);
        SXSLFExtractorTest.assertContains((String)"Text box1", (String)content);
        SXSLFExtractorTest.assertContains((String)"Text box2", (String)content);
        SXSLFExtractorTest.assertContains((String)"Text box3", (String)content);
        SXSLFExtractorTest.assertContains((String)"Text box4", (String)content);
        SXSLFExtractorTest.assertContains((String)"Text box5", (String)content);
        SXSLFExtractorTest.assertContains((String)"href=\"http://tika.apache.org", (String)content);
        SXSLFExtractorTest.assertContains((String)"smart1", (String)content);
        SXSLFExtractorTest.assertContains((String)"MyTitle", (String)content);
        Assert.assertEquals((Object)"/image1.jpg", (Object)((Metadata)metadataList.get(1)).get(RecursiveParserWrapper.EMBEDDED_RESOURCE_PATH));
        Assert.assertEquals((Object)"/thumbnail.jpeg", (Object)((Metadata)metadataList.get(2)).get(RecursiveParserWrapper.EMBEDDED_RESOURCE_PATH));
    }
}

