/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.util.List;
import org.apache.tika.Tika;
import org.apache.tika.TikaTest;
import org.apache.tika.detect.microsoft.POIFSContainerDetector;
import org.apache.tika.extractor.ContainerExtractor;
import org.apache.tika.extractor.ParserContainerExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.microsoft.AbstractPOIContainerExtractionTest;
import org.apache.tika.utils.ParserUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OOXMLContainerExtractionTest
extends AbstractPOIContainerExtractionTest {
    private ContainerExtractor extractor;

    @Before
    public void setUp() {
        Tika tika = new Tika();
        this.extractor = new ParserContainerExtractor(tika.getParser(), tika.getDetector());
    }

    @Test
    public void testWithoutEmbedded() throws Exception {
        this.assertEmbeddedFiles(0, "testEXCEL.xlsx");
        this.assertEmbeddedFiles(0, "testWORD.docx");
        this.assertEmbeddedFiles(1, "testPPT.pptx");
    }

    private void assertEmbeddedFiles(int expectedNbFiles, String file) throws Exception {
        TikaTest.TrackingHandler handler = this.process(file, this.extractor, false);
        Assert.assertEquals((long)expectedNbFiles, (long)handler.filenames.size());
        Assert.assertEquals((long)expectedNbFiles, (long)handler.mediaTypes.size());
        handler = this.process(file, this.extractor, true);
        Assert.assertEquals((long)expectedNbFiles, (long)handler.filenames.size());
        Assert.assertEquals((long)expectedNbFiles, (long)handler.mediaTypes.size());
    }

    @Test
    public void testEmbeddedImages() throws Exception {
        TikaTest.TrackingHandler handler = this.process("testEXCEL_1img.xlsx", this.extractor, false);
        Assert.assertEquals((long)1L, (long)handler.filenames.size());
        Assert.assertEquals((long)1L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"image1.png", handler.filenames.get(0));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(0));
        handler = this.process("testPPT_2imgs.pptx", this.extractor, false);
        Assert.assertEquals((long)4L, (long)handler.filenames.size());
        Assert.assertEquals((long)4L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"image1.png", handler.filenames.get(0));
        Assert.assertEquals((Object)"image2.gif", handler.filenames.get(1));
        Assert.assertEquals((Object)"image3.png", handler.filenames.get(2));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(0));
        Assert.assertEquals((Object)TYPE_GIF, handler.mediaTypes.get(1));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(2));
        handler = this.process("testWORD_1img.docx", this.extractor, false);
        Assert.assertEquals((long)1L, (long)handler.filenames.size());
        Assert.assertEquals((long)1L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"image1.png", handler.filenames.get(0));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(0));
        handler = this.process("testWORD_3imgs.docx", this.extractor, false);
        Assert.assertEquals((long)3L, (long)handler.filenames.size());
        Assert.assertEquals((long)3L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"image2.png", handler.filenames.get(0));
        Assert.assertEquals((Object)"image3.jpeg", handler.filenames.get(1));
        Assert.assertEquals((Object)"image4.png", handler.filenames.get(2));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(0));
        Assert.assertEquals((Object)TYPE_JPG, handler.mediaTypes.get(1));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(2));
    }

    @Test
    public void testEmbeddedOfficeFiles() throws Exception {
        TikaTest.TrackingHandler handler = this.process("testEXCEL_embeded.xlsx", this.extractor, false);
        Assert.assertEquals((long)7L, (long)handler.filenames.size());
        Assert.assertEquals((long)7L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"Microsoft_Office_PowerPoint_Presentation1.pptx", handler.filenames.get(0));
        Assert.assertEquals((Object)"Microsoft_Office_Word_97_-_2003_Document1.doc", handler.filenames.get(1));
        Assert.assertEquals((Object)"Microsoft_Office_Word_Document2.docx", handler.filenames.get(2));
        Assert.assertEquals((Object)"image1.png", handler.filenames.get(3));
        Assert.assertEquals((Object)"image2.emf", handler.filenames.get(4));
        Assert.assertEquals((Object)"image3.emf", handler.filenames.get(5));
        Assert.assertEquals((Object)"image4.emf", handler.filenames.get(6));
        Assert.assertEquals((Object)TYPE_PPTX, handler.mediaTypes.get(0));
        Assert.assertEquals((Object)TYPE_DOC, handler.mediaTypes.get(1));
        Assert.assertEquals((Object)TYPE_DOCX, handler.mediaTypes.get(2));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(3));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(4));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(5));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(6));
        handler = this.process("testEXCEL_embeded.xlsx", this.extractor, true);
        Assert.assertEquals((long)24L, (long)handler.filenames.size());
        Assert.assertEquals((long)24L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)TYPE_PPTX, handler.mediaTypes.get(0));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(1));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(2));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(3));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(4));
        Assert.assertEquals((Object)TYPE_GIF, handler.mediaTypes.get(5));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(6));
        Assert.assertEquals((Object)TYPE_XLSX, handler.mediaTypes.get(7));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(8));
        Assert.assertEquals((Object)TYPE_DOCX, handler.mediaTypes.get(9));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(10));
        Assert.assertEquals((Object)TYPE_JPG, handler.mediaTypes.get(11));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(12));
        Assert.assertEquals((Object)TYPE_DOC, handler.mediaTypes.get(13));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(14));
        Assert.assertEquals((Object)TYPE_JPG, handler.mediaTypes.get(15));
        Assert.assertEquals((Object)TYPE_DOC, handler.mediaTypes.get(16));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(17));
        Assert.assertEquals((Object)TYPE_DOCX, handler.mediaTypes.get(18));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(19));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(20));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(21));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(22));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(23));
        handler = this.process("testWORD_embeded.docx", this.extractor, false);
        Assert.assertEquals((long)9L, (long)handler.filenames.size());
        Assert.assertEquals((long)9L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"Microsoft_Office_PowerPoint_Presentation2.pptx", handler.filenames.get(0));
        Assert.assertEquals((Object)"image6.emf", handler.filenames.get(1));
        Assert.assertEquals((Object)"Microsoft_Office_Word_97_-_2003_Document1.doc", handler.filenames.get(2));
        Assert.assertEquals((Object)"image1.png", handler.filenames.get(3));
        Assert.assertEquals((Object)"image2.jpeg", handler.filenames.get(4));
        Assert.assertEquals((Object)"image3.png", handler.filenames.get(5));
        Assert.assertEquals((Object)"image4.emf", handler.filenames.get(6));
        Assert.assertEquals((Object)"Microsoft_Office_Excel_Worksheet1.xlsx", handler.filenames.get(7));
        Assert.assertEquals((Object)"image5.emf", handler.filenames.get(8));
        Assert.assertEquals((Object)TYPE_PPTX, handler.mediaTypes.get(0));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(1));
        Assert.assertEquals((Object)TYPE_DOC, handler.mediaTypes.get(2));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(3));
        Assert.assertEquals((Object)TYPE_JPG, handler.mediaTypes.get(4));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(5));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(6));
        Assert.assertEquals((Object)TYPE_XLSX, handler.mediaTypes.get(7));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(8));
        handler = this.process("testWORD_embeded.docx", this.extractor, true);
        Assert.assertEquals((long)15L, (long)handler.filenames.size());
        Assert.assertEquals((long)15L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)TYPE_PPTX, handler.mediaTypes.get(0));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(1));
        Assert.assertEquals((Object)TYPE_GIF, handler.mediaTypes.get(2));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(3));
        Assert.assertEquals((Object)TYPE_JPG, handler.mediaTypes.get(4));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(5));
        Assert.assertEquals((Object)TYPE_DOC, handler.mediaTypes.get(6));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(7));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(8));
        Assert.assertEquals((Object)TYPE_JPG, handler.mediaTypes.get(9));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(10));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(11));
        Assert.assertEquals((Object)TYPE_XLSX, handler.mediaTypes.get(12));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(13));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(14));
        handler = this.process("testPPT_embeded.pptx", this.extractor, false);
        Assert.assertEquals((long)10L, (long)handler.filenames.size());
        Assert.assertEquals((long)10L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"image1.emf", handler.filenames.get(0));
        Assert.assertEquals((Object)"image2.emf", handler.filenames.get(1));
        Assert.assertEquals((Object)"image3.emf", handler.filenames.get(2));
        Assert.assertEquals((Object)"image4.png", handler.filenames.get(3));
        Assert.assertEquals((Object)"image5.gif", handler.filenames.get(4));
        Assert.assertEquals((Object)"image6.png", handler.filenames.get(5));
        Assert.assertEquals((Object)"Microsoft_Office_Excel_Worksheet1.xlsx", handler.filenames.get(6));
        Assert.assertEquals((Object)"Microsoft_Office_Word_Document2.docx", handler.filenames.get(7));
        Assert.assertEquals((Object)"Microsoft_Office_Word_97_-_2003_Document1.doc", handler.filenames.get(8));
        Assert.assertEquals((Object)"/docProps/thumbnail.jpeg", handler.filenames.get(9));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(0));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(1));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(2));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(3));
        Assert.assertEquals((Object)TYPE_GIF, handler.mediaTypes.get(4));
        Assert.assertEquals((Object)TYPE_PNG, handler.mediaTypes.get(5));
        Assert.assertEquals((Object)TYPE_XLSX, handler.mediaTypes.get(6));
        Assert.assertEquals((Object)TYPE_DOCX, handler.mediaTypes.get(7));
        Assert.assertEquals((Object)TYPE_DOC, handler.mediaTypes.get(8));
    }

    @Test
    public void testEmbeddedOutlook() throws Exception {
        TikaTest.TrackingHandler handler = this.process("EmbeddedOutlook.docx", this.extractor, false);
        Assert.assertEquals((long)2L, (long)handler.filenames.size());
        Assert.assertEquals((long)2L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"image1.emf", handler.filenames.get(0));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(0));
        Assert.assertEquals((Object)"licensedTestMsgwAtt.msg", handler.filenames.get(1));
        Assert.assertEquals((Object)TYPE_MSG, handler.mediaTypes.get(1));
    }

    @Test
    public void testEmbeddedPDF() throws Exception {
        TikaTest.TrackingHandler handler = this.process("EmbeddedPDF.docx", this.extractor, false);
        Assert.assertEquals((long)2L, (long)handler.filenames.size());
        Assert.assertEquals((long)2L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"image1.emf", handler.filenames.get(0));
        Assert.assertEquals((Object)TYPE_EMF, handler.mediaTypes.get(0));
        Assert.assertNull(handler.filenames.get(1));
        Assert.assertEquals((Object)TYPE_PDF, handler.mediaTypes.get(1));
    }

    @Test
    public void testEmbeddedGraphChart() throws Exception {
        for (String suffix : new String[]{"pptx", "xlsx"}) {
            List list = this.getRecursiveMetadata("testMSChart-govdocs-428996." + suffix);
            boolean found = false;
            for (Metadata m : list) {
                if (m.get("Content-Type").equals(POIFSContainerDetector.MS_GRAPH_CHART.toString())) {
                    found = true;
                }
                Assert.assertNull((Object)m.get(ParserUtils.EMBEDDED_EXCEPTION));
            }
            Assert.assertTrue((String)("didn't find chart in " + suffix), (boolean)found);
        }
    }
}

