/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.junit.Assert;
import org.junit.Test;

public class OneNoteParserTest
extends TikaTest {
    @Test
    public void testOneNote2013Doc1() throws Exception {
        Metadata metadata = new Metadata();
        String txt = this.getText("testOneNote1.one", metadata);
        this.assertNoJunk(txt);
        List<String> authors = Arrays.asList(metadata.getValues("authors"));
        OneNoteParserTest.assertContains((Object)"Olya Veselova\u0000", authors);
        OneNoteParserTest.assertContains((Object)"Microsoft\u0000", authors);
        OneNoteParserTest.assertContains((Object)"Scott\u0000", authors);
        OneNoteParserTest.assertContains((Object)"Scott H. W. Snyder\u0000", authors);
        List<String> mostRecentAuthors = Arrays.asList(metadata.getValues("mostRecentAuthors"));
        OneNoteParserTest.assertContains((Object)"Microsoft\u0000", mostRecentAuthors);
        List<String> originalAuthors = Arrays.asList(metadata.getValues("originalAuthors"));
        OneNoteParserTest.assertContains((Object)"Microsoft\u0000", originalAuthors);
        Assert.assertEquals((Object)Instant.ofEpochSecond(1336059427L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("creationTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochMilli(1383613114000L), (Object)Instant.ofEpochMilli(Long.parseLong(metadata.get("lastModifiedTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochSecond(1446572147L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("lastModified"))));
    }

    @Test
    public void testOneNote2013Doc2() throws Exception {
        Metadata metadata = new Metadata();
        String txt = this.getText("testOneNote2.one", metadata);
        OneNoteParserTest.assertContains((String)"wow this is neat", (String)txt);
        OneNoteParserTest.assertContains((String)"neat info about totally killin it bro", (String)txt);
        OneNoteParserTest.assertContains((String)"Section1TextArea1", (String)txt);
        OneNoteParserTest.assertContains((String)"Section1HeaderTitle", (String)txt);
        OneNoteParserTest.assertContains((String)"Section1TextArea2", (String)txt);
        this.assertNoJunk(txt);
        List<String> authors = Arrays.asList(metadata.getValues("authors"));
        OneNoteParserTest.assertContains((Object)"Olya Veselova\u0000", authors);
        OneNoteParserTest.assertContains((Object)"Microsoft\u0000", authors);
        OneNoteParserTest.assertContains((Object)"Scott\u0000", authors);
        OneNoteParserTest.assertContains((Object)"Scott H. W. Snyder\u0000", authors);
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", authors);
        List<String> mostRecentAuthors = Arrays.asList(metadata.getValues("mostRecentAuthors"));
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", mostRecentAuthors);
        OneNoteParserTest.assertContains((Object)"Microsoft\u0000", mostRecentAuthors);
        List<String> originalAuthors = Arrays.asList(metadata.getValues("originalAuthors"));
        OneNoteParserTest.assertContains((Object)"Microsoft\u0000", originalAuthors);
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", mostRecentAuthors);
        Assert.assertEquals((Object)Instant.ofEpochSecond(1336059427L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("creationTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochMilli(1574426629000L), (Object)Instant.ofEpochMilli(Long.parseLong(metadata.get("lastModifiedTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochSecond(1574426628L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("lastModified"))));
    }

    @Test
    public void testOneNote2013Doc3() throws Exception {
        Metadata metadata = new Metadata();
        String txt = this.getText("testOneNote3.one", metadata);
        OneNoteParserTest.assertContains((String)"awesome information about sports or some crap like that.", (String)txt);
        OneNoteParserTest.assertContains((String)"Quit doing horrible things to me. Dang you. ", (String)txt);
        OneNoteParserTest.assertContains((String)"Section2TextArea1", (String)txt);
        OneNoteParserTest.assertContains((String)"Section2HeaderTitle", (String)txt);
        OneNoteParserTest.assertContains((String)"Section2TextArea2", (String)txt);
        this.assertNoJunk(txt);
        List<String> authors = Arrays.asList(metadata.getValues("authors"));
        OneNoteParserTest.assertNotContained((Object)"Olya Veselova\u0000", authors);
        OneNoteParserTest.assertNotContained((Object)"Microsoft\u0000", authors);
        OneNoteParserTest.assertNotContained((Object)"Scott\u0000", authors);
        OneNoteParserTest.assertNotContained((Object)"Scott H. W. Snyder\u0000", authors);
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", authors);
        List<String> mostRecentAuthors = Arrays.asList(metadata.getValues("mostRecentAuthors"));
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", mostRecentAuthors);
        OneNoteParserTest.assertNotContained((Object)"Microsoft\u0000", mostRecentAuthors);
        List<String> originalAuthors = Arrays.asList(metadata.getValues("originalAuthors"));
        OneNoteParserTest.assertNotContained((Object)"Microsoft\u0000", originalAuthors);
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", mostRecentAuthors);
        Assert.assertEquals((Object)Instant.ofEpochSecond(1574426349L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("creationTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochMilli(1574426623000L), (Object)Instant.ofEpochMilli(Long.parseLong(metadata.get("lastModifiedTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochSecond(1574426624L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("lastModified"))));
    }

    @Test
    public void testOneNote2013Doc4() throws Exception {
        Metadata metadata = new Metadata();
        String txt = this.getText("testOneNote4.one", metadata);
        OneNoteParserTest.assertContains((String)"way too much information about poptarts to handle.", (String)txt);
        OneNoteParserTest.assertContains((String)"Section3TextArea1", (String)txt);
        OneNoteParserTest.assertContains((String)"Section3HeaderTitle", (String)txt);
        OneNoteParserTest.assertContains((String)"Section3TextArea2", (String)txt);
        this.assertNoJunk(txt);
        List<String> authors = Arrays.asList(metadata.getValues("authors"));
        OneNoteParserTest.assertNotContained((Object)"Olya Veselova\u0000", authors);
        OneNoteParserTest.assertNotContained((Object)"Microsoft\u0000", authors);
        OneNoteParserTest.assertNotContained((Object)"Scott\u0000", authors);
        OneNoteParserTest.assertNotContained((Object)"Scott H. W. Snyder\u0000", authors);
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", authors);
        List<String> mostRecentAuthors = Arrays.asList(metadata.getValues("mostRecentAuthors"));
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", mostRecentAuthors);
        OneNoteParserTest.assertNotContained((Object)"Microsoft\u0000", mostRecentAuthors);
        List<String> originalAuthors = Arrays.asList(metadata.getValues("originalAuthors"));
        OneNoteParserTest.assertNotContained((Object)"Microsoft\u0000", originalAuthors);
        OneNoteParserTest.assertContains((Object)"ndipiazza\u0000", mostRecentAuthors);
        Assert.assertEquals((Object)Instant.ofEpochSecond(1574426385L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("creationTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochMilli(1574426548000L), (Object)Instant.ofEpochMilli(Long.parseLong(metadata.get("lastModifiedTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochSecond(1574426547L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("lastModified"))));
    }

    @Test
    public void testOneNote2016() throws Exception {
        Metadata metadata = new Metadata();
        String txt = this.getText("testOneNote2016.one", metadata);
        OneNoteParserTest.assertContains((String)"So good", (String)txt);
        OneNoteParserTest.assertContains((String)"This is one note 2016", (String)txt);
        this.assertNoJunk(txt);
        List<String> authors = Arrays.asList(metadata.getValues("authors"));
        OneNoteParserTest.assertContains((Object)"nicholas dipiazza\u0000", authors);
        List<String> mostRecentAuthors = Arrays.asList(metadata.getValues("mostRecentAuthors"));
        OneNoteParserTest.assertContains((Object)"nicholas dipiazza\u0000", mostRecentAuthors);
        List<String> originalAuthors = Arrays.asList(metadata.getValues("originalAuthors"));
        OneNoteParserTest.assertContains((Object)"nicholas dipiazza\u0000", originalAuthors);
        Assert.assertEquals((Object)Instant.ofEpochSecond(1576107472L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("creationTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochMilli(1576107481000L), (Object)Instant.ofEpochMilli(Long.parseLong(metadata.get("lastModifiedTimestamp"))));
        Assert.assertEquals((Object)Instant.ofEpochSecond(1576107480L), (Object)Instant.ofEpochSecond(Long.parseLong(metadata.get("lastModified"))));
    }

    @Test
    public void testOneNote2007OrEarlier1() throws Exception {
        Metadata metadata = new Metadata();
        String txt = this.getText("testOneNote2007OrEarlier1.one", metadata);
        OneNoteParserTest.assertContains((String)"One note is the application.  The notebooks are the files within the application.  Each notebook can have an unlimited amount of sections and pages.  To create a new notebook, go to file, new, computer, and name it.  It will go to my documents, oneNote Notebooks folder.  The notebook doesn't close and you don't have to save.  If it closes, you can go back to it and it will open at the same place you left off.  If you are offline and the notebook is being stored on a sharepoint site, you can work on it and it will sync when you go back online.", (String)txt);
        OneNoteParserTest.assertContains((String)"Correlation between Outlook and OneNote", (String)txt);
    }

    @Test
    public void testOneNote2007OrEarlier2() throws Exception {
        Metadata metadata = new Metadata();
        String txt = this.getText("testOneNote2007OrEarlier2.one", metadata);
        OneNoteParserTest.assertContains((String)"In Outlook meeting notice, select One Note Meeting Notes and then select the \"page\" you want to link/share", (String)txt);
    }

    @Test
    public void testOneNoteEmbeddedWordDoc() throws Exception {
        List metadataList = this.getRecursiveMetadata("testOneNoteEmbeddedWordDoc.one");
        Assert.assertTrue((boolean)metadataList.stream().anyMatch(ml -> "application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(ml.get("Content-Type"))));
    }

    private void assertNoJunk(String txt) {
        OneNoteParserTest.assertNotContained((String)"Calibri", (String)txt);
        OneNoteParserTest.assertNotContained((String)"\u5902", (String)txt);
        OneNoteParserTest.assertNotContained((String)"\u83f2", (String)txt);
        OneNoteParserTest.assertNotContained((String)"\u432f", (String)txt);
        OneNoteParserTest.assertNotContained((String)"\u01e1", (String)txt);
    }
}

