/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmPmglHeader;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPmglHeader {
    ChmPmglHeader chmPmglHeader = null;

    @Before
    public void setUp() throws Exception {
        byte[] data = TestParameters.chmData;
        this.chmPmglHeader = new ChmPmglHeader();
        this.chmPmglHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)204, (int)234), this.chmPmglHeader);
    }

    @Test
    public void testToString() {
        Assert.assertTrue((this.chmPmglHeader != null && this.chmPmglHeader.toString().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testChmPmglHeaderGet() {
        Assert.assertEquals((Object)"PMGL", (Object)new String(this.chmPmglHeader.getSignature(), StandardCharsets.UTF_8));
    }

    @Test
    public void testGetBlockNext() {
        Assert.assertEquals((long)-1L, (long)this.chmPmglHeader.getBlockNext());
    }

    @Test
    public void testGetBlockPrev() {
        Assert.assertEquals((long)-1L, (long)this.chmPmglHeader.getBlockPrev());
    }

    @Test
    public void testGetFreeSpace() {
        Assert.assertEquals((long)1644L, (long)this.chmPmglHeader.getFreeSpace());
    }

    @Test
    public void testGetUnknown0008() {
        Assert.assertEquals((long)0L, (long)this.chmPmglHeader.getUnknown0008());
    }
}

