/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import org.apache.tika.parser.microsoft.chm.ChmAssert;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmDirectoryListingSet;
import org.apache.tika.parser.microsoft.chm.ChmItsfHeader;
import org.apache.tika.parser.microsoft.chm.ChmItspHeader;
import org.apache.tika.parser.microsoft.chm.ChmLzxcControlData;
import org.apache.tika.parser.microsoft.chm.ChmLzxcResetTable;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestChmLzxcResetTable {
    private ChmLzxcResetTable chmLzxcResetTable = null;

    @Before
    public void setUp() throws Exception {
        byte[] data = TestParameters.chmData;
        ChmItsfHeader chmItsfHeader = new ChmItsfHeader();
        chmItsfHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)0, (int)95), chmItsfHeader);
        ChmItspHeader chmItspHeader = new ChmItspHeader();
        chmItspHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)((int)chmItsfHeader.getDirOffset()), (int)((int)chmItsfHeader.getDirOffset() + 84)), chmItspHeader);
        ChmDirectoryListingSet chmDirListCont = new ChmDirectoryListingSet(data, chmItsfHeader, chmItspHeader);
        int indexOfControlData = chmDirListCont.getControlDataIndex();
        int indexOfResetTable = ChmCommons.indexOfResetTableBlock((byte[])data, (byte[])"LZXC".getBytes(StandardCharsets.UTF_8));
        byte[] dir_chunk = null;
        if (indexOfResetTable > 0) {
            dir_chunk = ChmCommons.copyOfRange((byte[])data, (int)indexOfResetTable, (int)(indexOfResetTable + ((DirectoryListingEntry)chmDirListCont.getDirectoryListingEntryList().get(indexOfControlData)).getLength()));
        }
        ChmLzxcControlData chmLzxcControlData = new ChmLzxcControlData();
        chmLzxcControlData.parse(dir_chunk, chmLzxcControlData);
        indexOfResetTable = chmDirListCont.getResetTableIndex();
        this.chmLzxcResetTable = new ChmLzxcResetTable();
        int startIndex = (int)chmDirListCont.getDataOffset() + ((DirectoryListingEntry)chmDirListCont.getDirectoryListingEntryList().get(indexOfResetTable)).getOffset();
        ChmAssert.assertCopyingDataIndex((int)startIndex, (int)data.length);
        dir_chunk = ChmCommons.copyOfRange((byte[])data, (int)startIndex, (int)(startIndex + ((DirectoryListingEntry)chmDirListCont.getDirectoryListingEntryList().get(indexOfResetTable)).getLength()));
        this.chmLzxcResetTable.parse(dir_chunk, this.chmLzxcResetTable);
    }

    @Test
    public void testGetBlockAddress() {
        Assert.assertEquals((long)12L, (long)this.chmLzxcResetTable.getBlockAddress().length);
    }

    @Test
    public void testGetBlockCount() {
        Assert.assertEquals((long)12L, (long)this.chmLzxcResetTable.getBlockCount());
    }

    @Test
    public void testGetBlockLen() {
        Assert.assertEquals((long)32768L, (long)this.chmLzxcResetTable.getBlockLen());
    }

    @Test
    public void testGetCompressedLen() {
        Assert.assertEquals((long)177408L, (long)this.chmLzxcResetTable.getCompressedLen());
    }

    @Test
    public void testGetTableOffset() {
        Assert.assertEquals((long)40L, (long)this.chmLzxcResetTable.getTableOffset());
    }

    @Test
    public void testGetUncompressedLen() {
        Assert.assertEquals((long)383786L, (long)this.chmLzxcResetTable.getUncompressedLen());
    }

    @Test
    public void testGetUnknown() {
        Assert.assertEquals((long)8L, (long)this.chmLzxcResetTable.getUnknown());
    }

    @Test
    public void testGetVersion() {
        Assert.assertEquals((long)2L, (long)this.chmLzxcResetTable.getVersion());
    }

    @Test
    public void testToString() {
        Assert.assertTrue((this.chmLzxcResetTable.toString().length() > 0 ? 1 : 0) != 0);
    }
}

