/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmDirectoryListingSet;
import org.apache.tika.parser.microsoft.chm.ChmItsfHeader;
import org.apache.tika.parser.microsoft.chm.ChmItspHeader;
import org.apache.tika.parser.microsoft.chm.ChmLzxcControlData;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestChmLzxcControlData {
    private ChmLzxcControlData chmLzxcControlData = null;

    @Before
    public void setUp() throws Exception {
        byte[] data = TestParameters.chmData;
        ChmItsfHeader chmItsHeader = new ChmItsfHeader();
        chmItsHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)0, (int)95), chmItsHeader);
        ChmItspHeader chmItspHeader = new ChmItspHeader();
        chmItspHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)((int)chmItsHeader.getDirOffset()), (int)((int)chmItsHeader.getDirOffset() + 84)), chmItspHeader);
        ChmDirectoryListingSet chmDirListCont = new ChmDirectoryListingSet(data, chmItsHeader, chmItspHeader);
        int indexOfControlData = chmDirListCont.getControlDataIndex();
        int indexOfResetTable = ChmCommons.indexOfResetTableBlock((byte[])data, (byte[])"LZXC".getBytes(StandardCharsets.UTF_8));
        byte[] dir_chunk = null;
        if (indexOfResetTable > 0) {
            dir_chunk = ChmCommons.copyOfRange((byte[])data, (int)indexOfResetTable, (int)(indexOfResetTable + ((DirectoryListingEntry)chmDirListCont.getDirectoryListingEntryList().get(indexOfControlData)).getLength()));
        }
        this.chmLzxcControlData = new ChmLzxcControlData();
        this.chmLzxcControlData.parse(dir_chunk, this.chmLzxcControlData);
    }

    @Test
    public void testConstructorNotNull() {
        Assert.assertNotNull((Object)this.chmLzxcControlData);
    }

    @Test
    public void testGetResetInterval() {
        Assert.assertEquals((long)2L, (long)this.chmLzxcControlData.getResetInterval());
    }

    @Test
    public void testGetSize() {
        Assert.assertEquals((long)6L, (long)this.chmLzxcControlData.getSize());
    }

    @Test
    public void testGetUnknown_18() {
        Assert.assertEquals((long)0L, (long)this.chmLzxcControlData.getUnknown_18());
    }

    @Test
    public void testGetVersion() {
        Assert.assertEquals((long)2L, (long)this.chmLzxcControlData.getVersion());
    }

    @Test
    public void testGetWindowSize() {
        Assert.assertEquals((long)65536L, (long)this.chmLzxcControlData.getWindowSize());
    }

    @Test
    public void testGetWindowsPerReset() {
        Assert.assertEquals((long)1L, (long)this.chmLzxcControlData.getWindowsPerReset());
    }

    @Test
    public void testGetToString() {
        Assert.assertTrue((boolean)this.chmLzxcControlData.toString().contains("LZXC"));
    }

    @Test
    public void testGetSignature() {
        Assert.assertEquals((long)"LZXC".getBytes(StandardCharsets.UTF_8).length, (long)this.chmLzxcControlData.getSignature().length);
    }

    @Test
    public void testGetSignaure() {
        Assert.assertEquals((long)"LZXC".getBytes(StandardCharsets.UTF_8).length, (long)this.chmLzxcControlData.getSignature().length);
    }
}

