/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.nio.charset.StandardCharsets;
import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmItsfHeader;
import org.apache.tika.parser.microsoft.chm.ChmItspHeader;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestChmItspHeader {
    private ChmItspHeader chmItspHeader = null;

    @Before
    public void setUp() throws Exception {
        byte[] data = TestParameters.chmData;
        ChmItsfHeader chmItsfHeader = new ChmItsfHeader();
        chmItsfHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)0, (int)95), chmItsfHeader);
        this.chmItspHeader = new ChmItspHeader();
        this.chmItspHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)((int)chmItsfHeader.getDirOffset()), (int)((int)chmItsfHeader.getDirOffset() + 84)), this.chmItspHeader);
    }

    @Test
    public void testGetBlock_len() {
        Assert.assertEquals((long)4096L, (long)this.chmItspHeader.getBlock_len());
    }

    @Test
    public void testGetBlockidx_intvl() {
        Assert.assertEquals((long)2L, (long)this.chmItspHeader.getBlockidx_intvl());
    }

    @Test
    public void testGetHeader_len() {
        Assert.assertEquals((long)84L, (long)this.chmItspHeader.getHeader_len());
    }

    @Test
    public void testGetIndex_depth() {
        Assert.assertEquals((long)1L, (long)this.chmItspHeader.getIndex_depth());
    }

    @Test
    public void testGetIndex_head() {
        Assert.assertEquals((long)0L, (long)this.chmItspHeader.getIndex_head());
    }

    @Test
    public void testGetIndex_root() {
        Assert.assertEquals((long)-1L, (long)this.chmItspHeader.getIndex_root());
    }

    @Test
    public void testGetLang_id() {
        Assert.assertEquals((long)1033L, (long)this.chmItspHeader.getLang_id());
    }

    @Test
    public void testGetNum_blocks() {
        Assert.assertEquals((long)-1L, (long)this.chmItspHeader.getNum_blocks());
    }

    @Test
    public void testGetUnknown_000c() {
        Assert.assertEquals((long)10L, (long)this.chmItspHeader.getUnknown_000c());
    }

    @Test
    public void testGetUnknown_0024() {
        Assert.assertEquals((long)0L, (long)this.chmItspHeader.getUnknown_0024());
    }

    @Test
    public void testGetUnknown_002() {
        Assert.assertEquals((long)1L, (long)this.chmItspHeader.getUnknown_002c());
    }

    @Test
    public void testGetUnknown_0044() {
        Assert.assertEquals((long)16L, (long)this.chmItspHeader.getUnknown_0044().length);
    }

    @Test
    public void testGetVersion() {
        Assert.assertEquals((long)1L, (long)this.chmItspHeader.getVersion());
    }

    @Test
    public void testGetSignature() {
        Assert.assertEquals((Object)"ITSP", (Object)new String(this.chmItspHeader.getSignature(), StandardCharsets.UTF_8));
    }

    @Test
    public void testGetSystem_uuid() {
        Assert.assertEquals((long)16L, (long)this.chmItspHeader.getSystem_uuid().length);
    }

    @Test
    public void testToString() {
        Assert.assertTrue((boolean)this.chmItspHeader.toString().contains("ITSP"));
    }

    @After
    public void tearDown() throws Exception {
        this.chmItspHeader = null;
    }
}

