/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import org.apache.tika.parser.microsoft.chm.ChmCommons;
import org.apache.tika.parser.microsoft.chm.ChmItsfHeader;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestChmItsfHeader {
    private ChmItsfHeader chmItsfHeader = null;

    @Before
    public void setUp() throws Exception {
        this.chmItsfHeader = new ChmItsfHeader();
        byte[] data = TestParameters.chmData;
        this.chmItsfHeader.parse(ChmCommons.copyOfRange((byte[])data, (int)0, (int)95), this.chmItsfHeader);
    }

    @Test
    public void getDataOffset() {
        Assert.assertEquals((long)4300L, (long)this.chmItsfHeader.getDataOffset());
    }

    @Test
    public void getDir_uuid() {
        Assert.assertNotNull((Object)this.chmItsfHeader.getDir_uuid());
    }

    @Test
    public void getDirLen() {
        Assert.assertEquals((long)4180L, (long)this.chmItsfHeader.getDirLen());
    }

    @Test
    public void getDirOffset() {
        Assert.assertEquals((long)120L, (long)this.chmItsfHeader.getDirOffset());
    }

    @Test
    public void getHeaderLen() {
        Assert.assertEquals((long)96L, (long)this.chmItsfHeader.getHeaderLen());
    }

    @Test
    public void getLangId() {
        Assert.assertEquals((long)1033L, (long)this.chmItsfHeader.getLangId());
    }

    @Test
    public void getLastModified() {
        Assert.assertEquals((long)1042357880L, (long)this.chmItsfHeader.getLastModified());
    }

    @Test
    public void getUnknown_000c() {
        Assert.assertEquals((long)1L, (long)this.chmItsfHeader.getUnknown_000c());
    }

    @Test
    public void getUnknownLen() {
        Assert.assertEquals((long)24L, (long)this.chmItsfHeader.getUnknownLen());
    }

    @Test
    public void getUnknownOffset() {
        Assert.assertEquals((long)96L, (long)this.chmItsfHeader.getUnknownOffset());
    }

    @Test
    public void getVersion() {
        Assert.assertEquals((long)3L, (long)this.chmItsfHeader.getVersion());
    }

    @Test
    public void testToString() {
        Assert.assertTrue((boolean)this.chmItsfHeader.toString().contains("ITSF"));
    }

    @After
    public void tearDown() throws Exception {
        this.chmItsfHeader = null;
    }
}

