/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.chm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.chm.ChmDirectoryListingSet;
import org.apache.tika.parser.microsoft.chm.ChmExtractor;
import org.apache.tika.parser.microsoft.chm.DirectoryListingEntry;
import org.apache.tika.parser.microsoft.chm.TestParameters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestChmExtractor
extends TikaTest {
    private ChmExtractor chmExtractor = null;

    @Before
    public void setUp() throws Exception {
        this.chmExtractor = new ChmExtractor((InputStream)new ByteArrayInputStream(TestParameters.chmData));
    }

    @Test
    public void testEnumerateChm() {
        List chmEntries = this.chmExtractor.enumerateChm();
        Assert.assertEquals((long)100L, (long)chmEntries.size());
    }

    @Test
    public void testGetChmDirList() {
        Assert.assertNotNull((Object)this.chmExtractor.getChmDirList());
    }

    @Test
    public void testExtractChmEntry() throws TikaException {
        ChmDirectoryListingSet entries = this.chmExtractor.getChmDirList();
        int count = 0;
        for (DirectoryListingEntry directoryListingEntry : entries.getDirectoryListingEntryList()) {
            this.chmExtractor.extractChmEntry(directoryListingEntry);
            ++count;
        }
        Assert.assertEquals((long)100L, (long)count);
    }

    @Test
    public void testOOMOnCorruptCHM() throws Exception {
        try {
            TikaTest.XMLResult r = this.getXML("testChm_oom.chm");
            Assert.fail((String)"should have thrown TikaException");
        }
        catch (TikaException e) {
            Assert.assertTrue((String)"correct exception thrown", (boolean)true);
        }
    }
}

