/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.junit.Assert;
import org.junit.Test;

public class WMFParserTest
extends TikaTest {
    @Test
    public void testTextExtractionWindows() throws Exception {
        this.testTextExtraction("testXLSX_Thumbnail.xlsx", 1, "This file contains an embedded thumbnail");
    }

    @Test
    public void testTextExtractionShiftJISencoding() throws Exception {
        this.testTextExtraction("testWMF_charset.wmf", 0, "\u666e\u6797\u65af");
    }

    private void testTextExtraction(String fileName, int metaDataItemIndex, String expectedText) throws Exception {
        List metadataList = this.getRecursiveMetadata(fileName);
        Metadata wmfMetadata = (Metadata)metadataList.get(metaDataItemIndex);
        Assert.assertEquals((Object)"image/wmf", (Object)wmfMetadata.get("Content-Type"));
        WMFParserTest.assertContains((String)expectedText, (String)wmfMetadata.get(RecursiveParserWrapper.TIKA_CONTENT));
    }
}

