/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.extractor.ContainerExtractor;
import org.apache.tika.extractor.ParserContainerExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.AbstractPOIContainerExtractionTest;
import org.apache.tika.parser.microsoft.TNEFParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class TNEFParserTest
extends AbstractPOIContainerExtractionTest {
    private static final String file = "testWINMAIL.dat";

    @Test
    public void testBasics() throws Exception {
        DefaultDetector detector = new DefaultDetector();
        try (TikaInputStream stream = TNEFParserTest.getTestFile(file);){
            Assert.assertEquals((Object)MediaType.application((String)"vnd.ms-tnef"), (Object)detector.detect((InputStream)stream, new Metadata()));
        }
    }

    @Test
    public void testMetadata() throws Exception {
        TikaInputStream stream = TNEFParserTest.getTestFile(file);
        Metadata metadata = new Metadata();
        BodyContentHandler handler = new BodyContentHandler();
        TNEFParser tnef = new TNEFParser();
        tnef.parse((InputStream)stream, (ContentHandler)handler, metadata, new ParseContext());
        Assert.assertEquals((Object)"This is a test message", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assert.assertEquals((Object)"This is a test message", (Object)metadata.get(TikaCoreProperties.SUBJECT));
    }

    @Test
    public void testBodyAndAttachments() throws Exception {
        ParserContainerExtractor extractor = new ParserContainerExtractor();
        TikaTest.TrackingHandler handler = this.process(file, (ContainerExtractor)extractor, true);
        Assert.assertEquals((long)6L, (long)handler.filenames.size());
        Assert.assertEquals((long)6L, (long)handler.mediaTypes.size());
        Assert.assertEquals((Object)"message.rtf", handler.filenames.get(0));
        Assert.assertEquals((Object)MediaType.application((String)"rtf"), handler.mediaTypes.get(0));
        Assert.assertEquals((Object)"quick.doc", handler.filenames.get(1));
        Assert.assertEquals((Object)MediaType.application((String)"msword"), handler.mediaTypes.get(1));
        Assert.assertEquals((Object)"quick.html", handler.filenames.get(2));
        Assert.assertEquals((Object)MediaType.text((String)"html"), handler.mediaTypes.get(2));
        Assert.assertEquals((Object)"quick.pdf", handler.filenames.get(3));
        Assert.assertEquals((Object)MediaType.application((String)"pdf"), handler.mediaTypes.get(3));
        Assert.assertEquals((Object)"quick.txt", handler.filenames.get(4));
        Assert.assertEquals((Object)MediaType.text((String)"plain"), handler.mediaTypes.get(4));
        Assert.assertEquals((Object)"quick.xml", handler.filenames.get(5));
        Assert.assertEquals((Object)MediaType.application((String)"xml"), handler.mediaTypes.get(5));
    }

    @Test
    public void testRTF() throws Exception {
        String xml = this.getXML((String)file).xml;
        TNEFParserTest.assertContains((String)"Der schnelle braune", (String)xml);
    }
}

