/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class PublisherParserTest {
    @Test
    public void testPublisherParser() throws Exception {
        try (InputStream input = PublisherParserTest.class.getResourceAsStream("/test-documents/testPUBLISHER.pub");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assert.assertEquals((Object)"application/x-mspublisher", (Object)metadata.get("Content-Type"));
            Assert.assertEquals(null, (Object)metadata.get(TikaCoreProperties.TITLE));
            Assert.assertEquals((Object)"Nick Burch", (Object)metadata.get(TikaCoreProperties.CREATOR));
            String content = handler.toString();
            TikaTest.assertContains((String)"0123456789", (String)content);
            TikaTest.assertContains((String)"abcdef", (String)content);
        }
    }
}

