/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class ProjectParserTest {
    @Test
    public void testProject2003() throws Exception {
        try (InputStream input = ProjectParserTest.class.getResourceAsStream("/test-documents/testPROJECT2003.mpp");){
            this.doTestProject(input);
        }
    }

    @Test
    public void testProject2007() throws Exception {
        try (InputStream input = ProjectParserTest.class.getResourceAsStream("/test-documents/testPROJECT2007.mpp");){
            this.doTestProject(input);
        }
    }

    private void doTestProject(InputStream input) throws Exception {
        Metadata metadata = new Metadata();
        BodyContentHandler handler = new BodyContentHandler();
        new OfficeParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
        Assert.assertEquals((Object)"application/vnd.ms-project", (Object)metadata.get("Content-Type"));
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assert.assertEquals((Object)"Gym class featuring a brown fox and lazy dog", (Object)metadata.get(OfficeOpenXMLCore.SUBJECT));
        Assert.assertEquals((Object)"Nevin Nollop", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assert.assertEquals((Object)"", (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assert.assertEquals((Object)"Pangram, fox, dog", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        Assert.assertEquals((Object)"Comment Vulpes vulpes comment", (Object)metadata.get(TikaCoreProperties.COMMENTS));
        Assert.assertEquals((Object)"Category1", (Object)metadata.get(OfficeOpenXMLCore.CATEGORY));
        Assert.assertEquals((Object)"Mr Burns", (Object)metadata.get(OfficeOpenXMLExtended.MANAGER));
        Assert.assertEquals((Object)"CompanyA", (Object)metadata.get(OfficeOpenXMLExtended.COMPANY));
        Assert.assertEquals((Object)"2011-11-24T10:58:00Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assert.assertEquals((Object)"2011-11-24T11:31:00Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assert.assertEquals((Object)"0%", (Object)metadata.get("custom:% Complete"));
        Assert.assertEquals((Object)"0%", (Object)metadata.get("custom:% Work Complete"));
        Assert.assertEquals((Object)"\u00a30.00", (Object)metadata.get("custom:Cost"));
        Assert.assertEquals((Object)"2d?", (Object)metadata.get("custom:Duration"));
        Assert.assertEquals((Object)"16h", (Object)metadata.get("custom:Work"));
        String content = handler.toString();
        Assert.assertEquals((Object)"", (Object)content);
    }
}

