/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class OutlookParserTest
extends TikaTest {
    @Test
    public void testOutlookParsing() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/test-outlook.msg");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        Assert.assertEquals((Object)"application/vnd.ms-outlook", (Object)metadata.get("Content-Type"));
        Assert.assertEquals((Object)"Microsoft Outlook Express 6", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assert.assertEquals((Object)"Nouvel utilisateur de Outlook Express", (Object)metadata.get("Message-Recipient-Address"));
        Assert.assertEquals((Object)"L'\u00c9quipe Microsoft Outlook Express", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assert.assertEquals((Object)"L'\u00c9quipe Microsoft Outlook Express <msoe@microsoft.com>", (Object)metadata.get("Message:Raw-Header:From"));
        Assert.assertEquals((Object)"Nouvel utilisateur de Outlook Express", (Object)metadata.get(Message.MESSAGE_TO_EMAIL));
        Assert.assertEquals((Object)"", (Object)metadata.get(Message.MESSAGE_TO_NAME));
        Assert.assertEquals((Object)"Nouvel utilisateur de Outlook Express", (Object)metadata.get(Message.MESSAGE_TO_DISPLAY_NAME));
        Assert.assertEquals((Object)"2007-04-05T16:26:06Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        String content = handler.toString();
        OutlookParserTest.assertContains((String)"Microsoft Outlook Express 6", (String)content);
        OutlookParserTest.assertContains((String)"L'\u00c9quipe Microsoft Outlook Express", (String)content);
        OutlookParserTest.assertContains((String)"Nouvel utilisateur de Outlook Express", (String)content);
        OutlookParserTest.assertContains((String)"Messagerie et groupes de discussion", (String)content);
    }

    @Test
    public void testMultipleCopies() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testMSG.msg");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        Assert.assertEquals((Object)"application/vnd.ms-outlook", (Object)metadata.get("Content-Type"));
        String content = handler.toString();
        Pattern pattern = Pattern.compile("From");
        Matcher matcher = pattern.matcher(content);
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertFalse((boolean)matcher.find());
        OutlookParserTest.assertContains((Object)"29 Jan 2009 19:17:10.0163 (UTC) FILETIME=[2ED25E30:01C98246]", Arrays.asList(metadata.getValues("Message:Raw-Header:X-OriginalArrivalTime")));
        OutlookParserTest.assertContains((Object)"from athena.apache.org (HELO athena.apache.org) (140.211.11.136)\n    by apache.org (qpsmtpd/0.29) with ESMTP; Thu, 29 Jan 2009 11:17:08 -0800", Arrays.asList(metadata.getValues("Message:Raw-Header:Received")));
        Assert.assertEquals((Object)"EX", (Object)metadata.get(Office.MAPI_SENT_BY_SERVER_TYPE));
        Assert.assertEquals((Object)"NOTE", (Object)metadata.get(Office.MAPI_MESSAGE_CLASS));
        Assert.assertEquals((Object)"Jukka Zitting", (Object)metadata.get(Message.MESSAGE_FROM_NAME));
        Assert.assertEquals((Object)"jukka.zitting@gmail.com", (Object)metadata.get(Message.MESSAGE_FROM_EMAIL));
        Assert.assertEquals((Object)"Jukka Zitting", (Object)metadata.get(Office.MAPI_FROM_REPRESENTING_NAME));
        Assert.assertEquals((Object)"jukka.zitting@gmail.com", (Object)metadata.get(Office.MAPI_FROM_REPRESENTING_EMAIL));
        Assert.assertEquals((Object)"tika-dev@lucene.apache.org", (Object)metadata.get(Message.MESSAGE_TO_EMAIL));
        Assert.assertEquals((Object)"tika-dev@lucene.apache.org", (Object)metadata.get(Message.MESSAGE_TO_DISPLAY_NAME));
        Assert.assertEquals((Object)"", (Object)metadata.get(Message.MESSAGE_TO_NAME));
    }

    @Test
    public void testOutlookNew() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/test-outlook2003.msg");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        Assert.assertEquals((Object)"application/vnd.ms-outlook", (Object)metadata.get("Content-Type"));
        Assert.assertEquals((Object)"Welcome to Microsoft Office Outlook 2003", (Object)metadata.get(TikaCoreProperties.TITLE));
        String content = handler.toString();
        OutlookParserTest.assertContains((String)"Outlook 2003", (String)content);
        OutlookParserTest.assertContains((String)"Streamlined Mail Experience", (String)content);
        OutlookParserTest.assertContains((String)"Navigation Pane", (String)content);
        Assert.assertEquals((Object)"", (Object)metadata.get(Message.MESSAGE_TO_EMAIL));
        Assert.assertEquals((Object)"New Outlook User", (Object)metadata.get(Message.MESSAGE_TO_NAME));
        Assert.assertEquals((Object)"New Outlook User", (Object)metadata.get(Message.MESSAGE_TO_DISPLAY_NAME));
    }

    @Test
    public void testOutlookHTMLVersion() throws Exception {
        Metadata metadata = new Metadata();
        StringWriter sw = new StringWriter();
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.setResult(new StreamResult(sw));
        try (InputStream stream = this.getResourceAsStream("/test-documents/testMSG_chinese.msg");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = sw.toString();
        OutlookParserTest.assertContains((String)"<dd>tests.chang@fengttt.com</dd>", (String)content);
        OutlookParserTest.assertContains((String)"<p>Alfresco MSG format testing", (String)content);
        OutlookParserTest.assertContains((String)"<li>1", (String)content);
        OutlookParserTest.assertContains((String)"<li>2", (String)content);
        Assert.assertEquals((long)2L, (long)content.split("<body>").length);
        Assert.assertEquals((long)2L, (long)content.split("<\\/body>").length);
        OutlookParserTest.assertContains((String)"\u5f35\u6bd3\u502b", (String)metadata.get(TikaCoreProperties.CREATOR));
        OutlookParserTest.assertContains((String)"\u9673\u60e0\u73cd", (String)content);
        Assert.assertEquals((Object)"tests.chang@fengttt.com", (Object)metadata.get(Message.MESSAGE_TO_EMAIL));
        Assert.assertEquals((Object)"Tests Chang@FT (\u5f35\u6bd3\u502b)", (Object)metadata.get(Office.MAPI_FROM_REPRESENTING_NAME));
        Assert.assertEquals((Object)"/O=FT GROUP/OU=FT/CN=RECIPIENTS/CN=LYDIACHANG", (Object)metadata.get(Office.MAPI_FROM_REPRESENTING_EMAIL));
    }

    @Test
    public void testOutlookForwarded() throws Exception {
        Metadata metadata = new Metadata();
        StringWriter sw = new StringWriter();
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.setResult(new StreamResult(sw));
        try (InputStream stream = this.getResourceAsStream("/test-documents/testMSG_forwarded.msg");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = sw.toString();
        Assert.assertEquals((long)2L, (long)content.split("<body>").length);
        Assert.assertEquals((long)2L, (long)content.split("<\\/body>").length);
    }

    @Test
    public void testOutlookHTMLfromRTF() throws Exception {
        Metadata metadata = new Metadata();
        StringWriter sw = new StringWriter();
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.setResult(new StreamResult(sw));
        try (InputStream stream = this.getResourceAsStream("/test-documents/test-outlook2003.msg");){
            AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, new ParseContext());
        }
        String content = sw.toString().replaceAll("[\\r\\n\\t]+", " ").replaceAll(" +", " ");
        OutlookParserTest.assertContains((String)"<dd>New Outlook User</dd>", (String)content);
        OutlookParserTest.assertContains((String)"designed <i>to help you", (String)content);
        OutlookParserTest.assertContains((String)"<p> <a href=\"http://r.office.microsoft.com/r/rlidOutlookWelcomeMail10?clid=1033\">Cached Exchange Mode</a>", (String)content);
        OutlookParserTest.assertContains((String)"sign up for a free subscription", (String)content);
        OutlookParserTest.assertContains((String)"Office Newsletter", (String)content);
        OutlookParserTest.assertContains((String)"newsletter will be sent to you", (String)content);
        OutlookParserTest.assertContains((String)"http://r.office.microsoft.com/r/rlidNewsletterSignUp?clid=1033", (String)content);
        Assert.assertEquals((long)2L, (long)content.split("<body>").length);
        Assert.assertEquals((long)2L, (long)content.split("<\\/body>").length);
    }

    @Test
    public void testMAPIMessageClasses() throws Exception {
        for (String messageClass : new String[]{"Appointment", "Contact", "Post", "StickyNote", "Task"}) {
            this.testMsgClass(messageClass, this.getXML((String)new StringBuilder().append((String)"testMSG_").append((String)messageClass).append((String)".msg").toString()).metadata);
        }
        this.testMsgClass("NOTE", this.getXML((String)"test-outlook2003.msg").metadata);
    }

    private void testMsgClass(String expected, Metadata metadata) {
        Assert.assertTrue((String)(expected + ", but got: " + metadata.get(Office.MAPI_MESSAGE_CLASS)), (boolean)expected.equalsIgnoreCase(metadata.get(Office.MAPI_MESSAGE_CLASS).replaceAll("_", "")));
    }

    @Test
    public void testHandlingAllAlternativesBodies() throws Exception {
        List metadataList = this.getRecursiveMetadata("testMSG.msg");
        Assert.assertEquals((long)1L, (long)metadataList.size());
        OutlookParserTest.assertContains((String)"breaking your application", (String)((Metadata)metadataList.get(0)).get(RecursiveParserWrapper.TIKA_CONTENT));
        Assert.assertEquals((Object)"application/vnd.ms-outlook", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
        try (InputStream is = this.getResourceAsStream("tika-config-extract-all-alternatives-msg.xml");){
            TikaConfig tikaConfig = new TikaConfig(is);
            AutoDetectParser p = new AutoDetectParser(tikaConfig);
            metadataList = this.getRecursiveMetadata("testMSG.msg", (Parser)p);
            Assert.assertEquals((long)3L, (long)metadataList.size());
            OutlookParserTest.assertNotContained((String)"breaking your application", (String)((Metadata)metadataList.get(0)).get(RecursiveParserWrapper.TIKA_CONTENT));
            Assert.assertEquals((Object)"application/vnd.ms-outlook", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
            OutlookParserTest.assertContains((String)"breaking your application", (String)((Metadata)metadataList.get(1)).get(RecursiveParserWrapper.TIKA_CONTENT));
            Assert.assertEquals((Object)"application/rtf", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
            OutlookParserTest.assertContains((String)"breaking your application", (String)((Metadata)metadataList.get(2)).get(RecursiveParserWrapper.TIKA_CONTENT));
            Assert.assertTrue((boolean)((Metadata)metadataList.get(2)).get("Content-Type").startsWith("text/plain"));
        }
    }
}

