/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.tika.TikaTest;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.OfficeOpenXMLExtended;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.sax.RecursiveParserWrapperHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class JackcessParserTest
extends TikaTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() throws Exception {
        RecursiveParserWrapper w = new RecursiveParserWrapper(AUTO_DETECT_PARSER);
        for (String fName : new String[]{"testAccess2.accdb", "testAccess2_2000.mdb", "testAccess2_2002-2003.mdb"}) {
            InputStream is = null;
            RecursiveParserWrapperHandler handler = new RecursiveParserWrapperHandler((ContentHandlerFactory)new BasicContentHandlerFactory(BasicContentHandlerFactory.HANDLER_TYPE.XML, -1));
            try {
                is = this.getResourceAsStream("/test-documents/" + fName);
                Metadata meta = new Metadata();
                ParseContext c = new ParseContext();
                w.parse(is, (ContentHandler)handler, meta, c);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            List list = handler.getMetadataList();
            Assert.assertEquals((long)4L, (long)list.size());
            String mainContent = ((Metadata)list.get(0)).get(RecursiveParserWrapperHandler.TIKA_CONTENT);
            JackcessParserTest.assertContains((String)"</thead><tbody>", (String)mainContent);
            JackcessParserTest.assertContains((String)"<th>ShortTextField</th>", (String)mainContent);
            Assert.assertTrue((mainContent.contains("6/24/15") || mainContent.contains("2015-06-24") ? 1 : 0) != 0);
            JackcessParserTest.assertContains((String)"over the bold italic dog", (String)mainContent);
            JackcessParserTest.assertContains((String)"\u666e\u6797\u65af\u987f\u5927\u5b66", (String)mainContent);
            JackcessParserTest.assertContains((String)"Test Document with embedded pdf", (String)((Metadata)list.get(3)).get(RecursiveParserWrapperHandler.TIKA_CONTENT));
        }
    }

    @Test
    public void testPassword() throws Exception {
        Throwable throwable;
        InputStream is;
        ParseContext c = new ParseContext();
        c.set(PasswordProvider.class, (Object)new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "tika";
            }
        });
        String content = null;
        try (InputStream is2 = this.getResourceAsStream("/test-documents/testAccess2_encrypted.accdb");){
            content = this.getText(is2, AUTO_DETECT_PARSER, c);
        }
        JackcessParserTest.assertContains((String)"red and brown", (String)content);
        c.set(PasswordProvider.class, (Object)new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "WRONG";
            }
        });
        boolean ex = false;
        try {
            is = this.getResourceAsStream("/test-documents/testAccess2_encrypted.accdb");
            throwable = null;
            try {
                this.getText(is, AUTO_DETECT_PARSER, c);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (EncryptedDocumentException e) {
            ex = true;
        }
        Assert.assertTrue((String)"failed to throw encrypted document exception for wrong password", (boolean)ex);
        c.set(PasswordProvider.class, (Object)new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return null;
            }
        });
        ex = false;
        try {
            is = this.getResourceAsStream("/test-documents/testAccess2_encrypted.accdb");
            throwable = null;
            try {
                this.getText(is, AUTO_DETECT_PARSER, c);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (EncryptedDocumentException e) {
            ex = true;
        }
        Assert.assertTrue((String)"failed to throw encrypted document exception for null password", (boolean)ex);
        c = new ParseContext();
        ex = false;
        try {
            is = this.getResourceAsStream("/test-documents/testAccess2_encrypted.accdb");
            throwable = null;
            try {
                this.getText(is, AUTO_DETECT_PARSER, c);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (EncryptedDocumentException e) {
            ex = true;
        }
        Assert.assertTrue((String)"failed to throw encrypted document exception for missing password provider", (boolean)ex);
        c = new ParseContext();
        c.set(PasswordProvider.class, (Object)new PasswordProvider(){

            public String getPassword(Metadata metadata) {
                return "tika";
            }
        });
        ex = false;
        try {
            is = this.getResourceAsStream("/test-documents/testAccess2.accdb");
            throwable = null;
            try {
                content = this.getText(is, AUTO_DETECT_PARSER, c);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (EncryptedDocumentException e) {
            ex = true;
        }
        Assert.assertFalse((String)"shouldn't have thrown encrypted document exception for opening unencrypted file that doesn't need passowrd", (boolean)ex);
        JackcessParserTest.assertContains((String)"red and brown", (String)content);
    }

    @Test
    public void testReadOnly() throws Exception {
        TikaTest.XMLResult r = this.getXML("testAccess_V1997.mdb");
        JackcessParserTest.assertContains((String)"hijklmnop", (String)r.xml);
    }

    @Test
    public void testMetadata() throws Exception {
        TikaTest.XMLResult r = this.getXML("testAccess_V1997.mdb");
        Assert.assertEquals((Object)"tmccune", (Object)r.metadata.get(TikaCoreProperties.CREATOR));
        Assert.assertEquals((Object)"Health Market Science", (Object)r.metadata.get(OfficeOpenXMLExtended.COMPANY));
        Assert.assertEquals((Object)"test", (Object)r.metadata.get(TikaCoreProperties.TITLE));
    }
}

