/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.net.URL;
import org.apache.tika.TikaTest;
import org.apache.tika.extractor.ContainerExtractor;
import org.apache.tika.extractor.EmbeddedResourceHandler;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.mime.MediaType;
import org.junit.Assert;

public abstract class AbstractPOIContainerExtractionTest
extends TikaTest {
    public static final MediaType TYPE_DOC = MediaType.application((String)"msword");
    public static final MediaType TYPE_PPT = MediaType.application((String)"vnd.ms-powerpoint");
    public static final MediaType TYPE_XLS = MediaType.application((String)"vnd.ms-excel");
    public static final MediaType TYPE_DOCX = MediaType.application((String)"vnd.openxmlformats-officedocument.wordprocessingml.document");
    public static final MediaType TYPE_PPTX = MediaType.application((String)"vnd.openxmlformats-officedocument.presentationml.presentation");
    public static final MediaType TYPE_XLSX = MediaType.application((String)"vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    public static final MediaType TYPE_MSG = MediaType.application((String)"vnd.ms-outlook");
    public static final MediaType TYPE_TXT = MediaType.text((String)"plain");
    public static final MediaType TYPE_PDF = MediaType.application((String)"pdf");
    public static final MediaType TYPE_JPG = MediaType.image((String)"jpeg");
    public static final MediaType TYPE_GIF = MediaType.image((String)"gif");
    public static final MediaType TYPE_PNG = MediaType.image((String)"png");
    public static final MediaType TYPE_EMF = MediaType.image((String)"emf");
    public static final MediaType TYPE_WMF = MediaType.image((String)"wmf");

    protected static TikaInputStream getTestFile(String filename) throws Exception {
        URL input = AbstractPOIContainerExtractionTest.class.getResource("/test-documents/" + filename);
        Assert.assertNotNull((String)(filename + " not found"), (Object)input);
        return TikaInputStream.get((URL)input);
    }

    protected TikaTest.TrackingHandler process(String filename, ContainerExtractor extractor, boolean recurse) throws Exception {
        try (TikaInputStream stream = AbstractPOIContainerExtractionTest.getTestFile(filename);){
            Assert.assertEquals((Object)true, (Object)extractor.isSupported(stream));
            TikaTest.TrackingHandler handler = new TikaTest.TrackingHandler();
            if (recurse) {
                extractor.extract(stream, extractor, (EmbeddedResourceHandler)handler);
            } else {
                extractor.extract(stream, null, (EmbeddedResourceHandler)handler);
            }
            TikaTest.TrackingHandler trackingHandler = handler;
            return trackingHandler;
        }
    }
}

