/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPMM;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.image.JpegParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class JpegParserTest {
    static TimeZone CURR_TIME_ZONE = TimeZone.getDefault();
    private final Parser parser = new JpegParser();

    @Test
    public void testJPEG() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_EXIF.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"3888", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"2592", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"8", (Object)metadata.get(Metadata.BITS_PER_SAMPLE));
        Assertions.assertEquals(null, (Object)metadata.get(Metadata.SAMPLES_PER_PIXEL));
        Assertions.assertEquals((Object)"6.25E-4", (Object)metadata.get(Metadata.EXPOSURE_TIME));
        Assertions.assertEquals((Object)"5.6", (Object)metadata.get(Metadata.F_NUMBER));
        Assertions.assertEquals((Object)"false", (Object)metadata.get(Metadata.FLASH_FIRED));
        Assertions.assertEquals((Object)"194.0", (Object)metadata.get(Metadata.FOCAL_LENGTH));
        Assertions.assertEquals((Object)"400", (Object)metadata.get(Metadata.ISO_SPEED_RATINGS));
        Assertions.assertEquals((Object)"Canon", (Object)metadata.get(Metadata.EQUIPMENT_MAKE));
        Assertions.assertEquals((Object)"Canon EOS 40D", (Object)metadata.get(Metadata.EQUIPMENT_MODEL));
        Assertions.assertEquals((Object)"Adobe Photoshop CS3 Macintosh", (Object)metadata.get(Metadata.SOFTWARE));
        Assertions.assertEquals(null, (Object)metadata.get(Metadata.ORIENTATION));
        Assertions.assertEquals((Object)"240.0", (Object)metadata.get(Metadata.RESOLUTION_HORIZONTAL));
        Assertions.assertEquals((Object)"240.0", (Object)metadata.get(Metadata.RESOLUTION_VERTICAL));
        Assertions.assertEquals((Object)"Inch", (Object)metadata.get(Metadata.RESOLUTION_UNIT));
        Assertions.assertEquals((Object)"Canon EOS 40D", (Object)metadata.get("Exif IFD0:Model"));
        Assertions.assertEquals((Object)"2009-10-02T23:02:49", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assertions.assertEquals((Object)"2009-08-11T09:09:45", (Object)metadata.get(TikaCoreProperties.CREATED), (String)"Date/Time Original for when the photo was taken, unspecified time zone");
        List<String> keywords = Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT));
        Assertions.assertTrue((boolean)keywords.contains("canon-55-250"), (String)("'canon-55-250' expected in " + keywords));
        Assertions.assertTrue((boolean)keywords.contains("moscow-birds"), (String)("'moscow-birds' expected in " + keywords));
        Assertions.assertTrue((boolean)keywords.contains("serbor"), (String)("'serbor' expected in " + keywords));
        Assertions.assertFalse((boolean)keywords.contains("canon-55-250 moscow-birds serbor"));
    }

    @Test
    public void testJPEGGeo() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_GEO.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"12.54321", (Object)metadata.get(Metadata.LATITUDE));
        Assertions.assertEquals((Object)"-54.1234", (Object)metadata.get(Metadata.LONGITUDE));
        Assertions.assertEquals((Object)"3888", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"2592", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"8", (Object)metadata.get(Metadata.BITS_PER_SAMPLE));
        Assertions.assertEquals(null, (Object)metadata.get(Metadata.SAMPLES_PER_PIXEL));
        Assertions.assertEquals((Object)"6.25E-4", (Object)metadata.get(Metadata.EXPOSURE_TIME));
        Assertions.assertEquals((Object)"5.6", (Object)metadata.get(Metadata.F_NUMBER));
        Assertions.assertEquals((Object)"false", (Object)metadata.get(Metadata.FLASH_FIRED));
        Assertions.assertEquals((Object)"194.0", (Object)metadata.get(Metadata.FOCAL_LENGTH));
        Assertions.assertEquals((Object)"400", (Object)metadata.get(Metadata.ISO_SPEED_RATINGS));
        Assertions.assertEquals((Object)"Canon", (Object)metadata.get(Metadata.EQUIPMENT_MAKE));
        Assertions.assertEquals((Object)"Canon EOS 40D", (Object)metadata.get(Metadata.EQUIPMENT_MODEL));
        Assertions.assertEquals((Object)"Adobe Photoshop CS3 Macintosh", (Object)metadata.get(Metadata.SOFTWARE));
        Assertions.assertEquals(null, (Object)metadata.get(Metadata.ORIENTATION));
        Assertions.assertEquals((Object)"240.0", (Object)metadata.get(Metadata.RESOLUTION_HORIZONTAL));
        Assertions.assertEquals((Object)"240.0", (Object)metadata.get(Metadata.RESOLUTION_VERTICAL));
        Assertions.assertEquals((Object)"Inch", (Object)metadata.get(Metadata.RESOLUTION_UNIT));
        Assertions.assertEquals((Object)"2009-08-11T09:09:45", (Object)metadata.get(TikaCoreProperties.CREATED), (String)"Date/Time Original for when the photo was taken, unspecified time zone");
        Assertions.assertEquals((Object)"2009-10-02T23:02:49", (Object)metadata.get(TikaCoreProperties.MODIFIED), (String)"This image has different Date/Time than Date/Time Original, so it is probably modification date");
        Assertions.assertEquals((Object)"2009-08-11T09:09:45", (Object)metadata.get(TIFF.ORIGINAL_DATE), (String)"Date/Time Original should be stored in EXIF field too");
        Assertions.assertEquals((Object)"canon-55-250", (Object)metadata.getValues(TikaCoreProperties.SUBJECT)[0]);
    }

    @Test
    public void testJPEGGeo2() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_GEO_2.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"51.575762", (Object)metadata.get(Metadata.LATITUDE));
        Assertions.assertEquals((Object)"-1.567886", (Object)metadata.get(Metadata.LONGITUDE));
    }

    @Test
    public void testJPEGTitleAndDescription() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_commented.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"Tosteberga \u00c4ngar", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Bird site in north eastern Sk\u00e5ne, Sweden.\n(new line)", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
        Assertions.assertEquals((Object)"Some Tourist", (Object)metadata.get(TikaCoreProperties.CREATOR));
        List<String> keywords = Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT));
        Assertions.assertTrue((boolean)keywords.contains("coast"));
        Assertions.assertTrue((boolean)keywords.contains("bird watching"));
        Assertions.assertEquals((Object)"103", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"77", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"8", (Object)metadata.get(Metadata.BITS_PER_SAMPLE));
        Assertions.assertEquals(null, (Object)metadata.get(Metadata.SAMPLES_PER_PIXEL));
        Assertions.assertEquals((Object)"1.0E-6", (Object)metadata.get(Metadata.EXPOSURE_TIME));
        Assertions.assertEquals((Object)"2.8", (Object)metadata.get(Metadata.F_NUMBER));
        Assertions.assertEquals((Object)"4.6", (Object)metadata.get(Metadata.FOCAL_LENGTH));
        Assertions.assertEquals((Object)"114", (Object)metadata.get(Metadata.ISO_SPEED_RATINGS));
        Assertions.assertEquals(null, (Object)metadata.get(Metadata.EQUIPMENT_MAKE));
        Assertions.assertEquals(null, (Object)metadata.get(Metadata.EQUIPMENT_MODEL));
        Assertions.assertEquals(null, (Object)metadata.get(Metadata.SOFTWARE));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(Metadata.ORIENTATION));
        Assertions.assertEquals((Object)"300.0", (Object)metadata.get(Metadata.RESOLUTION_HORIZONTAL));
        Assertions.assertEquals((Object)"300.0", (Object)metadata.get(Metadata.RESOLUTION_VERTICAL));
        Assertions.assertEquals((Object)"Inch", (Object)metadata.get(Metadata.RESOLUTION_UNIT));
        Assertions.assertEquals((Object)"IEC", (Object)metadata.get("ICC:Device manufacturer").trim());
        Assertions.assertNull((Object)metadata.get("Device manufacturer"));
    }

    @Test
    public void testJPEGTitleAndDescriptionPhotoshop() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_commented_pspcs2mac.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"Tosteberga \u00c4ngar", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Bird site in north eastern Sk\u00e5ne, Sweden.\n(new line)", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
        Assertions.assertEquals((Object)"Some Tourist", (Object)metadata.get(TikaCoreProperties.CREATOR));
        List<String> keywords = Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT));
        Assertions.assertTrue((boolean)keywords.contains("bird watching"), (String)("got " + keywords));
    }

    @Test
    public void testJPEGTitleAndDescriptionXnviewmp() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_commented_xnviewmp026.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"Bird site in north eastern Sk\u00e5ne, Sweden.\n(new line)", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
        String[] subject = metadata.getValues(TikaCoreProperties.SUBJECT);
        List<String> keywords = Arrays.asList(subject);
        Assertions.assertTrue((boolean)keywords.contains("coast"), (String)("'coast' not in " + keywords));
        Assertions.assertTrue((boolean)keywords.contains("nature reserve"), (String)("'nature reserve' not in " + keywords));
    }

    @Test
    public void testJPEGoddTagComponent() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_oddTagComponent.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals(null, (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
        Assertions.assertEquals((Object)"251", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"384", (Object)metadata.get(Metadata.IMAGE_LENGTH));
    }

    @Test
    public void testJPEGEmptyEXIFDateTime() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_EXIF_emptyDateTime.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"300.0", (Object)metadata.get(TIFF.RESOLUTION_HORIZONTAL));
        Assertions.assertEquals((Object)"300.0", (Object)metadata.get(TIFF.RESOLUTION_VERTICAL));
    }

    @Test
    public void testJPEGXMPMM() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testJPEG_EXIF_emptyDateTime.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"xmp.did:49E997348D4911E1AB62EBF9B374B234", (Object)metadata.get(XMPMM.DOCUMENTID));
    }
}

