/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.image.AbstractImageParser;
import org.apache.tika.parser.image.ImageParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ImageParserTest
extends TikaTest {
    private final Parser parser = new ImageParser();

    @Test
    public void testBMP() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/bmp");
        try (InputStream stream = this.getResourceAsStream("/test-documents/testBMP.bmp");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"75", (Object)metadata.get("height"));
        Assertions.assertEquals((Object)"100", (Object)metadata.get("width"));
        Assertions.assertEquals((Object)"8 8 8", (Object)metadata.get("Data BitsPerSample"));
        Assertions.assertEquals((Object)"1.0", (Object)metadata.get("Dimension PixelAspectRatio"));
        Assertions.assertEquals((Object)"BI_RGB", (Object)metadata.get("Compression CompressionTypeName"));
        Assertions.assertEquals((Object)"image/bmp", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"100", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"75", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"8 8 8", (Object)metadata.get(Metadata.BITS_PER_SAMPLE));
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(TikaCoreProperties.NUM_IMAGES));
    }

    @Test
    public void testGIF() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/gif");
        try (InputStream stream = this.getResourceAsStream("/test-documents/testGIF.gif");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"75", (Object)metadata.get("height"));
        Assertions.assertEquals((Object)"100", (Object)metadata.get("width"));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("Compression Lossless"));
        Assertions.assertEquals((Object)"Normal", (Object)metadata.get("Dimension ImageOrientation"));
        Assertions.assertEquals((Object)"lzw", (Object)metadata.get("Compression CompressionTypeName"));
        Assertions.assertEquals((Object)"0", (Object)metadata.get("Dimension HorizontalPixelOffset"));
        Assertions.assertEquals((Object)"imageLeftPosition=0, imageTopPosition=0, imageWidth=100, imageHeight=75, interlaceFlag=false", (Object)metadata.get("ImageDescriptor"));
        Assertions.assertEquals((Object)"Index", (Object)metadata.get("Data SampleFormat"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("Chroma NumChannels"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("Compression NumProgressiveScans"));
        Assertions.assertEquals((Object)"RGB", (Object)metadata.get("Chroma ColorSpaceType"));
        Assertions.assertEquals((Object)"Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership.", (Object)metadata.get("CommentExtensions CommentExtension"));
        Assertions.assertEquals((Object)"value=Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership., encoding=ISO-8859-1, compression=none", (Object)metadata.get("Text TextEntry"));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("Chroma BlackIsZero"));
        Assertions.assertEquals((Object)"disposalMethod=none, userInputFlag=false, transparentColorFlag=false, delayTime=0, transparentColorIndex=0", (Object)metadata.get("GraphicControlExtension"));
        Assertions.assertEquals((Object)"0", (Object)metadata.get("Dimension VerticalPixelOffset"));
        Assertions.assertEquals((Object)"image/gif", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"100", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"75", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership.", (Object)metadata.get(TikaCoreProperties.COMMENTS));
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(TikaCoreProperties.NUM_IMAGES));
    }

    @Test
    public void testJPEG() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/jpeg");
        try (InputStream stream = this.getResourceAsStream("/test-documents/testJPEG.jpg");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"75", (Object)metadata.get("height"));
        Assertions.assertEquals((Object)"100", (Object)metadata.get("width"));
        Assertions.assertEquals((Object)"0.35277778", (Object)metadata.get("Dimension VerticalPixelSize"));
        Assertions.assertEquals((Object)"false", (Object)metadata.get("Compression Lossless"));
        Assertions.assertEquals((Object)"class=0, htableId=0", (Object)metadata.get("markerSequence dht dhtable"));
        Assertions.assertEquals((Object)"majorVersion=1, minorVersion=1, resUnits=1, Xdensity=72, Ydensity=72, thumbWidth=0, thumbHeight=0", (Object)metadata.get("JPEGvariety app0JFIF"));
        Assertions.assertEquals((Object)"225", (Object)metadata.get("markerSequence unknown"));
        Assertions.assertEquals((Object)"componentSelector=1, dcHuffTable=0, acHuffTable=0", (Object)metadata.get("markerSequence sos scanComponentSpec"));
        Assertions.assertEquals((Object)"normal", (Object)metadata.get("Dimension ImageOrientation"));
        Assertions.assertEquals((Object)"1.0", (Object)metadata.get("Dimension PixelAspectRatio"));
        Assertions.assertEquals((Object)"elementPrecision=0, qtableId=0", (Object)metadata.get("markerSequence dqt dqtable"));
        Assertions.assertEquals((Object)"numScanComponents=3, startSpectralSelection=0, endSpectralSelection=63, approxHigh=0, approxLow=0", (Object)metadata.get("markerSequence sos"));
        Assertions.assertEquals((Object)"componentId=1, HsamplingFactor=1, VsamplingFactor=1, QtableSelector=0", (Object)metadata.get("markerSequence sof componentSpec"));
        Assertions.assertEquals((Object)"JPEG", (Object)metadata.get("Compression CompressionTypeName"));
        Assertions.assertEquals((Object)"0.35277778", (Object)metadata.get("Dimension HorizontalPixelSize"));
        Assertions.assertEquals((Object)"Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership.", (Object)metadata.get("markerSequence com"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("Chroma NumChannels"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("Compression NumProgressiveScans"));
        Assertions.assertEquals((Object)"YCbCr", (Object)metadata.get("Chroma ColorSpaceType"));
        Assertions.assertEquals((Object)"keyword=comment, value=Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership.", (Object)metadata.get("Text TextEntry"));
        Assertions.assertEquals((Object)"image/jpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"process=0, samplePrecision=8, numLines=75, samplesPerLine=100, numFrameComponents=3", (Object)metadata.get("markerSequence sof"));
        Assertions.assertEquals((Object)"100", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"75", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership.", (Object)metadata.get(TikaCoreProperties.COMMENTS));
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(TikaCoreProperties.NUM_IMAGES));
    }

    @Test
    public void testPNG() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/png");
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPNG.png");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"75", (Object)metadata.get("height"));
        Assertions.assertEquals((Object)"100", (Object)metadata.get("width"));
        Assertions.assertEquals((Object)"0.35273367", (Object)metadata.get("Dimension VerticalPixelSize"));
        Assertions.assertEquals((Object)"8 8 8", (Object)metadata.get("Data BitsPerSample"));
        Assertions.assertEquals((Object)"Perceptual", (Object)metadata.get("sRGB"));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("Compression Lossless"));
        Assertions.assertEquals((Object)"year=2008, month=5, day=6, hour=6, minute=18, second=47", (Object)metadata.get("tIME"));
        Assertions.assertEquals((Object)"Normal", (Object)metadata.get("Dimension ImageOrientation"));
        Assertions.assertEquals((Object)"1.0", (Object)metadata.get("Dimension PixelAspectRatio"));
        Assertions.assertEquals((Object)"keyword=Comment, value=Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership.", (Object)metadata.get("tEXt tEXtEntry"));
        Assertions.assertEquals((Object)"deflate", (Object)metadata.get("Compression CompressionTypeName"));
        Assertions.assertEquals((Object)"UnsignedIntegral", (Object)metadata.get("Data SampleFormat"));
        Assertions.assertEquals((Object)"0.35273367", (Object)metadata.get("Dimension HorizontalPixelSize"));
        Assertions.assertEquals((Object)"none", (Object)metadata.get("Transparency Alpha"));
        Assertions.assertEquals((Object)"pixelsPerUnitXAxis=2835, pixelsPerUnitYAxis=2835, unitSpecifier=meter", (Object)metadata.get("pHYs"));
        Assertions.assertEquals((Object)"3", (Object)metadata.get("Chroma NumChannels"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("Compression NumProgressiveScans"));
        Assertions.assertEquals((Object)"RGB", (Object)metadata.get("Chroma ColorSpaceType"));
        Assertions.assertEquals((Object)"keyword=Comment, value=Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file distributed with this work for additional information regarding copyright ownership., encoding=ISO-8859-1, compression=none", (Object)metadata.get("Text TextEntry"));
        Assertions.assertEquals((Object)"PixelInterleaved", (Object)metadata.get("Data PlanarConfiguration"));
        Assertions.assertEquals((Object)"width=100, height=75, bitDepth=8, colorType=RGB, compressionMethod=deflate, filterMethod=adaptive, interlaceMethod=none", (Object)metadata.get("IHDR"));
        Assertions.assertEquals((Object)"true", (Object)metadata.get("Chroma BlackIsZero"));
        Assertions.assertEquals((Object)"year=2008, month=5, day=6, hour=6, minute=18, second=47", (Object)metadata.get("Document ImageModificationTime"));
        Assertions.assertEquals((Object)"image/png", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"100", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"75", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"8 8 8", (Object)metadata.get(Metadata.BITS_PER_SAMPLE));
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(TikaCoreProperties.NUM_IMAGES));
    }

    @Test
    public void testJBIG2() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/x-jbig2");
        try (InputStream stream = this.getResourceAsStream("/test-documents/testJBIG2.jb2");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"78", (Object)metadata.get("height"));
        Assertions.assertEquals((Object)"328", (Object)metadata.get("width"));
        Assertions.assertEquals((Object)"image/x-jbig2", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((int)1, (Integer)metadata.getInt(TikaCoreProperties.NUM_IMAGES));
    }

    @Test
    public void testMimeTypeToOCRMimeTypeConversion() throws Exception {
        Assertions.assertEquals((Object)new MediaType("image", "OCR-png"), (Object)AbstractImageParser.convertToOCRMediaType((MediaType)MediaType.image((String)"png")));
    }

    @Test
    public void testNPEOnEmptyContentType() throws Exception {
        Metadata metadata = new Metadata();
        try (InputStream stream = this.getResourceAsStream("/test-documents/testBMP.bmp");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        metadata = new Metadata();
        metadata.set("Content-Type", "unparseablegarbage");
        stream = this.getResourceAsStream("/test-documents/testBMP.bmp");
        try {
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

