/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.jpeg.JpegCommentDirectory;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.image.ImageMetadataExtractor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ImageMetadataExtractorTest {
    @Test
    public void testHandleDirectories() throws MetadataException {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        ImageMetadataExtractor.DirectoryHandler handler1 = (ImageMetadataExtractor.DirectoryHandler)Mockito.mock(ImageMetadataExtractor.DirectoryHandler.class);
        ImageMetadataExtractor e = new ImageMetadataExtractor(metadata, new ImageMetadataExtractor.DirectoryHandler[]{handler1});
        JpegCommentDirectory directory = new JpegCommentDirectory();
        Iterator directories = (Iterator)Mockito.mock(Iterator.class);
        Mockito.when((Object)directories.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when(directories.next()).thenReturn((Object)directory);
        Mockito.when((Object)handler1.supports(JpegCommentDirectory.class)).thenReturn((Object)true);
        e.handle(directories);
        ((ImageMetadataExtractor.DirectoryHandler)Mockito.verify((Object)handler1)).supports(JpegCommentDirectory.class);
        ((ImageMetadataExtractor.DirectoryHandler)Mockito.verify((Object)handler1)).handle((Directory)directory, metadata);
    }

    @Test
    public void testExifHandlerSupports() {
        Assertions.assertTrue((boolean)new ImageMetadataExtractor.ExifHandler().supports(ExifIFD0Directory.class));
        Assertions.assertTrue((boolean)new ImageMetadataExtractor.ExifHandler().supports(ExifSubIFDDirectory.class));
        Assertions.assertFalse((boolean)new ImageMetadataExtractor.ExifHandler().supports(Directory.class));
        Assertions.assertFalse((boolean)new ImageMetadataExtractor.ExifHandler().supports(JpegCommentDirectory.class));
    }

    @Test
    public void testExifHandlerParseDate() throws MetadataException {
        ExifSubIFDDirectory exif = (ExifSubIFDDirectory)Mockito.mock(ExifSubIFDDirectory.class);
        Mockito.when((Object)exif.containsTag(36867)).thenReturn((Object)true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        calendar.setTimeInMillis(0L);
        calendar.set(2000, 0, 1, 0, 0, 0);
        Mockito.when((Object)exif.getDate(36867)).thenReturn((Object)calendar.getTime());
        Metadata metadata = new Metadata();
        new ImageMetadataExtractor.ExifHandler().handle((Directory)exif, metadata);
        Assertions.assertEquals((Object)"2000-01-01T00:00:00", (Object)metadata.get(TikaCoreProperties.CREATED), (String)"Should be ISO date without time zone");
    }

    @Test
    public void testExifHandlerParseDateFallback() throws MetadataException {
        ExifIFD0Directory exif = (ExifIFD0Directory)Mockito.mock(ExifIFD0Directory.class);
        Mockito.when((Object)exif.containsTag(306)).thenReturn((Object)true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        calendar.setTimeInMillis(0L);
        calendar.set(1999, 0, 1, 0, 0, 0);
        Mockito.when((Object)exif.getDate(306)).thenReturn((Object)calendar.getTime());
        Metadata metadata = new Metadata();
        new ImageMetadataExtractor.ExifHandler().handle((Directory)exif, metadata);
        Assertions.assertEquals((Object)"1999-01-01T00:00:00", (Object)metadata.get(TikaCoreProperties.CREATED), (String)"Should try EXIF Date/Time if Original is not set");
    }

    @Test
    public void testExifHandlerParseDateError() throws MetadataException {
        ExifIFD0Directory exif = (ExifIFD0Directory)Mockito.mock(ExifIFD0Directory.class);
        Mockito.when((Object)exif.containsTag(36867)).thenReturn((Object)true);
        Mockito.when((Object)exif.getDate(36867)).thenReturn(null);
        Metadata metadata = new Metadata();
        new ImageMetadataExtractor.ExifHandler().handle((Directory)exif, metadata);
        Assertions.assertNull((Object)metadata.get(TikaCoreProperties.CREATED), (String)"Parsing should proceed without date");
    }

    @Test
    public void testCopyUnknownFieldsHandler() throws MetadataException {
        Directory d = (Directory)Mockito.mock(Directory.class);
        Tag t1 = (Tag)Mockito.mock(Tag.class);
        Mockito.when((Object)t1.getTagName()).thenReturn((Object)"Image Description");
        Mockito.when((Object)t1.getDescription()).thenReturn((Object)"t1");
        Tag t2 = (Tag)Mockito.mock(Tag.class);
        Mockito.when((Object)t2.getTagName()).thenReturn((Object)TikaCoreProperties.SUBJECT.toString());
        Mockito.when((Object)t2.getDescription()).thenReturn((Object)"known");
        Tag t3 = (Tag)Mockito.mock(Tag.class);
        Mockito.when((Object)t3.getTagName()).thenReturn((Object)TikaCoreProperties.DESCRIPTION.getName());
        Mockito.when((Object)t3.getDescription()).thenReturn((Object)"known");
        List<Tag> tags = Arrays.asList(t1, t2, t3);
        Mockito.when((Object)d.getTags()).thenReturn(tags);
        Metadata metadata = new Metadata();
        new ImageMetadataExtractor.CopyUnknownFieldsHandler().handle(d, metadata);
        Assertions.assertEquals((Object)"t1", (Object)metadata.get("Image Description"));
        Assertions.assertNull((Object)metadata.get(TikaCoreProperties.SUBJECT), (String)"keywords should be excluded from bulk copy because it is a defined field");
        Assertions.assertNull((Object)metadata.get(TikaCoreProperties.DESCRIPTION));
    }
}

