/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.InputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.image.ICNSParser;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ICNSParserTest {
    private final Parser parser = new ICNSParser();

    @Test
    public void testICNS_basic() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/icns");
        metadata.set("Icons count", "1");
        metadata.set("Icons details", "512x512 (JPEG 2000 or PNG format)");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testICNS_basic.icns");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
    }

    @Test
    public void testICNS() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/icns");
        metadata.set("Icons count", "2");
        metadata.set("Icons details", "16x16 (24 bpp), 32x32 (24 bpp)");
        metadata.set("Masked icon count", "2");
        metadata.set("Masked icon details", "16x16 (8 bpp), 32x32 (8 bpp)");
        try (InputStream stream = this.getClass().getResourceAsStream("/test-documents/testICNS.icns");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
    }
}

