/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.font;

import java.io.InputStream;
import java.net.URL;
import org.apache.tika.TikaTest;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;

public class FontParsersTest
extends TikaTest {
    @Test
    public void testAdobeFontMetricParsing() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        try (TikaInputStream stream = TikaInputStream.get((URL)this.getResourceAsUrl("/test-documents/testAFM.afm"));){
            AUTO_DETECT_PARSER.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
        }
        Assert.assertEquals((Object)"application/x-font-adobe-metric", (Object)metadata.get("Content-Type"));
        Assert.assertEquals((Object)"TestFullName", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assert.assertEquals((Object)"Fri Jul 15 17:50:51 2011", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assert.assertEquals((Object)"TestFontName", (Object)metadata.get("FontName"));
        Assert.assertEquals((Object)"TestFullName", (Object)metadata.get("FontFullName"));
        Assert.assertEquals((Object)"TestSymbol", (Object)metadata.get("FontFamilyName"));
        Assert.assertEquals((Object)"Medium", (Object)metadata.get("FontWeight"));
        Assert.assertEquals((Object)"001.008", (Object)metadata.get("FontVersion"));
        String content = handler.toString();
        FontParsersTest.assertContains((String)"Comments", (String)content);
        FontParsersTest.assertContains((String)"This is a comment in a sample file", (String)content);
        FontParsersTest.assertContains((String)"UniqueID 12345", (String)content);
    }

    @Test
    public void testTTFParsing() throws Exception {
        BodyContentHandler handler = new BodyContentHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        try (TikaInputStream stream = TikaInputStream.get((URL)this.getResourceAsUrl("/test-documents/testTrueType3.ttf"));){
            AUTO_DETECT_PARSER.parse((InputStream)stream, (ContentHandler)handler, metadata, context);
        }
        Assert.assertEquals((Object)"application/x-font-ttf", (Object)metadata.get("Content-Type"));
        Assert.assertEquals((Object)"Open Sans Bold", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assert.assertEquals((Object)"2010-12-30T11:04:00Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assert.assertEquals((Object)"2011-05-05T12:37:53Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        Assert.assertEquals((Object)"Open Sans Bold", (Object)metadata.get("FontName"));
        Assert.assertEquals((Object)"Open Sans", (Object)metadata.get("FontFamilyName"));
        Assert.assertEquals((Object)"Bold", (Object)metadata.get("FontSubFamilyName"));
        Assert.assertEquals((Object)"OpenSans-Bold", (Object)metadata.get("PSName"));
        Assert.assertEquals((Object)"Digitized", (Object)metadata.get("Copyright").substring(0, 9));
        Assert.assertEquals((Object)"Open Sans", (Object)metadata.get("Trademark").substring(0, 9));
        Assert.assertEquals(null, (Object)metadata.get("FontFullName"));
        Assert.assertEquals(null, (Object)metadata.get("FontWeight"));
        Assert.assertEquals(null, (Object)metadata.get("FontVersion"));
        String content = handler.toString();
        Assert.assertEquals((Object)"", (Object)content);
    }
}

