/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.dwg.DWGParser;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.utils.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DWGParserTest
extends TikaTest {
    public boolean canRun(DWGParser parser) {
        String dwgRead = parser.getDwgReadExecutable();
        if (!StringUtils.isBlank((String)dwgRead) && !Files.isRegularFile(Paths.get(dwgRead, new String[0]), new LinkOption[0])) {
            return false;
        }
        String[] checkCmd = new String[]{dwgRead};
        return ExternalParser.check((String[])checkCmd, (int[])new int[0]);
    }

    @Test
    public void testDWG2000Parser() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2000.dwg");
        this.testParserAlt(input);
    }

    @Test
    public void testDWG2004Parser() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2004.dwg");
        this.testParser(input);
    }

    @Test
    public void testDWG2004ParserNoHeaderAddress() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2004_no_header.dwg");
        this.testParserNoHeader(input);
    }

    @Test
    public void testDWG2007Parser() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2007.dwg");
        this.testParser(input);
    }

    @Test
    public void testDWG2010Parser() throws Exception {
        InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2010.dwg");
        this.testParser(input);
    }

    @Test
    public void testDWG2010CustomPropertiesParser() throws Exception {
        InputStream testInput = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2010_custom_props.dwg");
        this.testParser(testInput);
        try (InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWG2010_custom_props.dwg");){
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DWGParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"valueforcustomprop1", (Object)metadata.get(DWGParser.DWG_CUSTOM_META_PREFIX + "customprop1"));
            Assertions.assertEquals((Object)"valueforcustomprop2", (Object)metadata.get(DWGParser.DWG_CUSTOM_META_PREFIX + "customprop2"));
        }
    }

    @Test
    public void testDWGMechParser() throws Exception {
        String[] types;
        for (String type : types = new String[]{"6", "2004", "2004DX", "2005", "2006", "2007", "2008", "2009", "2010", "2011"}) {
            InputStream input = DWGParserTest.class.getResourceAsStream("/test-documents/testDWGmech" + type + ".dwg");
            this.testParserAlt(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testParser(InputStream input) throws Exception {
        try {
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DWGParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"image/vnd.dwg", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Gym class featuring a brown fox and lazy dog", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertEquals((Object)"Nevin Nollop", (Object)metadata.get(TikaCoreProperties.CREATOR));
            DWGParserTest.assertContains((Object)"Pangram, fox, dog", Arrays.asList(metadata.getValues(TikaCoreProperties.SUBJECT)));
            Assertions.assertEquals((Object)"Lorem ipsum", (Object)metadata.get(TikaCoreProperties.COMMENTS).substring(0, 11));
            Assertions.assertEquals((Object)"http://www.alfresco.com", (Object)metadata.get(TikaCoreProperties.RELATION));
            String content = handler.toString();
            DWGParserTest.assertContains((String)"The quick brown fox jumps over the lazy dog", (String)content);
            DWGParserTest.assertContains((String)"Gym class", (String)content);
            DWGParserTest.assertContains((String)"www.alfresco.com", (String)content);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testParserNoHeader(InputStream input) throws Exception {
        try {
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DWGParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"image/vnd.dwg", (Object)metadata.get("Content-Type"));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.CREATOR));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.SUBJECT));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.COMMENTS));
            Assertions.assertNull((Object)metadata.get(TikaCoreProperties.RELATION));
            String content = handler.toString();
            Assertions.assertEquals((Object)"", (Object)content);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testParserAlt(InputStream input) throws Exception {
        try {
            Metadata metadata = new Metadata();
            BodyContentHandler handler = new BodyContentHandler();
            new DWGParser().parse(input, (ContentHandler)handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"image/vnd.dwg", (Object)metadata.get("Content-Type"));
            Assertions.assertEquals((Object)"Test Title", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"Test Subject", (Object)metadata.get(TikaCoreProperties.DESCRIPTION));
            Assertions.assertEquals((Object)"My Author", (Object)metadata.get(TikaCoreProperties.CREATOR));
            Assertions.assertEquals((Object)"My keyword1, MyKeyword2", (Object)metadata.get(TikaCoreProperties.SUBJECT));
            Assertions.assertEquals((Object)"This is a comment", (Object)metadata.get(TikaCoreProperties.COMMENTS));
            Assertions.assertEquals((Object)"bejanpol", (Object)metadata.get(TikaCoreProperties.MODIFIER));
            Assertions.assertEquals((Object)"http://mycompany/drawings", (Object)metadata.get(TikaCoreProperties.RELATION));
            Assertions.assertEquals((Object)"MyCustomPropertyValue", (Object)metadata.get(DWGParser.DWG_CUSTOM_META_PREFIX + "MyCustomProperty"));
            String content = handler.toString();
            DWGParserTest.assertContains((String)"This is a comment", (String)content);
            DWGParserTest.assertContains((String)"mycompany", (String)content);
        }
        finally {
            input.close();
        }
    }

    @Test
    public void testAC1027() throws Exception {
        Metadata metadata = this.getXML((String)"testDWG-AC1027.dwg").metadata;
        Assertions.assertEquals((Object)"hlu", (Object)metadata.get(TikaCoreProperties.MODIFIER));
    }

    @Test
    public void testAC1032() throws Exception {
        Metadata metadata = this.getXML((String)"testDWG-AC1032.dwg").metadata;
        Assertions.assertEquals((Object)"jlakshvi", (Object)metadata.get(TikaCoreProperties.MODIFIER));
        Assertions.assertEquals((Object)"CUSTOMER'S ADDRESS", (Object)metadata.get("dwg-custom:CUSTOMER'S ADDRESS"));
    }

    @Test
    public void testDWGReadexe() throws Exception {
        InputStream stream = this.getResourceAsStream("/test-configs/tika-config-dwgRead.xml");
        DWGParser parser = (DWGParser)((CompositeParser)new TikaConfig(stream).getParser()).getAllComponentParsers().get(0);
        Assumptions.assumeTrue((boolean)this.canRun(parser), (String)"Can't run DWGRead.exe");
        String output = this.getText("architectural_-_annotation_scaling_and_multileaders.dwg", (Parser)parser);
        DWGParserTest.assertContains((String)"ELEV. 11'-9\" TOP OF SECOND FLR.", (String)output);
    }

    @Test
    public void testDWGReadtimeout() throws TikaException, IOException, SAXException {
        InputStream stream = this.getResourceAsStream("/test-configs/tika-config-dwgRead-Timeout.xml");
        DWGParser parser = (DWGParser)((CompositeParser)new TikaConfig(stream).getParser()).getAllComponentParsers().get(0);
        Assumptions.assumeTrue((boolean)this.canRun(parser), (String)"Can't run DWGRead.exe");
        TikaException thrown = (TikaException)Assertions.assertThrows(TikaException.class, () -> this.getText("architectural_-_annotation_scaling_and_multileaders.dwg", (Parser)parser), (String)"Expected getText() to throw TikaException but it failed");
        Assertions.assertTrue((boolean)thrown.getMessage().contains("Timeout setting exceeded current setting of"));
    }
}

