/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.TikaTest;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMP;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.xml.sax.ContentHandler;

public class MP4ParserTest
extends TikaTest {
    Set<String> skipKeysA = new HashSet<String>();
    Set<String> skipKeysB = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMP4ParsingAudio() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP4.m4a", metadata);
        Assertions.assertEquals((Object)"audio/mp4", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Test Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"2012-01-28T18:39:18Z", (Object)metadata.get(TikaCoreProperties.CREATED));
        Assertions.assertEquals((Object)"2012-01-28T18:40:25Z", (Object)metadata.get(TikaCoreProperties.MODIFIED));
        MP4ParserTest.assertContains((String)"Test Title", (String)content);
        MP4ParserTest.assertContains((String)"Test Artist", (String)content);
        MP4ParserTest.assertContains((String)"Test Album", (String)content);
        MP4ParserTest.assertContains((String)"2008", (String)content);
        MP4ParserTest.assertContains((String)"Test Comment", (String)content);
        MP4ParserTest.assertContains((String)"Test Genre", (String)content);
        Assertions.assertEquals((Object)"Test Album", (Object)metadata.get(XMPDM.ALBUM));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(XMPDM.ARTIST));
        Assertions.assertEquals((Object)"Test Composer", (Object)metadata.get(XMPDM.COMPOSER));
        Assertions.assertEquals((Object)"2008", (Object)metadata.get(XMPDM.RELEASE_DATE));
        Assertions.assertEquals((Object)"Test Genre", (Object)metadata.get(XMPDM.GENRE));
        Assertions.assertEquals((Object)"Test Comments", (Object)metadata.get(XMPDM.LOG_COMMENT.getName()));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(XMPDM.TRACK_NUMBER));
        Assertions.assertEquals((Object)"Test Album Artist", (Object)metadata.get(XMPDM.ALBUM_ARTIST));
        Assertions.assertEquals((Object)"6", (Object)metadata.get(XMPDM.DISC_NUMBER));
        Assertions.assertEquals((Object)"0", (Object)metadata.get(XMPDM.COMPILATION));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get(XMPDM.AUDIO_SAMPLE_RATE));
        Assertions.assertEquals((Object)"Stereo", (Object)metadata.get(XMPDM.AUDIO_CHANNEL_TYPE));
        Assertions.assertEquals((Object)"M4A", (Object)metadata.get(XMPDM.AUDIO_COMPRESSOR));
        Assertions.assertEquals((Object)"0.07", (Object)metadata.get(XMPDM.DURATION));
        Assertions.assertEquals((Object)"iTunes 10.5.3.3", (Object)metadata.get(XMP.CREATOR_TOOL));
        MP4ParserTest.assertContains((Object)"org.apache.tika.parser.mp4.MP4Parser", Arrays.asList(metadata.getValues(TikaCoreProperties.TIKA_PARSED_BY)));
        TikaInputStream tstream = TikaInputStream.get((InputStream)this.getResourceAsStream("/test-documents/testMP4.m4a"));
        tstream.getFile();
        BodyContentHandler handler = new BodyContentHandler();
        try {
            AUTO_DETECT_PARSER.parse((InputStream)tstream, (ContentHandler)handler, metadata, new ParseContext());
        }
        finally {
            tstream.close();
        }
    }

    @Test
    @Timeout(value=30000L)
    public void testInfiniteLoop() throws Exception {
        TikaTest.XMLResult r = this.getXML("testMP4_truncated.m4a");
        Assertions.assertEquals((Object)"audio/mp4", (Object)r.metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"M4A", (Object)r.metadata.get(XMPDM.AUDIO_COMPRESSOR));
    }
}

