/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class Mp3ParserTest
extends TikaTest {
    private static void checkDuration(Metadata metadata, int expected) {
        Assertions.assertEquals((int)expected, (int)Math.round(Float.parseFloat(metadata.get(XMPDM.DURATION))), (String)"wrong duration");
    }

    @Test
    public void testMp3ParsingID3v1() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP3id3v1.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Test Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Mp3ParserTest.assertContains((String)"Test Title", (String)content);
        Mp3ParserTest.assertContains((String)"Test Artist", (String)content);
        Mp3ParserTest.assertContains((String)"Test Album", (String)content);
        Mp3ParserTest.assertContains((String)"2008", (String)content);
        Mp3ParserTest.assertContains((String)"Test Comment", (String)content);
        Mp3ParserTest.assertContains((String)"Rock", (String)content);
        Assertions.assertEquals((Object)"MPEG 3 Layer III Version 1", (Object)metadata.get("version"));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("channels"));
        Mp3ParserTest.checkDuration(metadata, 2);
    }

    @Test
    public void testMp3ParsingID3v2() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP3id3v2.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Test Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Mp3ParserTest.assertContains((String)"Test Title", (String)content);
        Mp3ParserTest.assertContains((String)"Test Artist", (String)content);
        Mp3ParserTest.assertContains((String)"Test Album", (String)content);
        Mp3ParserTest.assertContains((String)"2008", (String)content);
        Mp3ParserTest.assertContains((String)"Test Comment", (String)content);
        Mp3ParserTest.assertContains((String)"Rock", (String)content);
        Mp3ParserTest.assertContains((String)", track 1", (String)content);
        Mp3ParserTest.assertContains((String)", disc 1", (String)content);
        Assertions.assertEquals((Object)"MPEG 3 Layer III Version 1", (Object)metadata.get("version"));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("channels"));
        Assertions.assertEquals((Object)"Test Album", (Object)metadata.get(XMPDM.ALBUM));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(XMPDM.ARTIST));
        Assertions.assertEquals((Object)"Test Album Artist", (Object)metadata.get(XMPDM.ALBUM_ARTIST));
        Assertions.assertEquals(null, (Object)metadata.get(XMPDM.COMPOSER));
        Assertions.assertEquals((Object)"2008", (Object)metadata.get(XMPDM.RELEASE_DATE));
        Assertions.assertEquals((Object)"Rock", (Object)metadata.get(XMPDM.GENRE));
        Assertions.assertEquals((Object)"XXX - ID3v1 Comment\nTest Comment", (Object)metadata.get(XMPDM.LOG_COMMENT.getName()));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(XMPDM.TRACK_NUMBER));
        Assertions.assertEquals((Object)"1/1", (Object)metadata.get(XMPDM.DISC_NUMBER));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(XMPDM.COMPILATION));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get(XMPDM.AUDIO_SAMPLE_RATE));
        Assertions.assertEquals((Object)"Mono", (Object)metadata.get(XMPDM.AUDIO_CHANNEL_TYPE));
        Assertions.assertEquals((Object)"MP3", (Object)metadata.get(XMPDM.AUDIO_COMPRESSOR));
        Mp3ParserTest.checkDuration(metadata, 2);
    }

    @Test
    public void testAddingToMetadataBeforeWriting() throws Exception {
        String content = this.getXML((String)"testMP3id3v1.mp3").xml;
        Mp3ParserTest.assertContains((String)"<meta name=\"xmpDM:audioSampleRate\" content=\"44100\"", (String)content);
        Mp3ParserTest.assertContains((String)"<meta name=\"xmpDM:duration\" content=\"2.455", (String)content);
        Mp3ParserTest.assertContains((String)"meta name=\"xmpDM:audioChannelType\" content=\"Mono\"", (String)content);
    }

    @Test
    public void testMp3ParsingID3v1v2() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP3id3v1_v2.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Test Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Mp3ParserTest.assertContains((String)"Test Title", (String)content);
        Mp3ParserTest.assertContains((String)"Test Artist", (String)content);
        Mp3ParserTest.assertContains((String)"Test Album", (String)content);
        Mp3ParserTest.assertContains((String)"2008", (String)content);
        Mp3ParserTest.assertContains((String)"Test Comment", (String)content);
        Mp3ParserTest.assertContains((String)"Rock", (String)content);
        Assertions.assertEquals((Object)"MPEG 3 Layer III Version 1", (Object)metadata.get("version"));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("channels"));
        Mp3ParserTest.checkDuration(metadata, 2);
    }

    @Test
    public void testMp3ParsingID3v24() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP3id3v24.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Test Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Mp3ParserTest.assertContains((String)"Test Title", (String)content);
        Mp3ParserTest.assertContains((String)"Test Artist", (String)content);
        Mp3ParserTest.assertContains((String)"Test Album", (String)content);
        Mp3ParserTest.assertContains((String)"2008", (String)content);
        Mp3ParserTest.assertContains((String)"Test Comment", (String)content);
        Mp3ParserTest.assertContains((String)"Rock", (String)content);
        Mp3ParserTest.assertContains((String)", disc 1", (String)content);
        Assertions.assertEquals((Object)"MPEG 3 Layer III Version 1", (Object)metadata.get("version"));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("channels"));
        Mp3ParserTest.checkDuration(metadata, 2);
        Assertions.assertEquals((Object)"Test Album", (Object)metadata.get(XMPDM.ALBUM));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(XMPDM.ARTIST));
        Assertions.assertEquals((Object)"Test Album Artist", (Object)metadata.get(XMPDM.ALBUM_ARTIST));
        Assertions.assertEquals(null, (Object)metadata.get(XMPDM.COMPOSER));
        Assertions.assertEquals((Object)"2008", (Object)metadata.get(XMPDM.RELEASE_DATE));
        Assertions.assertEquals((Object)"Rock", (Object)metadata.get(XMPDM.GENRE));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(XMPDM.COMPILATION));
        Assertions.assertEquals(null, (Object)metadata.get(XMPDM.TRACK_NUMBER));
        Assertions.assertEquals((Object)"1", (Object)metadata.get(XMPDM.DISC_NUMBER));
    }

    @Test
    public void testMp3ParsingID3i18n() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP3i18n.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Une chason en Fran\u00e7ais", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Test Artist \u2468\u2460", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Test Artist \u2468\u2460", (Object)metadata.get(XMPDM.ARTIST));
        Assertions.assertEquals((Object)"Test Album \u2460\u2468", (Object)metadata.get(XMPDM.ALBUM));
        Assertions.assertEquals((Object)"Eng - Comment Desc\nThis is a \u1357\u2468\u2460 Comment", (Object)metadata.get(XMPDM.LOG_COMMENT));
        Assertions.assertEquals((Object)"MPEG 3 Layer III Version 1", (Object)metadata.get("version"));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("channels"));
        Mp3ParserTest.checkDuration(metadata, 2);
    }

    @Test
    public void testMp3ParsingID3i18nTruncated() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP3i18n_truncated.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Une chason en Fran\u00e7ais", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Test Artist \u2468\u2460", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Test Artist \u2468\u2460", (Object)metadata.get(XMPDM.ARTIST));
        Assertions.assertEquals((Object)"Test Album \u2460\u2468", (Object)metadata.get(XMPDM.ALBUM));
        Assertions.assertEquals((Object)"Eng - Comment Desc\nThis is a \u1357\u2468\u2460 Comment", (Object)metadata.get(XMPDM.LOG_COMMENT));
        Assertions.assertEquals((Object)"MPEG 3 Layer III Version 1", (Object)metadata.get("version"));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"1", (Object)metadata.get("channels"));
        Mp3ParserTest.checkDuration(metadata, 2);
    }

    @Test
    public void testMp3ParsingLyrics() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP3lyrics.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Test Title", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Test Artist", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Mp3ParserTest.assertContains((String)"Test Title", (String)content);
        Mp3ParserTest.assertContains((String)"Test Artist", (String)content);
        Mp3ParserTest.assertContains((String)"Test Album", (String)content);
        Mp3ParserTest.assertContains((String)"2008", (String)content);
        Mp3ParserTest.assertContains((String)"Test Comment", (String)content);
        Mp3ParserTest.assertContains((String)"Rock", (String)content);
        Assertions.assertEquals((Object)"MPEG 3 Layer III Version 1", (Object)metadata.get("version"));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"2", (Object)metadata.get("channels"));
        Mp3ParserTest.checkDuration(metadata, 1);
    }

    @Test
    public void testID3v2Frame() throws Exception {
        byte[] empty = new byte[]{73, 68, 51, 3, 1, 0, 0, 0, 0, 0};
        Assertions.assertEquals((int)11, (int)ID3v2Frame.getInt((byte[])new byte[]{0, 0, 0, 11}));
        Assertions.assertEquals((int)257, (int)ID3v2Frame.getInt((byte[])new byte[]{0, 0, 1, 1}));
        ID3v2Frame f = (ID3v2Frame)ID3v2Frame.createFrameIfPresent((InputStream)new ByteArrayInputStream(empty));
        Assertions.assertEquals((int)3, (int)f.getMajorVersion());
        Assertions.assertEquals((int)1, (int)f.getMinorVersion());
        Assertions.assertEquals((int)0, (int)f.getFlags());
        Assertions.assertEquals((int)0, (int)f.getLength());
        Assertions.assertEquals((int)0, (int)f.getData().length);
        Assertions.assertEquals((Object)"", (Object)ID3v2Frame.getTagString((byte[])f.getData(), (int)0, (int)0));
        Assertions.assertEquals((Object)"", (Object)ID3v2Frame.getTagString((byte[])new byte[]{0, 0, 0, 0}, (int)0, (int)3));
        Assertions.assertEquals((Object)"A", (Object)ID3v2Frame.getTagString((byte[])new byte[]{65, 0, 0, 0}, (int)0, (int)3));
    }

    @Test
    public void testTIKA1589_noId3ReturnsDurationCorrectly() throws Exception {
        Assertions.assertEquals((Object)"2.4555110931396484", (Object)this.getXML((String)"testMP3noid3.mp3").metadata.get(XMPDM.DURATION));
    }

    @Test
    public void testTIKA424() throws Exception {
        Assumptions.assumeTrue((Mp3ParserTest.class.getResourceAsStream("/test-documents/test2.mp3") != null ? 1 : 0) != 0);
        Metadata metadata = new Metadata();
        String content = this.getText("test2.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Plus loin vers l'ouest", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Merzhin", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Mp3ParserTest.assertContains((String)"Plus loin vers l'ouest", (String)content);
        Assertions.assertEquals((Object)"MPEG 3 Layer III Version 1", (Object)metadata.get("version"));
        Assertions.assertEquals((Object)"44100", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"2", (Object)metadata.get("channels"));
    }

    @Test
    public void testTIKA474() throws Exception {
        Metadata metadata = new Metadata();
        String content = this.getText("testMP3truncated.mp3", metadata);
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"Girl you have no faith in medicine", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"The White Stripes", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Mp3ParserTest.assertContains((String)"Girl you have no faith in medicine", (String)content);
        Mp3ParserTest.assertContains((String)"The White Stripes", (String)content);
        Mp3ParserTest.assertContains((String)"Elephant", (String)content);
        Mp3ParserTest.assertContains((String)"2003", (String)content);
        Assertions.assertEquals(null, (Object)metadata.get("version"));
        Assertions.assertEquals(null, (Object)metadata.get("samplerate"));
        Assertions.assertEquals(null, (Object)metadata.get("channels"));
    }

    @Test
    public void testNakedUTF16BOM() throws Exception {
        Metadata metadata = this.getXML((String)"testNakedUTF16BOM.mp3").metadata;
        Assertions.assertEquals((Object)"audio/mpeg", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"", (Object)metadata.get(XMPDM.GENRE));
    }
}

