/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.audio;

import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AudioParserTest {
    @Test
    public void testWAV() throws Exception {
        String path = "/test-documents/testWAV.wav";
        Metadata metadata = new Metadata();
        String content = new Tika().parseToString(AudioParserTest.class.getResourceAsStream(path), metadata);
        Assertions.assertEquals((Object)"audio/vnd.wave", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"44100.0", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"2", (Object)metadata.get("channels"));
        Assertions.assertEquals((Object)"16", (Object)metadata.get("bits"));
        Assertions.assertEquals((Object)"PCM_SIGNED", (Object)metadata.get("encoding"));
        Assertions.assertEquals((Object)"", (Object)content);
    }

    @Test
    public void testAIFF() throws Exception {
        String path = "/test-documents/testAIFF.aif";
        Metadata metadata = new Metadata();
        String content = new Tika().parseToString(AudioParserTest.class.getResourceAsStream(path), metadata);
        Assertions.assertEquals((Object)"audio/x-aiff", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"44100.0", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"2", (Object)metadata.get("channels"));
        Assertions.assertEquals((Object)"16", (Object)metadata.get("bits"));
        Assertions.assertEquals((Object)"PCM_SIGNED", (Object)metadata.get("encoding"));
        Assertions.assertEquals((Object)"", (Object)content);
    }

    @Test
    public void testAU() throws Exception {
        String path = "/test-documents/testAU.au";
        Metadata metadata = new Metadata();
        String content = new Tika().parseToString(AudioParserTest.class.getResourceAsStream(path), metadata);
        Assertions.assertEquals((Object)"audio/basic", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"44100.0", (Object)metadata.get("samplerate"));
        Assertions.assertEquals((Object)"2", (Object)metadata.get("channels"));
        Assertions.assertEquals((Object)"16", (Object)metadata.get("bits"));
        Assertions.assertEquals((Object)"PCM_SIGNED", (Object)metadata.get("encoding"));
        Assertions.assertEquals((Object)"", (Object)content);
    }
}

