/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.tika.parser.mp3.AudioFrame;
import org.apache.tika.parser.mp3.MpegStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MpegStreamTest {
    private MpegStream stream;

    private static void writeBytes(OutputStream out, int value, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            out.write(value);
        }
    }

    private static void writeFrame(OutputStream out, int b2, int b3, int b4) throws IOException {
        out.write(255);
        out.write(b2);
        out.write(b3);
        out.write(b4);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    private void checkDefaultHeader(ByteArrayOutputStream bos) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
        this.stream = new MpegStream((InputStream)in);
        AudioFrame header = this.stream.nextFrame();
        Assertions.assertNotNull((Object)header, (String)"No header found");
        Assertions.assertEquals((int)2, (int)header.getVersionCode(), (String)"Wrong MPEG version");
        Assertions.assertEquals((int)1, (int)header.getLayer(), (String)"Wrong layer");
        Assertions.assertEquals((int)80000, (int)header.getBitRate(), (String)"Wrong bit rate");
        Assertions.assertEquals((int)24000, (int)header.getSampleRate(), (String)"Wrong sample rate");
    }

    @Test
    public void testSearchNextFrame() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MpegStreamTest.writeBytes(bos, 255, 32);
        MpegStreamTest.writeBytes(bos, 0, 16);
        MpegStreamTest.writeBytes(bos, 255, 8);
        bos.write(243);
        bos.write(150);
        bos.write(0);
        this.checkDefaultHeader(bos);
    }

    @Test
    public void testSearchNextFrameInvalid() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        MpegStreamTest.writeFrame(bos, 235, 150, 0);
        MpegStreamTest.writeFrame(bos, 249, 150, 0);
        MpegStreamTest.writeFrame(bos, 243, 0, 0);
        MpegStreamTest.writeFrame(bos, 243, 240, 0);
        MpegStreamTest.writeFrame(bos, 243, 124, 0);
        MpegStreamTest.writeFrame(bos, 243, 150, 0);
        this.checkDefaultHeader(bos);
    }

    @Test
    public void testSeachNextFrameEOS() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(255);
        bos.write(255);
        bos.write(243);
        bos.write(150);
        ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
        this.stream = new MpegStream((InputStream)in);
        Assertions.assertNull((Object)this.stream.nextFrame(), (String)"Got a frame");
    }

    @Test
    public void testSkipNoCurrentHeader() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write("This is a test".getBytes(StandardCharsets.UTF_8));
        ByteArrayInputStream in = new ByteArrayInputStream(bos.toByteArray());
        this.stream = new MpegStream((InputStream)in);
        Assertions.assertFalse((boolean)this.stream.skipFrame(), (String)"Wrong result");
    }
}

