/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.langdetect.opennlp.metadatafilter;

import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaException;
import org.apache.tika.langdetect.opennlp.OpenNLPDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.filter.MetadataFilter;

public class OpenNLPMetadataFilter
extends MetadataFilter {
    private int maxCharsForDetection = 10000;

    @Field
    public void setMaxCharsForDetection(int maxCharsForDetection) {
        this.maxCharsForDetection = maxCharsForDetection;
    }

    public void filter(Metadata metadata) throws TikaException {
        OpenNLPDetector detector = new OpenNLPDetector();
        detector.setMaxLength(this.maxCharsForDetection);
        String content = metadata.get(TikaCoreProperties.TIKA_CONTENT);
        if (content == null) {
            return;
        }
        LanguageResult r = detector.detect(content);
        metadata.set(TikaCoreProperties.TIKA_DETECTED_LANGUAGE, r.getLanguage());
        metadata.set(TikaCoreProperties.TIKA_DETECTED_LANGUAGE_CONFIDENCE, r.getConfidence().name());
        metadata.set(TikaCoreProperties.TIKA_DETECTED_LANGUAGE_CONFIDENCE_RAW, (double)r.getRawScore());
    }
}

