/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.fetcher.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.FileTooLongException;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.fetcher.AbstractFetcher;
import org.apache.tika.pipes.fetcher.RangeFetcher;
import org.apache.tika.pipes.fetcher.s3.config.S3FetcherConfig;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Fetcher
extends AbstractFetcher
implements Initializable,
RangeFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Fetcher.class);
    private static final String PREFIX = "s3";
    private static final Set<String> NO_RETRY_ERROR_CODES = new HashSet<String>();
    private final Object[] clientLock = new Object[0];
    private String region;
    private String bucket;
    private String profile;
    private String accessKey;
    private String secretKey;
    private String endpointConfigurationService;
    private String prefix;
    private String credentialsProvider;
    private boolean extractUserMetadata = true;
    private int maxConnections = 50;
    private AmazonS3 s3Client;
    private boolean spoolToTemp = true;
    private int retries = 0;
    private long sleepBeforeRetryMillis = 30000L;
    private long[] throttleSeconds = null;
    private long maxLength = -1L;
    private boolean pathStyleAccessEnabled = false;

    public S3Fetcher() {
    }

    public S3Fetcher(S3FetcherConfig s3FetcherConfig) {
        this.setBucket(s3FetcherConfig.getBucket());
        this.setRegion(s3FetcherConfig.getRegion());
        this.setProfile(s3FetcherConfig.getProfile());
        this.setAccessKey(s3FetcherConfig.getAccessKey());
        this.setSecretKey(s3FetcherConfig.getSecretKey());
        this.setPrefix(s3FetcherConfig.getPrefix());
        this.setCredentialsProvider(s3FetcherConfig.getCredentialsProvider());
        this.setEndpointConfigurationService(s3FetcherConfig.getEndpointConfigurationService());
        this.setMaxConnections(s3FetcherConfig.getMaxConnections());
        this.setSpoolToTemp(s3FetcherConfig.isSpoolToTemp());
        this.setThrottleSeconds(s3FetcherConfig.getThrottleSeconds());
        this.setMaxLength(s3FetcherConfig.getMaxLength());
        this.setExtractUserMetadata(s3FetcherConfig.isExtractUserMetadata());
        this.setPathStyleAccessEnabled(s3FetcherConfig.isPathStyleAccessEnabled());
    }

    public InputStream fetch(String fetchKey, Metadata metadata, ParseContext parseContext) throws TikaException, IOException {
        return this.fetch(fetchKey, -1L, -1L, metadata);
    }

    public InputStream fetch(String fetchKey, long startRange, long endRange, Metadata metadata, ParseContext parseContext) throws TikaException, IOException {
        String theFetchKey;
        String string = theFetchKey = StringUtils.isBlank((String)this.prefix) ? fetchKey : this.prefix + fetchKey;
        if (LOGGER.isDebugEnabled()) {
            if (startRange > -1L) {
                LOGGER.debug("about to fetch fetchkey={} (start={} end={}) from bucket ({})", new Object[]{theFetchKey, startRange, endRange, this.bucket});
            } else {
                LOGGER.debug("about to fetch fetchkey={} from bucket ({})", (Object)theFetchKey, (Object)this.bucket);
            }
        }
        int tries = 0;
        IOException ex = null;
        do {
            try {
                long start = System.currentTimeMillis();
                InputStream is = this._fetch(theFetchKey, metadata, startRange, endRange);
                long elapsed = System.currentTimeMillis() - start;
                LOGGER.debug("total to fetch {}", (Object)elapsed);
                return is;
            }
            catch (AmazonS3Exception e) {
                if (e.getErrorCode() != null && NO_RETRY_ERROR_CODES.contains(e.getErrorCode())) {
                    LOGGER.warn("Hit a no retry error code. Not retrying." + tries, (Throwable)e);
                    throw new IOException(e);
                }
                LOGGER.warn("client exception fetching on retry=" + tries, (Throwable)e);
                ex = new IOException(e);
            }
            catch (AmazonClientException e) {
                LOGGER.warn("client exception fetching on retry=" + tries, (Throwable)e);
                ex = new IOException(e);
            }
            catch (IOException e) {
                LOGGER.warn("client exception fetching on retry=" + tries, (Throwable)e);
                ex = e;
            }
            LOGGER.warn("sleeping for {} seconds before retry", (Object)this.throttleSeconds[tries]);
            try {
                Thread.sleep(this.throttleSeconds[tries]);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("interrupted");
            }
            LOGGER.debug("trying to re-initialize S3 client");
            this.initialize(new HashMap<String, Param>());
        } while (++tries < this.throttleSeconds.length);
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream _fetch(String fetchKey, Metadata metadata, Long startRange, Long endRange) throws IOException {
        TemporaryResources tmp = null;
        try {
            long start = System.currentTimeMillis();
            GetObjectRequest objectRequest = new GetObjectRequest(this.bucket, fetchKey);
            if (startRange != null && endRange != null && startRange > -1L && endRange > -1L) {
                objectRequest.withRange(startRange, endRange);
            }
            S3Object s3Object = null;
            Object[] objectArray = this.clientLock;
            synchronized (this.clientLock) {
                s3Object = this.s3Client.getObject(objectRequest);
                // ** MonitorExit[var10_10] (shouldn't be in output)
                long length = s3Object.getObjectMetadata().getContentLength();
                metadata.set("Content-Length", Long.toString(length));
                if (this.maxLength > -1L && length > this.maxLength) {
                    throw new FileTooLongException(length, this.maxLength);
                }
                LOGGER.debug("took {} ms to fetch file's metadata", (Object)(System.currentTimeMillis() - start));
                if (this.extractUserMetadata) {
                    for (Map.Entry<String, String> e : s3Object.getObjectMetadata().getUserMetadata().entrySet()) {
                        metadata.add("s3:" + e.getKey(), e.getValue());
                    }
                }
                if (!this.spoolToTemp) {
                    return TikaInputStream.get((InputStream)s3Object.getObjectContent());
                }
                start = System.currentTimeMillis();
                tmp = new TemporaryResources();
                Path tmpPath = tmp.createTempFile(FilenameUtils.getSuffixFromPath((String)fetchKey));
                Files.copy(s3Object.getObjectContent(), tmpPath, StandardCopyOption.REPLACE_EXISTING);
                TikaInputStream tis = TikaInputStream.get((Path)tmpPath, (Metadata)metadata, (TemporaryResources)tmp);
                LOGGER.debug("took {} ms to fetch metadata and copy to local tmp file", (Object)(System.currentTimeMillis() - start));
                return tis;
            }
        }
        catch (Throwable e) {
            if (tmp != null) {
                tmp.close();
            }
            throw e;
        }
    }

    @Field
    public void setSpoolToTemp(boolean spoolToTemp) {
        this.spoolToTemp = spoolToTemp;
    }

    @Field
    public void setRegion(String region) {
        this.region = region;
    }

    @Field
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Field
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Field
    public void setThrottleSeconds(String commaDelimitedLongs) throws TikaConfigException {
        String[] longStrings = commaDelimitedLongs.split(",");
        long[] seconds = new long[longStrings.length];
        for (int i = 0; i < longStrings.length; ++i) {
            try {
                seconds[i] = Long.parseLong(longStrings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new TikaConfigException(e.getMessage());
            }
        }
        this.setThrottleSeconds(seconds);
    }

    public void setThrottleSeconds(long[] throttleSeconds) {
        this.throttleSeconds = throttleSeconds;
    }

    public long[] getThrottleSeconds() {
        return this.throttleSeconds;
    }

    @Field
    public void setPrefix(String prefix) {
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.prefix = prefix;
    }

    @Field
    public void setExtractUserMetadata(boolean extractUserMetadata) {
        this.extractUserMetadata = extractUserMetadata;
    }

    @Field
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Field
    public void setCredentialsProvider(String credentialsProvider) {
        if (!(credentialsProvider.equals("profile") || credentialsProvider.equals("instance") || credentialsProvider.equals("key_secret"))) {
            throw new IllegalArgumentException("credentialsProvider must be either 'profile', 'instance' or 'key_secret'");
        }
        this.credentialsProvider = credentialsProvider;
    }

    @Field
    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    @Deprecated
    @Field
    public void setSleepBeforeRetryMillis(long sleepBeforeRetryMillis) {
        LOGGER.info("sleepBeforeRetryMillis is deprecated. Use setThrottleSeconds instead");
        this.sleepBeforeRetryMillis = sleepBeforeRetryMillis;
    }

    @Field
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Field
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        AWSCredentialsProvider provider;
        if (this.credentialsProvider.equals("instance")) {
            provider = InstanceProfileCredentialsProvider.getInstance();
        } else if (this.credentialsProvider.equals("profile")) {
            provider = new ProfileCredentialsProvider(this.profile);
        } else if (this.credentialsProvider.equals("key_secret")) {
            provider = new AWSStaticCredentialsProvider(new BasicAWSCredentials(this.accessKey, this.secretKey));
        } else {
            throw new TikaConfigException("credentialsProvider must be set and must be either 'instance', 'profile' or 'key_secret'");
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration().withMaxConnections(this.maxConnections);
        try {
            Object[] objectArray = this.clientLock;
            synchronized (this.clientLock) {
                AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(clientConfiguration)).withPathStyleAccessEnabled(this.pathStyleAccessEnabled)).withCredentials(provider);
                if (!StringUtils.isBlank((String)this.endpointConfigurationService)) {
                    amazonS3ClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointConfigurationService, this.region));
                } else {
                    amazonS3ClientBuilder.withRegion(this.region);
                }
                this.s3Client = (AmazonS3)amazonS3ClientBuilder.build();
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (AmazonClientException e) {
            throw new TikaConfigException("can't initialize s3 fetcher", (Throwable)e);
        }
        {
            if (this.throttleSeconds == null) {
                this.throttleSeconds = new long[this.retries];
                for (int i = 0; i < this.retries; ++i) {
                    this.throttleSeconds[i] = this.sleepBeforeRetryMillis * 1000L;
                }
            }
            return;
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"bucket", (String)this.bucket);
        TikaConfig.mustNotBeEmpty((String)"region", (String)this.region);
    }

    @Field
    public void setEndpointConfigurationService(String endpointConfigurationService) {
        this.endpointConfigurationService = endpointConfigurationService;
    }

    @Field
    public void setPathStyleAccessEnabled(boolean pathStyleAccessEnabled) {
        this.pathStyleAccessEnabled = pathStyleAccessEnabled;
    }

    static {
        NO_RETRY_ERROR_CODES.add("AccessDenied");
        NO_RETRY_ERROR_CODES.add("NoSuchKey");
        NO_RETRY_ERROR_CODES.add("ExpiredToken");
        NO_RETRY_ERROR_CODES.add("InvalidAccessKeyId");
        NO_RETRY_ERROR_CODES.add("InvalidRange");
        NO_RETRY_ERROR_CODES.add("InvalidRequest");
    }
}

