/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.fetcher.s3;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.fetcher.Fetcher;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.apache.tika.pipes.fetcher.s3.S3Fetcher;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="write actual unit tests")
public class TestS3Fetcher {
    private static final String FETCH_STRING = "";
    private final Path outputFile = Paths.get("", new String[0]);
    private final String region = "us-east-1";
    private final String profile = "";

    @Test
    public void testBasic() throws Exception {
        S3Fetcher fetcher = new S3Fetcher();
        fetcher.setProfile(FETCH_STRING);
        fetcher.setRegion("us-east-1");
        fetcher.initialize(Collections.EMPTY_MAP);
        Metadata metadata = new Metadata();
        try (InputStream is = fetcher.fetch(FETCH_STRING, metadata, new ParseContext());){
            Files.copy(is, this.outputFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Test
    public void testConfig() throws Exception {
        FetcherManager fetcherManager = FetcherManager.load((Path)Paths.get(this.getClass().getResource("/tika-config-s3.xml").toURI()));
        Fetcher fetcher = fetcherManager.getFetcher("s3");
        Metadata metadata = new Metadata();
        try (InputStream is = fetcher.fetch(FETCH_STRING, metadata, new ParseContext());){
            Files.copy(is, this.outputFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

