/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.fetcher.gcs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.fetcher.AbstractFetcher;
import org.apache.tika.pipes.fetcher.gcs.config.GCSFetcherConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSFetcher
extends AbstractFetcher
implements Initializable {
    private static String PREFIX = "gcs";
    private static final Logger LOGGER = LoggerFactory.getLogger(GCSFetcher.class);
    private String projectId;
    private String bucket;
    private boolean extractUserMetadata = true;
    private Storage storage;
    private boolean spoolToTemp = true;

    public GCSFetcher() {
    }

    public GCSFetcher(GCSFetcherConfig gcsFetcherConfig) {
        this.setBucket(gcsFetcherConfig.getBucket());
        this.setProjectId(gcsFetcherConfig.getProjectId());
        this.setSpoolToTemp(gcsFetcherConfig.isSpoolToTemp());
        this.setExtractUserMetadata(gcsFetcherConfig.isExtractUserMetadata());
    }

    public InputStream fetch(String fetchKey, Metadata metadata, ParseContext parseContext) throws TikaException, IOException {
        LOGGER.debug("about to fetch fetchkey={} from bucket ({})", (Object)fetchKey, (Object)this.bucket);
        try {
            Blob blob = this.storage.get(BlobId.of(this.bucket, fetchKey));
            if (this.extractUserMetadata && blob.getMetadata() != null) {
                for (Map.Entry<String, String> e : blob.getMetadata().entrySet()) {
                    metadata.add(PREFIX + ":" + e.getKey(), e.getValue());
                }
            }
            if (!this.spoolToTemp) {
                return TikaInputStream.get((byte[])blob.getContent(new Blob.BlobSourceOption[0]));
            }
            long start = System.currentTimeMillis();
            TemporaryResources tmpResources = new TemporaryResources();
            Path tmp = tmpResources.createTempFile();
            blob.downloadTo(tmp);
            TikaInputStream tis = TikaInputStream.get((Path)tmp, (Metadata)metadata, (TemporaryResources)tmpResources);
            long elapsed = System.currentTimeMillis() - start;
            LOGGER.debug("took {} ms to copy to local tmp file", (Object)elapsed);
            return tis;
        }
        catch (Exception e) {
            throw new IOException("gcs storage exception", e);
        }
    }

    @Field
    public void setSpoolToTemp(boolean spoolToTemp) {
        this.spoolToTemp = spoolToTemp;
    }

    @Field
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Field
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Field
    public void setExtractUserMetadata(boolean extractUserMetadata) {
        this.extractUserMetadata = extractUserMetadata;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).build().getService();
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"bucket", (String)this.bucket);
        TikaConfig.mustNotBeEmpty((String)"projectId", (String)this.projectId);
    }
}

