/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.fetcher.s3;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.fetcher.Fetcher;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@Disabled(value="write actual unit tests")
public class TestGCSFetcher {
    private static final String FETCH_STRING = "testExtraSpaces.pdf";
    @TempDir
    private static Path TEMP_DIR;
    private static Path outputFile;

    @BeforeAll
    public static void setUp() throws Exception {
        outputFile = Files.createTempFile(TEMP_DIR, "tika-test", ".pdf", new FileAttribute[0]);
    }

    @Test
    public void testConfig() throws Exception {
        FetcherManager fetcherManager = FetcherManager.load((Path)Paths.get(this.getClass().getResource("/tika-config-gcs.xml").toURI()));
        Fetcher fetcher = fetcherManager.getFetcher("gcs");
        Metadata metadata = new Metadata();
        try (InputStream is = fetcher.fetch(FETCH_STRING, metadata, new ParseContext());){
            Files.copy(is, outputFile, StandardCopyOption.REPLACE_EXISTING);
        }
        Assertions.assertEquals((long)20743L, (long)Files.size(outputFile));
    }
}

