/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.solr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.tika.client.HttpClientFactory;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.emitter.AbstractEmitter;
import org.apache.tika.pipes.emitter.EmitData;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrEmitter
extends AbstractEmitter
implements Initializable {
    public static String DEFAULT_EMBEDDED_FILE_FIELD_NAME = "embedded";
    private static final Logger LOG = LoggerFactory.getLogger(SolrEmitter.class);
    private final HttpClientFactory httpClientFactory;
    private AttachmentStrategy attachmentStrategy = AttachmentStrategy.PARENT_CHILD;
    private UpdateStrategy updateStrategy = UpdateStrategy.ADD;
    private String solrCollection;
    private List<String> solrUrls;
    private List<String> solrZkHosts;
    private String solrZkChroot;
    private String idField = "id";
    private int commitWithin = 1000;
    private int connectionTimeout = 10000;
    private int socketTimeout = 60000;
    private SolrClient solrClient;
    private String embeddedFileFieldName = DEFAULT_EMBEDDED_FILE_FIELD_NAME;

    public SolrEmitter() throws TikaConfigException {
        this.httpClientFactory = new HttpClientFactory();
    }

    public void emit(String emitKey, List<Metadata> metadataList, ParseContext parseContext) throws IOException, TikaEmitterException {
        if (metadataList == null || metadataList.size() == 0) {
            LOG.warn("metadataList is null or empty");
            return;
        }
        ArrayList<SolrInputDocument> docsToUpdate = new ArrayList<SolrInputDocument>();
        this.addMetadataAsSolrInputDocuments(emitKey, metadataList, docsToUpdate);
        this.emitSolrBatch(docsToUpdate);
    }

    private void addMetadataAsSolrInputDocuments(String emitKey, List<Metadata> metadataList, List<SolrInputDocument> docsToUpdate) throws IOException, TikaEmitterException {
        SolrInputDocument solrInputDocument = new SolrInputDocument(new String[0]);
        solrInputDocument.setField(this.idField, emitKey);
        if (this.updateStrategy == UpdateStrategy.UPDATE_MUST_EXIST) {
            solrInputDocument.setField("_version_", 1);
        } else if (this.updateStrategy == UpdateStrategy.UPDATE_MUST_NOT_EXIST) {
            solrInputDocument.setField("_version_", -1);
        }
        if (metadataList.size() == 1) {
            this.addMetadataToSolrInputDocument(metadataList.get(0), solrInputDocument, this.updateStrategy);
            docsToUpdate.add(solrInputDocument);
        } else if (this.attachmentStrategy == AttachmentStrategy.PARENT_CHILD) {
            this.addMetadataToSolrInputDocument(metadataList.get(0), solrInputDocument, this.updateStrategy);
            ArrayList<SolrInputDocument> children = new ArrayList<SolrInputDocument>();
            for (int i = 1; i < metadataList.size(); ++i) {
                SolrInputDocument childSolrInputDocument = new SolrInputDocument(new String[0]);
                Metadata m = metadataList.get(i);
                childSolrInputDocument.setField(this.idField, emitKey + "-" + UUID.randomUUID().toString());
                this.addMetadataToSolrInputDocument(m, childSolrInputDocument, this.updateStrategy);
                children.add(childSolrInputDocument);
            }
            solrInputDocument.setField(this.embeddedFileFieldName, children);
            docsToUpdate.add(solrInputDocument);
        } else if (this.attachmentStrategy == AttachmentStrategy.SEPARATE_DOCUMENTS) {
            this.addMetadataToSolrInputDocument(metadataList.get(0), solrInputDocument, this.updateStrategy);
            docsToUpdate.add(solrInputDocument);
            for (int i = 1; i < metadataList.size(); ++i) {
                SolrInputDocument childSolrInputDocument = new SolrInputDocument(new String[0]);
                Metadata m = metadataList.get(i);
                childSolrInputDocument.setField(this.idField, solrInputDocument.get(this.idField).getValue() + "-" + UUID.randomUUID().toString());
                this.addMetadataToSolrInputDocument(m, childSolrInputDocument, this.updateStrategy);
                docsToUpdate.add(childSolrInputDocument);
            }
        } else {
            throw new IllegalArgumentException("I don't yet support this attachment strategy: " + this.attachmentStrategy);
        }
    }

    public void emit(List<? extends EmitData> batch) throws IOException, TikaEmitterException {
        if (batch == null || batch.size() == 0) {
            LOG.warn("batch is null or empty");
            return;
        }
        ArrayList<SolrInputDocument> docsToUpdate = new ArrayList<SolrInputDocument>();
        for (EmitData emitData : batch) {
            this.addMetadataAsSolrInputDocuments(emitData.getEmitKey().getEmitKey(), emitData.getMetadataList(), docsToUpdate);
        }
        this.emitSolrBatch(docsToUpdate);
    }

    private void emitSolrBatch(List<SolrInputDocument> docsToUpdate) throws IOException, TikaEmitterException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Emitting solr doc batch: {}", (Object)docsToUpdate);
        }
        if (!docsToUpdate.isEmpty()) {
            try {
                UpdateRequest req = new UpdateRequest();
                req.add(docsToUpdate);
                req.setCommitWithin(this.commitWithin);
                req.setParam("failOnVersionConflicts", "false");
                UpdateResponse updateResponse = (UpdateResponse)req.process(this.solrClient, this.solrCollection);
                LOG.debug("update response: " + updateResponse);
                if (updateResponse.getStatus() != 0) {
                    throw new TikaEmitterException("Bad status: " + updateResponse);
                }
            }
            catch (Exception e) {
                throw new TikaEmitterException("Could not add batch to solr", (Throwable)e);
            }
        }
    }

    private void addMetadataToSolrInputDocument(Metadata metadata, SolrInputDocument solrInputDocument, UpdateStrategy updateStrategy) {
        for (String n : metadata.names()) {
            final String[] vals = metadata.getValues(n);
            if (vals.length == 0) continue;
            if (vals.length == 1) {
                if (updateStrategy == UpdateStrategy.ADD) {
                    solrInputDocument.setField(n, vals[0]);
                    continue;
                }
                solrInputDocument.setField(n, new HashMap<String, String>(){
                    {
                        this.put("set", vals[0]);
                    }
                });
                continue;
            }
            if (vals.length <= 1) continue;
            if (updateStrategy == UpdateStrategy.ADD) {
                solrInputDocument.setField(n, vals);
                continue;
            }
            solrInputDocument.setField(n, new HashMap<String, String[]>(){
                {
                    this.put("set", vals);
                }
            });
        }
    }

    @Field
    public void setAttachmentStrategy(String attachmentStrategy) {
        this.attachmentStrategy = AttachmentStrategy.valueOf(attachmentStrategy);
    }

    @Field
    public void setUpdateStrategy(String updateStrategy) {
        this.updateStrategy = UpdateStrategy.valueOf(updateStrategy);
    }

    @Field
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Field
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getCommitWithin() {
        return this.commitWithin;
    }

    @Field
    public void setCommitWithin(int commitWithin) {
        this.commitWithin = commitWithin;
    }

    @Field
    public void setIdField(String idField) {
        this.idField = idField;
    }

    @Field
    public void setSolrCollection(String solrCollection) {
        this.solrCollection = solrCollection;
    }

    @Field
    public void setSolrUrls(List<String> solrUrls) {
        this.solrUrls = solrUrls;
    }

    @Field
    public void setSolrZkHosts(List<String> solrZkHosts) {
        this.solrZkHosts = solrZkHosts;
    }

    @Field
    public void setSolrZkChroot(String solrZkChroot) {
        this.solrZkChroot = solrZkChroot;
    }

    @Field
    public void setUserName(String userName) {
        this.httpClientFactory.setUserName(userName);
    }

    @Field
    public void setPassword(String password) {
        this.httpClientFactory.setPassword(password);
    }

    @Field
    public void setAuthScheme(String authScheme) {
        this.httpClientFactory.setAuthScheme(authScheme);
    }

    @Field
    public void setProxyHost(String proxyHost) {
        this.httpClientFactory.setProxyHost(proxyHost);
    }

    @Field
    public void setProxyPort(int proxyPort) {
        this.httpClientFactory.setProxyPort(proxyPort);
    }

    @Field
    public void setEmbeddedFileFieldName(String embeddedFileFieldName) {
        this.embeddedFileFieldName = embeddedFileFieldName;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.solrClient = this.solrUrls == null || this.solrUrls.isEmpty() ? ((CloudSolrClient.Builder)((CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(this.solrZkHosts, Optional.ofNullable(this.solrZkChroot)).withConnectionTimeout(this.connectionTimeout)).withSocketTimeout(this.socketTimeout)).withHttpClient(this.httpClientFactory.build())).build() : ((LBHttpSolrClient.Builder)((LBHttpSolrClient.Builder)((LBHttpSolrClient.Builder)new LBHttpSolrClient.Builder().withConnectionTimeout(this.connectionTimeout)).withSocketTimeout(this.socketTimeout)).withHttpClient(this.httpClientFactory.build())).withBaseSolrUrls(this.solrUrls.toArray(new String[0])).build();
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"solrCollection", (String)this.solrCollection);
        TikaConfig.mustNotBeEmpty((String)"urlFieldName", (String)this.idField);
        if ((this.solrUrls == null || this.solrUrls.isEmpty()) && (this.solrZkHosts == null || this.solrZkHosts.isEmpty())) {
            throw new IllegalArgumentException("expected either param solrUrls or param solrZkHosts, but neither was specified");
        }
        if (this.solrUrls != null && !this.solrUrls.isEmpty() && this.solrZkHosts != null && !this.solrZkHosts.isEmpty()) {
            throw new IllegalArgumentException("expected either param solrUrls or param solrZkHosts, but both were specified");
        }
    }

    public static enum UpdateStrategy {
        ADD,
        UPDATE_MUST_EXIST,
        UPDATE_MUST_NOT_EXIST;

    }

    public static enum AttachmentStrategy {
        SEPARATE_DOCUMENTS,
        PARENT_CHILD;

    }
}

