/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.ml.clustering.FuzzyKMeansClusterer;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.solr.client.solrj.io.eval.KmeansEvaluator;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.ZplotStream;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FuzzyKmeansEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;
    private int maxIterations = 1000;
    private double fuzziness = 1.2;

    public FuzzyKmeansEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("fuzziness")) {
                this.fuzziness = Double.parseDouble(namedParam.getParameter().toString().trim());
                continue;
            }
            if (namedParam.getName().equals("maxIterations")) {
                this.maxIterations = Integer.parseInt(namedParam.getParameter().toString().trim());
                continue;
            }
            throw new IOException("Unexpected named parameter:" + namedParam.getName());
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        Matrix matrix = null;
        int k = 0;
        if (!(value1 instanceof Matrix)) {
            throw new IOException("The first parameter for fuzzyKmeans should be the observation matrix.");
        }
        matrix = (Matrix)value1;
        if (!(value2 instanceof Number)) {
            throw new IOException("The second parameter for fuzzyKmeans should be k.");
        }
        k = ((Number)value2).intValue();
        FuzzyKMeansClusterer kmeans = new FuzzyKMeansClusterer(k, this.fuzziness, this.maxIterations, new EuclideanDistance());
        ArrayList<KmeansEvaluator.ClusterPoint> points = new ArrayList<KmeansEvaluator.ClusterPoint>();
        double[][] data = matrix.getData();
        List<String> ids = matrix.getRowLabels();
        for (int i = 0; i < data.length; ++i) {
            double[] vec = data[i];
            points.add(new KmeansEvaluator.ClusterPoint(ids.get(i), vec));
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("k", k);
        fields.put("fuzziness", this.fuzziness);
        fields.put("distance", "euclidean");
        fields.put("maxIterations", this.maxIterations);
        List<CentroidCluster<KmeansEvaluator.ClusterPoint>> clusters = kmeans.cluster(points);
        RealMatrix realMatrix = kmeans.getMembershipMatrix();
        double[][] mmData = realMatrix.getData();
        Matrix mmMatrix = new Matrix(mmData);
        mmMatrix.setRowLabels(matrix.getRowLabels());
        ArrayList<String> clusterCols = new ArrayList<String>();
        for (int i = 0; i < clusters.size(); ++i) {
            clusterCols.add("cluster" + ZplotStream.pad(Integer.toString(i), clusters.size()));
        }
        mmMatrix.setRowLabels(clusterCols);
        return new KmeansEvaluator.ClusterTuple(fields, clusters, matrix.getColumnLabels(), mmMatrix);
    }
}

