/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.util.Precision;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.CosineSimilarityEvaluator;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class CosineDistanceEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;

    public CosineDistanceEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    public CosineDistanceEvaluator(StreamExpression expression, StreamFactory factory, List<String> ignoredNamedParameters) throws IOException {
        super(expression, factory, ignoredNamedParameters);
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        return new CosineDistance();
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        throw new IOException("This call should never occur");
    }

    public static class CosineDistance
    implements DistanceMeasure {
        private static final long serialVersionUID = -9108154600539125566L;

        @Override
        public double compute(double[] v1, double[] v2) throws DimensionMismatchException {
            return Precision.round(1.0 - Math.abs(CosineSimilarityEvaluator.cosineSimilarity(v1, v2)), 8);
        }
    }
}

