/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.serialization.TikaSerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaJsonSerializer {
    public static String INSTANTIATED_CLASS_KEY = "_class";
    static Set<Class> PRIMITIVES = Set.of(Integer.TYPE, Double.TYPE, Float.TYPE, Long.TYPE, Short.TYPE, Boolean.TYPE, String.class, Byte.TYPE, Character.TYPE);
    static Set<Class> BOXED = Set.of(Integer.class, Double.class, Float.class, Long.class, Short.class, Boolean.class, Byte.class, Character.class);
    static String SET = "set";
    private static Logger LOG = LoggerFactory.getLogger(TikaJsonSerializer.class);
    private static String GET = "get";
    private static String IS = "is";

    public static void serialize(Object obj, JsonGenerator jsonGenerator) throws TikaSerializationException, IOException {
        TikaJsonSerializer.serialize(null, obj, jsonGenerator);
    }

    public static void serialize(String fieldName, Object obj, JsonGenerator jsonGenerator) throws TikaSerializationException, IOException {
        if (obj == null) {
            if (fieldName == null) {
                jsonGenerator.writeNull();
            } else {
                jsonGenerator.writeNullField(fieldName);
            }
        } else if (PRIMITIVES.contains(obj.getClass()) || BOXED.contains(obj.getClass())) {
            try {
                TikaJsonSerializer.serializePrimitiveAndBoxed(fieldName, obj, jsonGenerator);
            }
            catch (IOException e) {
                throw new TikaSerializationException("problem serializing", e);
            }
        } else if (TikaJsonSerializer.isCollection(obj)) {
            TikaJsonSerializer.serializeCollection(fieldName, obj, jsonGenerator);
        } else if (obj.getClass().isEnum()) {
            jsonGenerator.writeStringField(fieldName, ((Enum)obj).name());
        } else {
            TikaJsonSerializer.serializeObject(fieldName, obj, jsonGenerator);
        }
    }

    private static boolean isCollection(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz.isArray() || List.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    public static void serializeObject(String fieldName, Object obj, JsonGenerator jsonGenerator) throws TikaSerializationException {
        try {
            Constructor<?> constructor = obj.getClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("class (" + obj.getClass() + ") doesn't have a no-arg constructor. Respectfully not serializing.");
        }
        try {
            if (fieldName != null) {
                jsonGenerator.writeFieldName(fieldName);
            }
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(INSTANTIATED_CLASS_KEY, obj.getClass().getName());
            Map<String, Method> matches = TikaJsonSerializer.getGetters(obj.getClass().getMethods());
            for (Map.Entry<String, Method> e : matches.entrySet()) {
                try {
                    Object methodVal = e.getValue().invoke(obj, new Object[0]);
                    TikaJsonSerializer.serialize(e.getKey(), methodVal, jsonGenerator);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    throw new TikaSerializationException("couldn't write paramName=" + e.getKey(), ex);
                }
            }
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new TikaSerializationException("couldn't serialize", e);
        }
    }

    private static Map<String, Method> getGetters(Method[] methods) {
        HashMap<String, List<Method>> getters = new HashMap<String, List<Method>>();
        HashMap<String, List<Method>> setters = new HashMap<String, List<Method>>();
        for (Method m : methods) {
            String param;
            String name = m.getName();
            if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
                param = TikaJsonSerializer.getParam(GET, name);
                TikaJsonSerializer.add(param, m, getters);
                continue;
            }
            if (name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) {
                param = TikaJsonSerializer.getParam(IS, name);
                TikaJsonSerializer.add(param, m, getters);
                continue;
            }
            if (!name.startsWith("set") || name.length() <= 3 || !Character.isUpperCase(name.charAt(3)) || m.getParameters().length != 1) continue;
            param = TikaJsonSerializer.getParam(SET, name);
            TikaJsonSerializer.add(param, m, setters);
        }
        HashMap<String, Method> ret = new HashMap<String, Method>();
        for (Map.Entry e : getters.entrySet()) {
            String paramName = (String)e.getKey();
            if ("class".equals(paramName)) continue;
            List setterList = (List)setters.get(paramName);
            if (setterList == null || setterList.size() == 0) {
                LOG.debug("Couldn't find setter for getter: " + paramName);
                continue;
            }
            for (Method getter : (List)e.getValue()) {
                for (Method setter : setterList) {
                    Class<?> setClass = setter.getParameters()[0].getType();
                    if (!getter.getReturnType().equals(setClass)) continue;
                    ret.put(paramName, getter);
                }
            }
        }
        return ret;
    }

    private static void serializeCollection(String fieldName, Object obj, JsonGenerator jsonGenerator) throws IOException, TikaSerializationException {
        Class<?> clazz;
        if (fieldName != null) {
            jsonGenerator.writeFieldName(fieldName);
        }
        if ((clazz = obj.getClass()).isArray()) {
            jsonGenerator.writeStartArray();
            for (Object item : (Object[])obj) {
                TikaJsonSerializer.serialize(item, jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        } else if (List.class.isAssignableFrom(clazz)) {
            jsonGenerator.writeStartArray();
            for (Object item : (List)obj) {
                TikaJsonSerializer.serialize(item, jsonGenerator);
            }
            jsonGenerator.writeEndArray();
        } else if (Map.class.isAssignableFrom(clazz)) {
            jsonGenerator.writeStartObject();
            for (Map.Entry e : ((Map)obj).entrySet()) {
                TikaJsonSerializer.serialize((String)e.getKey(), e.getValue(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        } else {
            throw new UnsupportedOperationException("Should have been a collection?! " + clazz);
        }
    }

    private static void serializePrimitiveAndBoxed(String paramName, Object obj, JsonGenerator jsonGenerator) throws IOException {
        Class<?> clazz = obj.getClass();
        if (paramName != null) {
            jsonGenerator.writeFieldName(paramName);
        }
        if (clazz.equals(String.class)) {
            jsonGenerator.writeString((String)obj);
        } else if (clazz.equals(Integer.class)) {
            jsonGenerator.writeNumber((Integer)obj);
        } else if (clazz.equals(Short.class)) {
            jsonGenerator.writeNumber((Short)obj);
        } else if (clazz.equals(Long.class)) {
            jsonGenerator.writeNumber((Long)obj);
        } else if (clazz.equals(Float.class)) {
            jsonGenerator.writeNumber(((Float)obj).floatValue());
        } else if (clazz.equals(Double.class)) {
            jsonGenerator.writeNumber((Double)obj);
        } else if (clazz.equals(Boolean.class)) {
            jsonGenerator.writeBoolean((Boolean)obj);
        } else if (clazz.equals(Short.TYPE)) {
            jsonGenerator.writeNumber((Short)obj);
        } else if (clazz.equals(Integer.TYPE)) {
            jsonGenerator.writeNumber((Integer)obj);
        } else if (clazz.equals(Long.TYPE)) {
            jsonGenerator.writeNumber((Long)obj);
        } else if (clazz.equals(Float.TYPE)) {
            jsonGenerator.writeNumber(((Float)obj).floatValue());
        } else if (clazz.equals(Double.TYPE)) {
            jsonGenerator.writeNumber((Double)obj);
        } else if (clazz.equals(Boolean.TYPE)) {
            jsonGenerator.writeBoolean((Boolean)obj);
        } else {
            throw new UnsupportedOperationException("I regret that I don't yet support " + clazz);
        }
    }

    private static void add(String param, Method method, Map<String, List<Method>> map) {
        List<Method> methods = map.get(param);
        if (methods == null) {
            methods = new ArrayList<Method>();
            map.put(param, methods);
        }
        methods.add(method);
    }

    static String getParam(String prefix, String name) {
        Object ret = name.substring(prefix.length());
        ret = ((String)ret).substring(0, 1).toLowerCase(Locale.ROOT) + ((String)ret).substring(1);
        return ret;
    }
}

