/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.opensearch;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tika.client.HttpClientFactory;
import org.apache.tika.client.TikaClientException;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.emitter.AbstractEmitter;
import org.apache.tika.pipes.emitter.EmitData;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.apache.tika.pipes.emitter.opensearch.OpenSearchClient;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchEmitter
extends AbstractEmitter
implements Initializable {
    public static String DEFAULT_EMBEDDED_FILE_FIELD_NAME = "embedded";
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchEmitter.class);
    private AttachmentStrategy attachmentStrategy = AttachmentStrategy.PARENT_CHILD;
    private UpdateStrategy updateStrategy = UpdateStrategy.OVERWRITE;
    private String openSearchUrl = null;
    private String idField = "_id";
    private int commitWithin = 1000;
    private OpenSearchClient openSearchClient;
    private final HttpClientFactory httpClientFactory;
    private String embeddedFileFieldName = DEFAULT_EMBEDDED_FILE_FIELD_NAME;

    public OpenSearchEmitter() throws TikaConfigException {
        this.httpClientFactory = new HttpClientFactory();
    }

    public void emit(List<? extends EmitData> emitData) throws IOException, TikaEmitterException {
        if (emitData == null || emitData.size() == 0) {
            LOG.debug("metadataList is null or empty");
            return;
        }
        try {
            LOG.debug("about to emit {} docs", (Object)emitData.size());
            this.openSearchClient.emitDocuments(emitData);
            LOG.info("successfully emitted {} docs", (Object)emitData.size());
        }
        catch (TikaClientException e) {
            LOG.warn("problem emitting docs", (Throwable)((Object)e));
            throw new TikaEmitterException(e.getMessage());
        }
    }

    public void emit(String emitKey, List<Metadata> metadataList, ParseContext parseContext) throws IOException, TikaEmitterException {
        if (metadataList == null || metadataList.size() == 0) {
            LOG.debug("metadataList is null or empty");
            return;
        }
        try {
            LOG.debug("about to emit one doc");
            this.openSearchClient.emitDocument(emitKey, metadataList);
            LOG.info("successfully emitted one doc");
        }
        catch (TikaClientException e) {
            LOG.warn("problem emitting doc", (Throwable)((Object)e));
            throw new TikaEmitterException("failed to add document", (Throwable)((Object)e));
        }
    }

    @Field
    public void setAttachmentStrategy(String attachmentStrategy) {
        this.attachmentStrategy = AttachmentStrategy.valueOf(attachmentStrategy);
    }

    @Field
    public void setConnectionTimeout(int connectionTimeout) {
        this.httpClientFactory.setConnectTimeout(connectionTimeout);
    }

    @Field
    public void setSocketTimeout(int socketTimeout) {
        this.httpClientFactory.setSocketTimeout(socketTimeout);
    }

    public int getCommitWithin() {
        return this.commitWithin;
    }

    @Field
    public void setCommitWithin(int commitWithin) {
        this.commitWithin = commitWithin;
    }

    @Field
    public void setIdField(String idField) {
        this.idField = idField;
    }

    @Field
    public void setOpenSearchUrl(String openSearchUrl) {
        this.openSearchUrl = openSearchUrl;
    }

    @Field
    public void setUserName(String userName) {
        this.httpClientFactory.setUserName(userName);
    }

    @Field
    public void setPassword(String password) {
        this.httpClientFactory.setPassword(password);
    }

    @Field
    public void setAuthScheme(String authScheme) {
        this.httpClientFactory.setAuthScheme(authScheme);
    }

    @Field
    public void setProxyHost(String proxyHost) {
        this.httpClientFactory.setProxyHost(proxyHost);
    }

    @Field
    public void setProxyPort(int proxyPort) {
        this.httpClientFactory.setProxyPort(proxyPort);
    }

    public void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public void setUpdateStrategy(String strategy) throws TikaConfigException {
        switch (strategy.toLowerCase(Locale.US)) {
            case "overwrite": {
                this.setUpdateStrategy(UpdateStrategy.OVERWRITE);
                break;
            }
            case "upsert": {
                this.setUpdateStrategy(UpdateStrategy.UPSERT);
                break;
            }
            default: {
                throw new TikaConfigException("'overwrite' and 'upsert' are the two options so far. I regret I don't understand: " + strategy);
            }
        }
    }

    @Field
    public void setEmbeddedFileFieldName(String embeddedFileFieldName) {
        this.embeddedFileFieldName = embeddedFileFieldName;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        if (StringUtils.isBlank((String)this.openSearchUrl)) {
            throw new TikaConfigException("Must specify an open search url!");
        }
        this.openSearchClient = new OpenSearchClient(this.openSearchUrl, this.httpClientFactory.build(), this.attachmentStrategy, this.updateStrategy, this.embeddedFileFieldName);
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"openSearchUrl", (String)this.openSearchUrl);
        TikaConfig.mustNotBeEmpty((String)"idField", (String)this.idField);
    }

    public static enum AttachmentStrategy {
        SEPARATE_DOCUMENTS,
        PARENT_CHILD;

    }

    public static enum UpdateStrategy {
        OVERWRITE,
        UPSERT;

    }
}

