/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.opensearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.tika.client.TikaClientException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.emitter.EmitData;
import org.apache.tika.pipes.emitter.opensearch.JsonResponse;
import org.apache.tika.pipes.emitter.opensearch.OpenSearchEmitter;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchClient {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchEmitter.class);
    protected final String openSearchUrl;
    protected final HttpClient httpClient;
    private final OpenSearchEmitter.AttachmentStrategy attachmentStrategy;
    private final MetadataToJsonWriter metadataToJsonWriter;
    private final String embeddedFileFieldName;

    protected OpenSearchClient(String openSearchUrl, HttpClient httpClient, OpenSearchEmitter.AttachmentStrategy attachmentStrategy, OpenSearchEmitter.UpdateStrategy updateStrategy, String embeddedFileFieldName) {
        this.openSearchUrl = openSearchUrl;
        this.httpClient = httpClient;
        this.attachmentStrategy = attachmentStrategy;
        this.metadataToJsonWriter = updateStrategy == OpenSearchEmitter.UpdateStrategy.OVERWRITE ? new InsertMetadataToJsonWriter() : new UpsertMetadataToJsonWriter();
        this.embeddedFileFieldName = embeddedFileFieldName;
    }

    public void emitDocuments(List<? extends EmitData> emitData) throws IOException, TikaClientException {
        StringBuilder json = new StringBuilder();
        for (EmitData emitData2 : emitData) {
            this.appendDoc(emitData2.getEmitKey().getEmitKey(), emitData2.getMetadataList(), json);
        }
        this.emitJson(json);
    }

    private void emitJson(StringBuilder json) throws IOException, TikaClientException {
        String requestUrl = this.openSearchUrl + "/_bulk";
        JsonResponse response = this.postJson(requestUrl, json.toString());
        if (response.getStatus() != 200) {
            throw new TikaClientException(response.getMsg());
        }
        JsonNode errorNode = response.getJson().get("errors");
        if (errorNode.asText().equals("true")) {
            throw new TikaClientException(response.getJson().toString());
        }
    }

    public void emitDocument(String emitKey, List<Metadata> metadataList) throws IOException, TikaClientException {
        StringBuilder json = new StringBuilder();
        this.appendDoc(emitKey, metadataList, json);
        this.emitJson(json);
    }

    private void appendDoc(String emitKey, List<Metadata> metadataList, StringBuilder json) throws IOException {
        int i = 0;
        String routing = this.attachmentStrategy == OpenSearchEmitter.AttachmentStrategy.PARENT_CHILD ? emitKey : null;
        for (Metadata metadata : metadataList) {
            StringBuilder id = new StringBuilder(emitKey);
            if (i > 0) {
                id.append("-").append(UUID.randomUUID());
            }
            String indexJson = this.metadataToJsonWriter.getBulkJson(id.toString(), routing);
            json.append(indexJson).append("\n");
            if (i == 0) {
                json.append(this.metadataToJsonWriter.writeContainer(metadata, this.attachmentStrategy));
            } else {
                json.append(this.metadataToJsonWriter.writeEmbedded(metadata, this.attachmentStrategy, emitKey, this.embeddedFileFieldName));
            }
            json.append("\n");
            ++i;
        }
    }

    protected static String metadataToJsonContainerInsert(Metadata metadata, OpenSearchEmitter.AttachmentStrategy attachmentStrategy) throws IOException {
        return new InsertMetadataToJsonWriter().writeContainer(metadata, attachmentStrategy);
    }

    protected static String metadataToJsonEmbeddedInsert(Metadata metadata, OpenSearchEmitter.AttachmentStrategy attachmentStrategy, String emitKey, String embeddedFileFieldName) throws IOException {
        return new InsertMetadataToJsonWriter().writeEmbedded(metadata, attachmentStrategy, emitKey, embeddedFileFieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonResponse postJson(String url, String json) throws IOException {
        HttpPost httpRequest = new HttpPost(url);
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("Content-type", "application/json; charset=utf-8");
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(httpRequest);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));){
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode node = mapper.readTree(reader);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("node: {}", (Object)node);
                    }
                    JsonResponse jsonResponse = new JsonResponse(200, node);
                    return jsonResponse;
                }
            }
            JsonResponse jsonResponse = new JsonResponse(status, new String(EntityUtils.toByteArray(response.getEntity()), StandardCharsets.UTF_8));
            return jsonResponse;
        }
        finally {
            if (response != null && response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)response).close();
            }
            httpRequest.releaseConnection();
        }
    }

    private static void writeMetadata(Metadata metadata, JsonGenerator jsonGenerator) throws IOException {
        for (String n : metadata.names()) {
            String[] vals = metadata.getValues(n);
            if (vals.length == 1) {
                jsonGenerator.writeStringField(n, vals[0]);
                continue;
            }
            jsonGenerator.writeArrayFieldStart(n);
            for (String v : vals) {
                jsonGenerator.writeString(v);
            }
            jsonGenerator.writeEndArray();
        }
    }

    private static class InsertMetadataToJsonWriter
    implements MetadataToJsonWriter {
        private InsertMetadataToJsonWriter() {
        }

        @Override
        public String writeContainer(Metadata metadata, OpenSearchEmitter.AttachmentStrategy attachmentStrategy) throws IOException {
            StringWriter writer = new StringWriter();
            try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
                jsonGenerator.writeStartObject();
                OpenSearchClient.writeMetadata(metadata, jsonGenerator);
                if (attachmentStrategy == OpenSearchEmitter.AttachmentStrategy.PARENT_CHILD) {
                    jsonGenerator.writeStringField("relation_type", "container");
                }
                jsonGenerator.writeEndObject();
            }
            return writer.toString();
        }

        @Override
        public String writeEmbedded(Metadata metadata, OpenSearchEmitter.AttachmentStrategy attachmentStrategy, String emitKey, String embeddedFileFieldName) throws IOException {
            StringWriter writer = new StringWriter();
            try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
                jsonGenerator.writeStartObject();
                OpenSearchClient.writeMetadata(metadata, jsonGenerator);
                if (attachmentStrategy == OpenSearchEmitter.AttachmentStrategy.PARENT_CHILD) {
                    jsonGenerator.writeObjectFieldStart("relation_type");
                    jsonGenerator.writeStringField("name", embeddedFileFieldName);
                    jsonGenerator.writeStringField("parent", emitKey);
                    jsonGenerator.writeEndObject();
                } else if (attachmentStrategy == OpenSearchEmitter.AttachmentStrategy.SEPARATE_DOCUMENTS) {
                    jsonGenerator.writeStringField("parent", emitKey);
                }
                jsonGenerator.writeEndObject();
            }
            return writer.toString();
        }

        @Override
        public String getBulkJson(String id, String routing) throws IOException {
            StringWriter writer = new StringWriter();
            try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectFieldStart("index");
                jsonGenerator.writeStringField("_id", id);
                if (!StringUtils.isEmpty((CharSequence)routing)) {
                    jsonGenerator.writeStringField("routing", routing);
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.writeEndObject();
            }
            return writer.toString();
        }
    }

    private static class UpsertMetadataToJsonWriter
    implements MetadataToJsonWriter {
        private UpsertMetadataToJsonWriter() {
        }

        @Override
        public String writeContainer(Metadata metadata, OpenSearchEmitter.AttachmentStrategy attachmentStrategy) throws IOException {
            StringWriter writer = new StringWriter();
            try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectFieldStart("doc");
                OpenSearchClient.writeMetadata(metadata, jsonGenerator);
                if (attachmentStrategy == OpenSearchEmitter.AttachmentStrategy.PARENT_CHILD) {
                    jsonGenerator.writeStringField("relation_type", "container");
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.writeBooleanField("doc_as_upsert", true);
                jsonGenerator.writeEndObject();
            }
            return writer.toString();
        }

        @Override
        public String writeEmbedded(Metadata metadata, OpenSearchEmitter.AttachmentStrategy attachmentStrategy, String emitKey, String embeddedFileFieldName) throws IOException {
            StringWriter writer = new StringWriter();
            try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectFieldStart("doc");
                OpenSearchClient.writeMetadata(metadata, jsonGenerator);
                if (attachmentStrategy == OpenSearchEmitter.AttachmentStrategy.PARENT_CHILD) {
                    jsonGenerator.writeObjectFieldStart("relation_type");
                    jsonGenerator.writeStringField("name", embeddedFileFieldName);
                    jsonGenerator.writeStringField("parent", emitKey);
                    jsonGenerator.writeEndObject();
                } else if (attachmentStrategy == OpenSearchEmitter.AttachmentStrategy.SEPARATE_DOCUMENTS) {
                    jsonGenerator.writeStringField("parent", emitKey);
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.writeBooleanField("doc_as_upsert", true);
                jsonGenerator.writeEndObject();
            }
            return writer.toString();
        }

        @Override
        public String getBulkJson(String id, String routing) throws IOException {
            StringWriter writer = new StringWriter();
            try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectFieldStart("update");
                jsonGenerator.writeStringField("_id", id);
                if (!StringUtils.isEmpty((CharSequence)routing)) {
                    jsonGenerator.writeStringField("routing", routing);
                }
                jsonGenerator.writeNumberField("retry_on_conflict", 3);
                jsonGenerator.writeEndObject();
                jsonGenerator.writeEndObject();
            }
            return writer.toString();
        }
    }

    private static interface MetadataToJsonWriter {
        public String writeContainer(Metadata var1, OpenSearchEmitter.AttachmentStrategy var2) throws IOException;

        public String writeEmbedded(Metadata var1, OpenSearchEmitter.AttachmentStrategy var2, String var3, String var4) throws IOException;

        public String getBulkJson(String var1, String var2) throws IOException;
    }
}

