/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.opensearch;

import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.emitter.opensearch.OpenSearchClient;
import org.apache.tika.pipes.emitter.opensearch.OpenSearchEmitter;
import org.junit.jupiter.api.Test;

public class OpenSearchClientTest
extends TikaTest {
    @Test
    public void testSerialization() throws Exception {
        String json;
        Metadata metadata = new Metadata();
        metadata.add("authors", "author1");
        metadata.add("authors", "author2");
        metadata.add("title", "title1");
        for (OpenSearchEmitter.AttachmentStrategy strategy : OpenSearchEmitter.AttachmentStrategy.values()) {
            json = OpenSearchClient.metadataToJsonContainerInsert((Metadata)metadata, (OpenSearchEmitter.AttachmentStrategy)strategy);
            OpenSearchClientTest.assertContains((String)"author1", (String)json);
            OpenSearchClientTest.assertContains((String)"author2", (String)json);
            OpenSearchClientTest.assertContains((String)"authors", (String)json);
            OpenSearchClientTest.assertContains((String)"title1", (String)json);
        }
        for (OpenSearchEmitter.AttachmentStrategy strategy : OpenSearchEmitter.AttachmentStrategy.values()) {
            json = OpenSearchClient.metadataToJsonEmbeddedInsert((Metadata)metadata, (OpenSearchEmitter.AttachmentStrategy)strategy, (String)"myEmitKey", (String)OpenSearchEmitter.DEFAULT_EMBEDDED_FILE_FIELD_NAME);
            OpenSearchClientTest.assertContains((String)"author1", (String)json);
            OpenSearchClientTest.assertContains((String)"author2", (String)json);
            OpenSearchClientTest.assertContains((String)"authors", (String)json);
            OpenSearchClientTest.assertContains((String)"title1", (String)json);
        }
    }
}

