/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.emitter.AbstractEmitter;
import org.apache.tika.pipes.emitter.EmitData;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCEmitter
extends AbstractEmitter
implements Initializable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCEmitter.class);
    private static final String[] TIKA_DATE_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss"};
    private static ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static Set<String> TABLES_CREATED = new HashSet<String>();
    private String connectionString;
    private Optional<String> postConnectionString = Optional.empty();
    private String insert;
    private String createTable;
    private String alterTable;
    private int maxRetries = 0;
    private Map<String, String> keys;
    private List<ColumnDefinition> columns;
    private Connection connection;
    private PreparedStatement insertStatement;
    private AttachmentStrategy attachmentStrategy = AttachmentStrategy.FIRST_ONLY;
    private MultivaluedFieldStrategy multivaluedFieldStrategy = MultivaluedFieldStrategy.CONCATENATE;
    private String multivaluedFieldDelimiter = ", ";
    private final DateFormat[] dateFormats = new DateFormat[TIKA_DATE_PATTERNS.length];
    private int maxStringLength = 64000;
    private StringNormalizer stringNormalizer;

    public JDBCEmitter() {
        int i = 0;
        for (String p : TIKA_DATE_PATTERNS) {
            this.dateFormats[i++] = new SimpleDateFormat(p, Locale.US);
        }
    }

    public void setAlterTable(String alterTable) {
        this.alterTable = alterTable;
    }

    @Field
    public void setCreateTable(String createTable) {
        this.createTable = createTable;
    }

    @Field
    public void setInsert(String insert) {
        this.insert = insert;
    }

    @Field
    public void setConnection(String connection) {
        this.connectionString = connection;
    }

    @Field
    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Field
    public void setPostConnection(String postConnection) {
        this.postConnectionString = Optional.of(postConnection);
    }

    @Field
    public void setMultivaluedFieldStrategy(String strategy) throws TikaConfigException {
        String lc = strategy.toLowerCase(Locale.US);
        if (lc.equals("first_only")) {
            this.setMultivaluedFieldStrategy(MultivaluedFieldStrategy.FIRST_ONLY);
        } else if (lc.equals("concatenate")) {
            this.setMultivaluedFieldStrategy(MultivaluedFieldStrategy.CONCATENATE);
        } else {
            throw new TikaConfigException("I'm sorry, I only recogize 'first_only' and 'concatenate'. I don't mind '" + strategy + "'");
        }
    }

    public void setMultivaluedFieldStrategy(MultivaluedFieldStrategy multivaluedFieldStrategy) {
        this.multivaluedFieldStrategy = multivaluedFieldStrategy;
    }

    @Field
    public void setMultivaluedFieldDelimiter(String delimiter) {
        this.multivaluedFieldDelimiter = delimiter;
    }

    @Field
    public void setKeys(Map<String, String> keys) {
        this.keys = keys;
    }

    public void setAttachmentStrategy(AttachmentStrategy attachmentStrategy) {
        this.attachmentStrategy = attachmentStrategy;
    }

    @Field
    public void setAttachmentStrategy(String attachmentStrategy) {
        if ("all".equalsIgnoreCase(attachmentStrategy)) {
            this.setAttachmentStrategy(AttachmentStrategy.ALL);
        } else if ("first_only".equalsIgnoreCase(attachmentStrategy)) {
            this.setAttachmentStrategy(AttachmentStrategy.FIRST_ONLY);
        } else {
            throw new IllegalArgumentException("attachmentStrategy must be 'all' or 'first_only'");
        }
    }

    public void emit(String emitKey, List<Metadata> metadataList) throws IOException, TikaEmitterException {
        if (metadataList == null || metadataList.size() < 1) {
            return;
        }
        ArrayList<EmitData> emitDataList = new ArrayList<EmitData>();
        emitDataList.add(new EmitData(new EmitKey("", emitKey), metadataList));
        this.emit(emitDataList);
    }

    public void emit(List<? extends EmitData> emitData) throws IOException, TikaEmitterException {
        int tries = 0;
        SQLException ex = null;
        while (tries++ <= this.maxRetries) {
            try {
                this.emitNow(emitData);
                return;
            }
            catch (SQLException e) {
                try {
                    this.reconnect();
                }
                catch (SQLException exc) {
                    throw new TikaEmitterException("couldn't reconnect!", (Throwable)exc);
                }
                ex = e;
            }
        }
        throw new TikaEmitterException("Couldn't emit " + emitData.size() + " records.", ex);
    }

    private void emitNow(List<? extends EmitData> emitData) throws SQLException {
        if (this.attachmentStrategy == AttachmentStrategy.FIRST_ONLY) {
            for (EmitData emitData2 : emitData) {
                this.insertFirstOnly(emitData2.getEmitKey().getEmitKey(), emitData2.getMetadataList());
                this.insertStatement.addBatch();
            }
        } else {
            for (EmitData emitData3 : emitData) {
                this.insertAll(emitData3.getEmitKey().getEmitKey(), emitData3.getMetadataList());
            }
        }
        this.insertStatement.executeBatch();
    }

    private void insertAll(String emitKey, List<Metadata> metadataList) throws SQLException {
        for (int i = 0; i < metadataList.size(); ++i) {
            this.insertStatement.clearParameters();
            int col = 0;
            this.insertStatement.setString(++col, emitKey);
            this.insertStatement.setInt(++col, i);
            for (ColumnDefinition columnDefinition : this.columns) {
                this.updateValue(emitKey, this.insertStatement, ++col, columnDefinition, i, metadataList);
            }
            this.insertStatement.addBatch();
        }
    }

    private void insertFirstOnly(String emitKey, List<Metadata> metadataList) throws SQLException {
        this.insertStatement.clearParameters();
        int i = 0;
        DateFormat[] dateFormats = new DateFormat[TIKA_DATE_PATTERNS.length];
        for (int j = 0; j < TIKA_DATE_PATTERNS.length; ++j) {
            dateFormats[i] = new SimpleDateFormat(TIKA_DATE_PATTERNS[j], Locale.US);
        }
        this.insertStatement.setString(++i, emitKey);
        for (ColumnDefinition columnDefinition : this.columns) {
            this.updateValue(emitKey, this.insertStatement, ++i, columnDefinition, 0, metadataList);
        }
    }

    private void reconnect() throws SQLException {
        SQLException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.tryClose();
                this.createConnection();
                this.insertStatement = this.connection.prepareStatement(this.insert);
                return;
            }
            catch (SQLException e) {
                LOGGER.warn("couldn't reconnect to db", (Throwable)e);
                ex = e;
                continue;
            }
        }
        throw ex;
    }

    private void tryClose() {
        if (this.insertStatement != null) {
            try {
                this.insertStatement.close();
            }
            catch (SQLException e) {
                LOGGER.warn("exception closing insert", (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOGGER.warn("exception closing connection", (Throwable)e);
            }
        }
    }

    private void createConnection() throws SQLException {
        this.connection = DriverManager.getConnection(this.connectionString);
        if (this.postConnectionString.isPresent()) {
            try (Statement st = this.connection.createStatement();){
                st.execute(this.postConnectionString.get());
            }
        }
    }

    private void updateValue(String emitKey, PreparedStatement insertStatement, int i, ColumnDefinition columnDefinition, int metadataListIndex, List<Metadata> metadataList) throws SQLException {
        Metadata metadata = metadataList.get(metadataListIndex);
        String val = this.getVal(metadata, columnDefinition);
        switch (columnDefinition.getType()) {
            case 12: {
                this.updateVarchar(emitKey, columnDefinition, insertStatement, i, val);
                break;
            }
            case 16: {
                this.updateBoolean(insertStatement, i, val);
                break;
            }
            case 4: {
                this.updateInteger(insertStatement, i, val);
                break;
            }
            case -5: {
                this.updateLong(insertStatement, i, val);
                break;
            }
            case 6: {
                this.updateFloat(insertStatement, i, val);
                break;
            }
            case 8: {
                this.updateDouble(insertStatement, i, val);
                break;
            }
            case 93: {
                this.updateTimestamp(insertStatement, i, val, this.dateFormats);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can only process:" + JDBCEmitter.getHandledTypes() + " types so far.  Please open a ticket to request: " + columnDefinition.getType() + " for " + columnDefinition.getColumnName());
            }
        }
    }

    private String getVal(Metadata metadata, ColumnDefinition columnDefinition) {
        if (columnDefinition.getType() != 12) {
            return metadata.get(columnDefinition.getColumnName());
        }
        if (this.multivaluedFieldStrategy == MultivaluedFieldStrategy.FIRST_ONLY) {
            return metadata.get(columnDefinition.getColumnName());
        }
        String[] vals = metadata.getValues(columnDefinition.getColumnName());
        if (vals.length == 0) {
            return null;
        }
        if (vals.length == 1) {
            return vals[0];
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (String val : metadata.getValues(columnDefinition.getColumnName())) {
            if (StringUtils.isBlank((String)val)) continue;
            if (i > 0) {
                sb.append(this.multivaluedFieldDelimiter);
            }
            sb.append(val);
            ++i;
        }
        return sb.toString();
    }

    private void updateDouble(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, 8);
            return;
        }
        Double d = Double.parseDouble(val);
        insertStatement.setDouble(i, d);
    }

    private void updateVarchar(String emitKey, ColumnDefinition columnDefinition, PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (val == null) {
            insertStatement.setNull(i, 12);
            return;
        }
        String normalized = this.stringNormalizer.normalize(emitKey, columnDefinition.getColumnName(), val, columnDefinition.getPrecision());
        insertStatement.setString(i, normalized);
    }

    private void updateTimestamp(PreparedStatement insertStatement, int i, String val, DateFormat[] dateFormats) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, 93);
            return;
        }
        for (DateFormat df : dateFormats) {
            try {
                Date d = df.parse(val);
                insertStatement.setTimestamp(i, new Timestamp(d.getTime()));
                return;
            }
            catch (ParseException parseException) {
            }
        }
        LOGGER.warn("Couldn't parse {}" + val);
        insertStatement.setNull(i, 93);
    }

    private void updateFloat(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, 6);
        } else {
            insertStatement.setFloat(i, Float.parseFloat(val));
        }
    }

    private void updateLong(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, -5);
        } else {
            insertStatement.setLong(i, Long.parseLong(val));
        }
    }

    private void updateInteger(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, 4);
        } else {
            insertStatement.setInt(i, Integer.parseInt(val));
        }
    }

    private void updateBoolean(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, 16);
        } else {
            insertStatement.setBoolean(i, Boolean.parseBoolean(val));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        block17: {
            this.parseColTypes();
            this.setStringNormalizer();
            try {
                this.createConnection();
            }
            catch (SQLException e) {
                throw new TikaConfigException("couldn't open connection: " + this.connectionString, (Throwable)e);
            }
            if (!StringUtils.isBlank((String)this.createTable)) {
                READ_WRITE_LOCK.writeLock().lock();
                try {
                    String tableCreationString = this.connectionString + " " + this.createTable;
                    if (TABLES_CREATED.contains(tableCreationString)) break block17;
                    try (Statement st = this.connection.createStatement();){
                        st.execute(this.createTable);
                        if (!StringUtils.isBlank((String)this.alterTable)) {
                            st.execute(this.alterTable);
                        }
                        TABLES_CREATED.add(tableCreationString);
                    }
                    catch (SQLException e) {
                        throw new TikaConfigException("can't create table", (Throwable)e);
                    }
                }
                finally {
                    READ_WRITE_LOCK.writeLock().unlock();
                }
            }
        }
        try {
            this.insertStatement = this.connection.prepareStatement(this.insert);
        }
        catch (SQLException e) {
            throw new TikaConfigException("can't create insert statement", (Throwable)e);
        }
    }

    private void setStringNormalizer() {
        this.stringNormalizer = this.connectionString.startsWith("jdbc:postgres") ? new PostgresNormalizer() : new StringNormalizer();
    }

    private void parseColTypes() {
        this.columns = new ArrayList<ColumnDefinition>();
        for (Map.Entry<String, String> e : this.keys.entrySet()) {
            this.columns.add(ColumnDefinition.parse(e.getKey(), e.getValue(), this.maxStringLength));
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.insertStatement.close();
        }
        catch (SQLException e) {
            LOGGER.warn("problem closing insert", (Throwable)e);
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    private static String getHandledTypes() {
        return "'string', 'varchar', 'boolean', 'int', 'long', 'float', 'double' and 'timestamp'";
    }

    private static class ColumnDefinition {
        private static final Matcher VARCHAR_MATCHER = Pattern.compile("varchar\\((\\d+)\\)").matcher("");
        private final String columnName;
        private final int type;
        private final int precision;

        private static ColumnDefinition parse(String name, String type, int maxStringLength) {
            String lcType = type.toLowerCase(Locale.US);
            if (VARCHAR_MATCHER.reset(lcType).find()) {
                return new ColumnDefinition(name, 12, Integer.parseInt(VARCHAR_MATCHER.group(1)));
            }
            switch (lcType) {
                case "string": {
                    return new ColumnDefinition(name, 12, maxStringLength);
                }
                case "bool": 
                case "boolean": {
                    return new ColumnDefinition(name, 16, -1);
                }
                case "int": 
                case "integer": {
                    return new ColumnDefinition(name, 4, -1);
                }
                case "bigint": 
                case "long": {
                    return new ColumnDefinition(name, -5, -1);
                }
                case "float": {
                    return new ColumnDefinition(name, 6, -1);
                }
                case "double": {
                    return new ColumnDefinition(name, 8, -1);
                }
                case "timestamp": {
                    return new ColumnDefinition(name, 93, -1);
                }
            }
            throw new IllegalArgumentException("Can only process: " + JDBCEmitter.getHandledTypes() + " types so far.  Please open a ticket to request " + type + " for column: " + name);
        }

        private ColumnDefinition(String columnName, int type, int precision) {
            this.columnName = columnName;
            this.type = type;
            this.precision = precision;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public int getType() {
            return this.type;
        }

        public int getPrecision() {
            return this.precision;
        }
    }

    private static class PostgresNormalizer
    extends StringNormalizer {
        private PostgresNormalizer() {
        }

        @Override
        String normalize(String emitKey, String columnName, String s, int maxLength) {
            s = s.replaceAll("\u0000", " ");
            return super.normalize(emitKey, columnName, s, maxLength);
        }
    }

    private static class StringNormalizer {
        private StringNormalizer() {
        }

        String normalize(String emitKey, String columnName, String s, int maxLength) {
            if (maxLength < 0 || s.length() < maxLength) {
                return s;
            }
            LOGGER.warn("truncating {}->'{}' from {} chars to {} chars", new Object[]{emitKey, columnName, s.length(), maxLength});
            return s.substring(0, maxLength);
        }
    }

    public static enum MultivaluedFieldStrategy {
        FIRST_ONLY,
        CONCATENATE;

    }

    public static enum AttachmentStrategy {
        FIRST_ONLY,
        ALL;

    }
}

