/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.emitter.AbstractEmitter;
import org.apache.tika.pipes.emitter.EmitData;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCEmitter
extends AbstractEmitter
implements Initializable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCEmitter.class);
    private static ReadWriteLock READ_WRITE_LOCK = new ReentrantReadWriteLock();
    private static Set<String> TABLES_CREATED = new HashSet<String>();
    private String connectionString;
    private String insert;
    private String createTable;
    private String alterTable;
    private Map<String, String> keys;
    private Connection connection;
    private PreparedStatement insertStatement;
    private AttachmentStrategy attachmentStrategy = AttachmentStrategy.FIRST_ONLY;

    public void setAlterTable(String alterTable) {
        this.alterTable = alterTable;
    }

    @Field
    public void setCreateTable(String createTable) {
        this.createTable = createTable;
    }

    @Field
    public void setInsert(String insert) {
        this.insert = insert;
    }

    @Field
    public void setConnection(String connectionString) {
        this.connectionString = connectionString;
    }

    @Field
    public void setKeys(Map<String, String> keys) {
        this.keys = keys;
    }

    public void setAttachmentStrategy(AttachmentStrategy attachmentStrategy) {
        this.attachmentStrategy = attachmentStrategy;
    }

    @Field
    public void setAttachmentStrategy(String attachmentStrategy) {
        if ("all".equalsIgnoreCase(attachmentStrategy)) {
            this.setAttachmentStrategy(AttachmentStrategy.ALL);
        } else if ("first_only".equalsIgnoreCase(attachmentStrategy)) {
            this.setAttachmentStrategy(AttachmentStrategy.FIRST_ONLY);
        } else {
            throw new IllegalArgumentException("attachmentStrategy must be 'all' or 'first_only'");
        }
    }

    public void emit(String emitKey, List<Metadata> metadataList) throws IOException, TikaEmitterException {
        if (metadataList == null || metadataList.size() < 1) {
            return;
        }
        try {
            if (this.attachmentStrategy == AttachmentStrategy.FIRST_ONLY) {
                this.insertFirstOnly(emitKey, metadataList);
                this.insertStatement.execute();
            } else {
                this.insertAll(emitKey, metadataList);
                this.insertStatement.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.warn("problem during emit; going to try to reconnect", (Throwable)e);
                this.reconnect();
            }
            catch (SQLException ex) {
                throw new TikaEmitterException("Couldn't reconnect!", (Throwable)ex);
            }
            throw new TikaEmitterException("couldn't emit", (Throwable)e);
        }
    }

    public void emit(List<? extends EmitData> emitData) throws IOException, TikaEmitterException {
        try {
            if (this.attachmentStrategy == AttachmentStrategy.FIRST_ONLY) {
                for (EmitData emitData2 : emitData) {
                    this.insertFirstOnly(emitData2.getEmitKey().getEmitKey(), emitData2.getMetadataList());
                    this.insertStatement.addBatch();
                }
            } else {
                for (EmitData emitData3 : emitData) {
                    this.insertAll(emitData3.getEmitKey().getEmitKey(), emitData3.getMetadataList());
                }
            }
            this.insertStatement.executeBatch();
        }
        catch (SQLException e) {
            try {
                LOGGER.warn("problem during emit; going to try to reconnect", (Throwable)e);
                this.reconnect();
            }
            catch (SQLException sQLException) {
                throw new TikaEmitterException("Couldn't reconnect!", (Throwable)sQLException);
            }
            throw new TikaEmitterException("couldn't emit", (Throwable)e);
        }
    }

    private void insertAll(String emitKey, List<Metadata> metadataList) throws SQLException {
        for (int i = 0; i < metadataList.size(); ++i) {
            this.insertStatement.clearParameters();
            int col = 0;
            this.insertStatement.setString(++col, emitKey);
            this.insertStatement.setInt(++col, i);
            for (Map.Entry<String, String> e : this.keys.entrySet()) {
                this.updateValue(this.insertStatement, ++col, e.getKey(), e.getValue(), i, metadataList);
            }
            this.insertStatement.addBatch();
        }
    }

    private void insertFirstOnly(String emitKey, List<Metadata> metadataList) throws SQLException {
        this.insertStatement.clearParameters();
        int i = 0;
        this.insertStatement.setString(++i, emitKey);
        for (Map.Entry<String, String> e : this.keys.entrySet()) {
            this.updateValue(this.insertStatement, ++i, e.getKey(), e.getValue(), 0, metadataList);
        }
    }

    private void reconnect() throws SQLException {
        SQLException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.connection = DriverManager.getConnection(this.connectionString);
                this.insertStatement = this.connection.prepareStatement(this.insert);
                return;
            }
            catch (SQLException e) {
                LOGGER.warn("couldn't reconnect to db", (Throwable)e);
                ex = e;
                continue;
            }
        }
        throw ex;
    }

    private void updateValue(PreparedStatement insertStatement, int i, String key, String type, int metadataListIndex, List<Metadata> metadataList) throws SQLException {
        Metadata metadata = metadataList.get(metadataListIndex);
        String val = metadata.get(key);
        switch (type) {
            case "string": {
                this.updateString(insertStatement, i, val);
                break;
            }
            case "bool": 
            case "boolean": {
                this.updateBoolean(insertStatement, i, val);
                break;
            }
            case "int": 
            case "integer": {
                this.updateInteger(insertStatement, i, val);
                break;
            }
            case "long": {
                this.updateLong(insertStatement, i, val);
                break;
            }
            case "float": {
                this.updateFloat(insertStatement, i, val);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can only process: 'string', 'boolean', 'int' and 'long' types so far.  Please open a ticket to request other types");
            }
        }
    }

    private void updateFloat(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, 6);
        } else {
            insertStatement.setFloat(i, Float.parseFloat(val));
        }
    }

    private void updateLong(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, -5);
        } else {
            insertStatement.setLong(i, Long.parseLong(val));
        }
    }

    private void updateInteger(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, 4);
        } else {
            insertStatement.setInt(i, Integer.parseInt(val));
        }
    }

    private void updateBoolean(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (StringUtils.isBlank((String)val)) {
            insertStatement.setNull(i, 16);
        } else {
            insertStatement.setBoolean(i, Boolean.parseBoolean(val));
        }
    }

    private void updateString(PreparedStatement insertStatement, int i, String val) throws SQLException {
        if (val == null) {
            insertStatement.setNull(i, 12);
        } else {
            insertStatement.setString(i, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Map<String, Param> params) throws TikaConfigException {
        block23: {
            try {
                this.connection = DriverManager.getConnection(this.connectionString);
            }
            catch (SQLException e) {
                throw new TikaConfigException("couldn't open connection: " + this.connectionString, (Throwable)e);
            }
            if (!StringUtils.isBlank((String)this.createTable)) {
                READ_WRITE_LOCK.writeLock().lock();
                try {
                    String tableCreationString = this.connectionString + " " + this.createTable;
                    if (TABLES_CREATED.contains(tableCreationString)) break block23;
                    try (Statement st = this.connection.createStatement();){
                        st.execute(this.createTable);
                        if (!StringUtils.isBlank((String)this.alterTable)) {
                            st.execute(this.alterTable);
                        }
                        TABLES_CREATED.add(tableCreationString);
                    }
                    catch (SQLException e) {
                        throw new TikaConfigException("can't create table", (Throwable)e);
                    }
                }
                finally {
                    READ_WRITE_LOCK.writeLock().unlock();
                }
            }
        }
        try {
            this.insertStatement = this.connection.prepareStatement(this.insert);
        }
        catch (SQLException e) {
            throw new TikaConfigException("can't create insert statement", (Throwable)e);
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public static enum AttachmentStrategy {
        FIRST_ONLY,
        ALL;

    }
}

