/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.emitter.gcs;

import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.emitter.AbstractEmitter;
import org.apache.tika.pipes.emitter.StreamEmitter;
import org.apache.tika.pipes.emitter.TikaEmitterException;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCSEmitter
extends AbstractEmitter
implements Initializable,
StreamEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GCSEmitter.class);
    private String projectId;
    private String bucket;
    private String fileExtension = "json";
    private String prefix = null;
    private Storage storage;

    public void emit(String emitKey, List<Metadata> metadataList, ParseContext parseContext) throws IOException, TikaEmitterException {
        if (metadataList == null || metadataList.size() == 0) {
            throw new TikaEmitterException("metadata list must not be null or of size 0");
        }
        try (UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();){
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);){
                JsonMetadataList.toJson(metadataList, (Writer)writer);
            }
            catch (IOException e) {
                throw new TikaEmitterException("can't jsonify", (Throwable)e);
            }
            this.write(emitKey, new Metadata(), bos.toByteArray());
        }
    }

    public void emit(String path, InputStream is, Metadata userMetadata, ParseContext parseContext) throws IOException, TikaEmitterException {
        if (is instanceof TikaInputStream && ((TikaInputStream)is).hasFile()) {
            this.write(path, userMetadata, Files.readAllBytes(((TikaInputStream)is).getPath()));
        } else {
            try (UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();){
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                this.write(path, userMetadata, bos.toByteArray());
            }
        }
    }

    private void write(String path, Metadata userMetadata, byte[] bytes) {
        if (!StringUtils.isBlank((String)this.prefix)) {
            path = this.prefix + "/" + (String)path;
        }
        if (!StringUtils.isBlank((String)this.fileExtension)) {
            path = (String)path + "." + this.fileExtension;
        }
        LOGGER.debug("about to emit to target bucket: ({}) path:({})", (Object)this.bucket, path);
        BlobId blobId = BlobId.of(this.bucket, (String)path);
        BlobInfo blobInfo = BlobInfo.newBuilder(blobId).build();
        for (String n : userMetadata.names()) {
            String[] vals = userMetadata.getValues(n);
            if (vals.length > 1) {
                LOGGER.warn("Can only write the first value for key {}. I see {} values.", (Object)n, (Object)vals.length);
            }
            blobInfo.getMetadata().put(n, vals[0]);
        }
        this.storage.create(blobInfo, bytes, new Storage.BlobTargetOption[0]);
    }

    @Field
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Field
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Field
    public void setPrefix(String prefix) {
        this.prefix = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
    }

    @Field
    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).build().getService();
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"bucket", (String)this.bucket);
        TikaConfig.mustNotBeEmpty((String)"projectId", (String)this.projectId);
    }
}

