/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.grpc.Internal;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public final class ProtobufJsonConverter {
    private ProtobufJsonConverter() {
    }

    public static Map<String, Object> convertToJson(Struct struct) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Value> entry : struct.getFieldsMap().entrySet()) {
            result.put(entry.getKey(), ProtobufJsonConverter.convertValue(entry.getValue()));
        }
        return result;
    }

    private static Object convertValue(Value value) {
        switch (value.getKindCase()) {
            case STRUCT_VALUE: {
                return ProtobufJsonConverter.convertToJson(value.getStructValue());
            }
            case LIST_VALUE: {
                return value.getListValue().getValuesList().stream().map(ProtobufJsonConverter::convertValue).collect(Collectors.toList());
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case NULL_VALUE: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown Value type: " + value.getKindCase());
    }
}

