/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.mock;

import org.apache.tika.batch.ConsumersManager;

public class MockConsumersManager
extends ConsumersManager {
    private final long HANG_MS = 30000L;
    private final ConsumersManager wrapped;
    private final boolean hangOnInit;
    private final boolean hangOnClose;

    public MockConsumersManager(ConsumersManager wrapped, boolean hangOnInit, boolean hangOnClose) {
        super(wrapped.getConsumers());
        this.wrapped = wrapped;
        this.hangOnInit = hangOnInit;
        this.hangOnClose = hangOnClose;
    }

    public void init() {
        if (this.hangOnInit) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                return;
            }
            return;
        }
        super.init();
    }

    public void shutdown() {
        if (this.hangOnClose) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                return;
            }
            return;
        }
        super.shutdown();
    }

    public long getConsumersManagerMaxMillis() {
        return this.wrapped.getConsumersManagerMaxMillis();
    }

    public void setConsumersManagerMaxMillis(long millis) {
        this.wrapped.setConsumersManagerMaxMillis(millis);
    }
}

